/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.TaggingWorkRequestErrorSummary;
import com.oracle.bmc.identity.requests.ListTaggingWorkRequestErrorsRequest;
import com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTaggingWorkRequestErrorsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListTaggingWorkRequestErrorsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListTaggingWorkRequestErrorsRequest interceptRequest(ListTaggingWorkRequestErrorsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListTaggingWorkRequestErrorsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("taggingWorkRequests").path(HttpUtils.encodePathSegment((String)request.getWorkRequestId())).path("errors");
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        return ib;
    }

    public static Function<Response, ListTaggingWorkRequestErrorsResponse> fromResponse() {
        Function<Response, ListTaggingWorkRequestErrorsResponse> transformer = new Function<Response, ListTaggingWorkRequestErrorsResponse>(){

            public ListTaggingWorkRequestErrorsResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                Optional retryAfterHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.ListTaggingWorkRequestErrorsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create((GenericType)new GenericType<List<TaggingWorkRequestErrorSummary>>(){});
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListTaggingWorkRequestErrorsResponse.Builder builder = ListTaggingWorkRequestErrorsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.items((List)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"retry-after")).isPresent()) {
                    builder.retryAfter((Float)HeaderUtils.toValue((String)"retry-after", (String)((String)((List)retryAfterHeader.get()).get(0)), Float.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListTaggingWorkRequestErrorsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

