/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.identity.model.IdpGroupMapping;
import com.oracle.bmc.identity.requests.UpdateIdpGroupMappingRequest;
import com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateIdpGroupMappingConverter {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateIdpGroupMappingConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static UpdateIdpGroupMappingRequest interceptRequest(UpdateIdpGroupMappingRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, UpdateIdpGroupMappingRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getIdentityProviderId(), (String)"identityProviderId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getMappingId(), (String)"mappingId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getUpdateIdpGroupMappingDetails(), (String)"updateIdpGroupMappingDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20160918").path("identityProviders").path(HttpUtils.encodePathSegment((String)request.getIdentityProviderId())).path("groupMappings").path(HttpUtils.encodePathSegment((String)request.getMappingId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getIfMatch() != null) {
            ib.header("if-match", (Object)request.getIfMatch());
        }
        return ib;
    }

    public static Function<Response, UpdateIdpGroupMappingResponse> fromResponse() {
        Function<Response, UpdateIdpGroupMappingResponse> transformer = new Function<Response, UpdateIdpGroupMappingResponse>(){

            public UpdateIdpGroupMappingResponse apply(Response rawResponse) {
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.identity.responses.UpdateIdpGroupMappingResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(IdpGroupMapping.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                UpdateIdpGroupMappingResponse.Builder builder = UpdateIdpGroupMappingResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.idpGroupMapping((IdpGroupMapping)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                UpdateIdpGroupMappingResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

