/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListBulkActionResourceTypesRequest
extends BmcRequest<Void> {
    private BulkActionType bulkActionType;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"bulkActionType", "page", "limit"})
    ListBulkActionResourceTypesRequest(BulkActionType bulkActionType, String page, Integer limit) {
        this.bulkActionType = bulkActionType;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public BulkActionType getBulkActionType() {
        return this.bulkActionType;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBulkActionResourceTypesRequest, Void> {
        private BulkActionType bulkActionType;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBulkActionResourceTypesRequest o) {
            this.bulkActionType(o.getBulkActionType());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBulkActionResourceTypesRequest build() {
            ListBulkActionResourceTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder bulkActionType(BulkActionType bulkActionType) {
            this.bulkActionType = bulkActionType;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListBulkActionResourceTypesRequest buildWithoutInvocationCallback() {
            return new ListBulkActionResourceTypesRequest(this.bulkActionType, this.page, this.limit);
        }

        public String toString() {
            return "ListBulkActionResourceTypesRequest.Builder(bulkActionType=" + (Object)((Object)this.bulkActionType) + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }

    public static enum BulkActionType {
        BulkMoveResources("BULK_MOVE_RESOURCES"),
        BulkDeleteResources("BULK_DELETE_RESOURCES");

        private final String value;
        private static Map<String, BulkActionType> map;

        private BulkActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BulkActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BulkActionType: " + key);
        }

        static {
            map = new HashMap<String, BulkActionType>();
            for (BulkActionType v : BulkActionType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

