/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.identity.model.TagNamespace;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListTagNamespacesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String page;
    private Integer limit;
    private Boolean includeSubcompartments;
    private TagNamespace.LifecycleState lifecycleState;

    @ConstructorProperties(value={"compartmentId", "page", "limit", "includeSubcompartments", "lifecycleState"})
    ListTagNamespacesRequest(String compartmentId, String page, Integer limit, Boolean includeSubcompartments, TagNamespace.LifecycleState lifecycleState) {
        this.compartmentId = compartmentId;
        this.page = page;
        this.limit = limit;
        this.includeSubcompartments = includeSubcompartments;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getIncludeSubcompartments() {
        return this.includeSubcompartments;
    }

    public TagNamespace.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTagNamespacesRequest, Void> {
        private String compartmentId;
        private String page;
        private Integer limit;
        private Boolean includeSubcompartments;
        private TagNamespace.LifecycleState lifecycleState;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTagNamespacesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.includeSubcompartments(o.getIncludeSubcompartments());
            this.lifecycleState(o.getLifecycleState());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTagNamespacesRequest build() {
            ListTagNamespacesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder includeSubcompartments(Boolean includeSubcompartments) {
            this.includeSubcompartments = includeSubcompartments;
            return this;
        }

        public Builder lifecycleState(TagNamespace.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public ListTagNamespacesRequest buildWithoutInvocationCallback() {
            return new ListTagNamespacesRequest(this.compartmentId, this.page, this.limit, this.includeSubcompartments, this.lifecycleState);
        }

        public String toString() {
            return "ListTagNamespacesRequest.Builder(compartmentId=" + this.compartmentId + ", page=" + this.page + ", limit=" + this.limit + ", includeSubcompartments=" + this.includeSubcompartments + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ")";
        }
    }
}

