/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class ListUserGroupMembershipsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String userId;
    private String groupId;
    private String page;
    private Integer limit;

    @ConstructorProperties(value={"compartmentId", "userId", "groupId", "page", "limit"})
    ListUserGroupMembershipsRequest(String compartmentId, String userId, String groupId, String page, Integer limit) {
        this.compartmentId = compartmentId;
        this.userId = userId;
        this.groupId = groupId;
        this.page = page;
        this.limit = limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUserGroupMembershipsRequest, Void> {
        private String compartmentId;
        private String userId;
        private String groupId;
        private String page;
        private Integer limit;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUserGroupMembershipsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.userId(o.getUserId());
            this.groupId(o.getGroupId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUserGroupMembershipsRequest build() {
            ListUserGroupMembershipsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public ListUserGroupMembershipsRequest buildWithoutInvocationCallback() {
            return new ListUserGroupMembershipsRequest(this.compartmentId, this.userId, this.groupId, this.page, this.limit);
        }

        public String toString() {
            return "ListUserGroupMembershipsRequest.Builder(compartmentId=" + this.compartmentId + ", userId=" + this.userId + ", groupId=" + this.groupId + ", page=" + this.page + ", limit=" + this.limit + ")";
        }
    }
}

