/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.MoveCompartmentDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class MoveCompartmentRequest
extends BmcRequest<MoveCompartmentDetails> {
    private String compartmentId;
    private MoveCompartmentDetails moveCompartmentDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public MoveCompartmentDetails getBody$() {
        return this.moveCompartmentDetails;
    }

    @ConstructorProperties(value={"compartmentId", "moveCompartmentDetails", "ifMatch", "opcRequestId", "opcRetryToken"})
    MoveCompartmentRequest(String compartmentId, MoveCompartmentDetails moveCompartmentDetails, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.compartmentId = compartmentId;
        this.moveCompartmentDetails = moveCompartmentDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public MoveCompartmentDetails getMoveCompartmentDetails() {
        return this.moveCompartmentDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<MoveCompartmentRequest, MoveCompartmentDetails> {
        private String compartmentId;
        private MoveCompartmentDetails moveCompartmentDetails;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(MoveCompartmentRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.moveCompartmentDetails(o.getMoveCompartmentDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public MoveCompartmentRequest build() {
            MoveCompartmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(MoveCompartmentDetails body) {
            this.moveCompartmentDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder moveCompartmentDetails(MoveCompartmentDetails moveCompartmentDetails) {
            this.moveCompartmentDetails = moveCompartmentDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public MoveCompartmentRequest buildWithoutInvocationCallback() {
            return new MoveCompartmentRequest(this.compartmentId, this.moveCompartmentDetails, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "MoveCompartmentRequest.Builder(compartmentId=" + this.compartmentId + ", moveCompartmentDetails=" + this.moveCompartmentDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

