/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.identity.model.UpdateOAuth2ClientCredentialDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateOAuthClientCredentialRequest
extends BmcRequest<UpdateOAuth2ClientCredentialDetails> {
    private String userId;
    private String oauth2ClientCredentialId;
    private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails;
    private String ifMatch;

    @InternalSdk
    public UpdateOAuth2ClientCredentialDetails getBody$() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    @ConstructorProperties(value={"userId", "oauth2ClientCredentialId", "updateOAuth2ClientCredentialDetails", "ifMatch"})
    UpdateOAuthClientCredentialRequest(String userId, String oauth2ClientCredentialId, UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails, String ifMatch) {
        this.userId = userId;
        this.oauth2ClientCredentialId = oauth2ClientCredentialId;
        this.updateOAuth2ClientCredentialDetails = updateOAuth2ClientCredentialDetails;
        this.ifMatch = ifMatch;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public UpdateOAuth2ClientCredentialDetails getUpdateOAuth2ClientCredentialDetails() {
        return this.updateOAuth2ClientCredentialDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateOAuthClientCredentialRequest, UpdateOAuth2ClientCredentialDetails> {
        private String userId;
        private String oauth2ClientCredentialId;
        private UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails;
        private String ifMatch;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.updateOAuth2ClientCredentialDetails(o.getUpdateOAuth2ClientCredentialDetails());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateOAuthClientCredentialRequest build() {
            UpdateOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateOAuth2ClientCredentialDetails body) {
            this.updateOAuth2ClientCredentialDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder updateOAuth2ClientCredentialDetails(UpdateOAuth2ClientCredentialDetails updateOAuth2ClientCredentialDetails) {
            this.updateOAuth2ClientCredentialDetails = updateOAuth2ClientCredentialDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public UpdateOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            return new UpdateOAuthClientCredentialRequest(this.userId, this.oauth2ClientCredentialId, this.updateOAuth2ClientCredentialDetails, this.ifMatch);
        }

        public String toString() {
            return "UpdateOAuthClientCredentialRequest.Builder(userId=" + this.userId + ", oauth2ClientCredentialId=" + this.oauth2ClientCredentialId + ", updateOAuth2ClientCredentialDetails=" + this.updateOAuth2ClientCredentialDetails + ", ifMatch=" + this.ifMatch + ")";
        }
    }
}

