/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PasswordPolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="minimumPasswordLength")
    private final Integer minimumPasswordLength;
    @JsonProperty(value="isUppercaseCharactersRequired")
    private final Boolean isUppercaseCharactersRequired;
    @JsonProperty(value="isLowercaseCharactersRequired")
    private final Boolean isLowercaseCharactersRequired;
    @JsonProperty(value="isNumericCharactersRequired")
    private final Boolean isNumericCharactersRequired;
    @JsonProperty(value="isSpecialCharactersRequired")
    private final Boolean isSpecialCharactersRequired;
    @JsonProperty(value="isUsernameContainmentAllowed")
    private final Boolean isUsernameContainmentAllowed;

    @Deprecated
    @ConstructorProperties(value={"minimumPasswordLength", "isUppercaseCharactersRequired", "isLowercaseCharactersRequired", "isNumericCharactersRequired", "isSpecialCharactersRequired", "isUsernameContainmentAllowed"})
    public PasswordPolicy(Integer minimumPasswordLength, Boolean isUppercaseCharactersRequired, Boolean isLowercaseCharactersRequired, Boolean isNumericCharactersRequired, Boolean isSpecialCharactersRequired, Boolean isUsernameContainmentAllowed) {
        this.minimumPasswordLength = minimumPasswordLength;
        this.isUppercaseCharactersRequired = isUppercaseCharactersRequired;
        this.isLowercaseCharactersRequired = isLowercaseCharactersRequired;
        this.isNumericCharactersRequired = isNumericCharactersRequired;
        this.isSpecialCharactersRequired = isSpecialCharactersRequired;
        this.isUsernameContainmentAllowed = isUsernameContainmentAllowed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getMinimumPasswordLength() {
        return this.minimumPasswordLength;
    }

    public Boolean getIsUppercaseCharactersRequired() {
        return this.isUppercaseCharactersRequired;
    }

    public Boolean getIsLowercaseCharactersRequired() {
        return this.isLowercaseCharactersRequired;
    }

    public Boolean getIsNumericCharactersRequired() {
        return this.isNumericCharactersRequired;
    }

    public Boolean getIsSpecialCharactersRequired() {
        return this.isSpecialCharactersRequired;
    }

    public Boolean getIsUsernameContainmentAllowed() {
        return this.isUsernameContainmentAllowed;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PasswordPolicy(");
        sb.append("super=").append(super.toString());
        sb.append("minimumPasswordLength=").append(String.valueOf(this.minimumPasswordLength));
        sb.append(", isUppercaseCharactersRequired=").append(String.valueOf(this.isUppercaseCharactersRequired));
        sb.append(", isLowercaseCharactersRequired=").append(String.valueOf(this.isLowercaseCharactersRequired));
        sb.append(", isNumericCharactersRequired=").append(String.valueOf(this.isNumericCharactersRequired));
        sb.append(", isSpecialCharactersRequired=").append(String.valueOf(this.isSpecialCharactersRequired));
        sb.append(", isUsernameContainmentAllowed=").append(String.valueOf(this.isUsernameContainmentAllowed));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PasswordPolicy)) {
            return false;
        }
        PasswordPolicy other = (PasswordPolicy)((Object)o);
        return Objects.equals(this.minimumPasswordLength, other.minimumPasswordLength) && Objects.equals(this.isUppercaseCharactersRequired, other.isUppercaseCharactersRequired) && Objects.equals(this.isLowercaseCharactersRequired, other.isLowercaseCharactersRequired) && Objects.equals(this.isNumericCharactersRequired, other.isNumericCharactersRequired) && Objects.equals(this.isSpecialCharactersRequired, other.isSpecialCharactersRequired) && Objects.equals(this.isUsernameContainmentAllowed, other.isUsernameContainmentAllowed) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.minimumPasswordLength == null ? 43 : this.minimumPasswordLength.hashCode());
        result = result * 59 + (this.isUppercaseCharactersRequired == null ? 43 : this.isUppercaseCharactersRequired.hashCode());
        result = result * 59 + (this.isLowercaseCharactersRequired == null ? 43 : this.isLowercaseCharactersRequired.hashCode());
        result = result * 59 + (this.isNumericCharactersRequired == null ? 43 : this.isNumericCharactersRequired.hashCode());
        result = result * 59 + (this.isSpecialCharactersRequired == null ? 43 : this.isSpecialCharactersRequired.hashCode());
        result = result * 59 + (this.isUsernameContainmentAllowed == null ? 43 : this.isUsernameContainmentAllowed.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="minimumPasswordLength")
        private Integer minimumPasswordLength;
        @JsonProperty(value="isUppercaseCharactersRequired")
        private Boolean isUppercaseCharactersRequired;
        @JsonProperty(value="isLowercaseCharactersRequired")
        private Boolean isLowercaseCharactersRequired;
        @JsonProperty(value="isNumericCharactersRequired")
        private Boolean isNumericCharactersRequired;
        @JsonProperty(value="isSpecialCharactersRequired")
        private Boolean isSpecialCharactersRequired;
        @JsonProperty(value="isUsernameContainmentAllowed")
        private Boolean isUsernameContainmentAllowed;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder minimumPasswordLength(Integer minimumPasswordLength) {
            this.minimumPasswordLength = minimumPasswordLength;
            this.__explicitlySet__.add("minimumPasswordLength");
            return this;
        }

        public Builder isUppercaseCharactersRequired(Boolean isUppercaseCharactersRequired) {
            this.isUppercaseCharactersRequired = isUppercaseCharactersRequired;
            this.__explicitlySet__.add("isUppercaseCharactersRequired");
            return this;
        }

        public Builder isLowercaseCharactersRequired(Boolean isLowercaseCharactersRequired) {
            this.isLowercaseCharactersRequired = isLowercaseCharactersRequired;
            this.__explicitlySet__.add("isLowercaseCharactersRequired");
            return this;
        }

        public Builder isNumericCharactersRequired(Boolean isNumericCharactersRequired) {
            this.isNumericCharactersRequired = isNumericCharactersRequired;
            this.__explicitlySet__.add("isNumericCharactersRequired");
            return this;
        }

        public Builder isSpecialCharactersRequired(Boolean isSpecialCharactersRequired) {
            this.isSpecialCharactersRequired = isSpecialCharactersRequired;
            this.__explicitlySet__.add("isSpecialCharactersRequired");
            return this;
        }

        public Builder isUsernameContainmentAllowed(Boolean isUsernameContainmentAllowed) {
            this.isUsernameContainmentAllowed = isUsernameContainmentAllowed;
            this.__explicitlySet__.add("isUsernameContainmentAllowed");
            return this;
        }

        public PasswordPolicy build() {
            PasswordPolicy model = new PasswordPolicy(this.minimumPasswordLength, this.isUppercaseCharactersRequired, this.isLowercaseCharactersRequired, this.isNumericCharactersRequired, this.isSpecialCharactersRequired, this.isUsernameContainmentAllowed);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PasswordPolicy model) {
            if (model.wasPropertyExplicitlySet("minimumPasswordLength")) {
                this.minimumPasswordLength(model.getMinimumPasswordLength());
            }
            if (model.wasPropertyExplicitlySet("isUppercaseCharactersRequired")) {
                this.isUppercaseCharactersRequired(model.getIsUppercaseCharactersRequired());
            }
            if (model.wasPropertyExplicitlySet("isLowercaseCharactersRequired")) {
                this.isLowercaseCharactersRequired(model.getIsLowercaseCharactersRequired());
            }
            if (model.wasPropertyExplicitlySet("isNumericCharactersRequired")) {
                this.isNumericCharactersRequired(model.getIsNumericCharactersRequired());
            }
            if (model.wasPropertyExplicitlySet("isSpecialCharactersRequired")) {
                this.isSpecialCharactersRequired(model.getIsSpecialCharactersRequired());
            }
            if (model.wasPropertyExplicitlySet("isUsernameContainmentAllowed")) {
                this.isUsernameContainmentAllowed(model.getIsUsernameContainmentAllowed());
            }
            return this;
        }
    }
}

