/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DomainReplicationStates
extends ExplicitlySetBmcModel {
    @JsonProperty(value="domainId")
    private final String domainId;
    @JsonProperty(value="state")
    private final State state;
    @JsonProperty(value="replicaRegion")
    private final String replicaRegion;

    @Deprecated
    @ConstructorProperties(value={"domainId", "state", "replicaRegion"})
    public DomainReplicationStates(String domainId, State state, String replicaRegion) {
        this.domainId = domainId;
        this.state = state;
        this.replicaRegion = replicaRegion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDomainId() {
        return this.domainId;
    }

    public State getState() {
        return this.state;
    }

    public String getReplicaRegion() {
        return this.replicaRegion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DomainReplicationStates(");
        sb.append("super=").append(super.toString());
        sb.append("domainId=").append(String.valueOf(this.domainId));
        sb.append(", state=").append(String.valueOf((Object)this.state));
        sb.append(", replicaRegion=").append(String.valueOf(this.replicaRegion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DomainReplicationStates)) {
            return false;
        }
        DomainReplicationStates other = (DomainReplicationStates)((Object)o);
        return Objects.equals(this.domainId, other.domainId) && Objects.equals((Object)this.state, (Object)other.state) && Objects.equals(this.replicaRegion, other.replicaRegion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.domainId == null ? 43 : this.domainId.hashCode());
        result = result * 59 + (this.state == null ? 43 : this.state.hashCode());
        result = result * 59 + (this.replicaRegion == null ? 43 : this.replicaRegion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum State implements BmcEnum
    {
        EnablingReplication("ENABLING_REPLICATION"),
        ReplicationEnabled("REPLICATION_ENABLED"),
        DisablingReplication("DISABLING_REPLICATION"),
        ReplicationDisabled("REPLICATION_DISABLED"),
        Deleted("DELETED");

        private final String value;
        private static Map<String, State> map;

        private State(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static State create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid State: " + key);
        }

        static {
            map = new HashMap<String, State>();
            for (State v : State.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="domainId")
        private String domainId;
        @JsonProperty(value="state")
        private State state;
        @JsonProperty(value="replicaRegion")
        private String replicaRegion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            this.__explicitlySet__.add("domainId");
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            this.__explicitlySet__.add("state");
            return this;
        }

        public Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            this.__explicitlySet__.add("replicaRegion");
            return this;
        }

        public DomainReplicationStates build() {
            DomainReplicationStates model = new DomainReplicationStates(this.domainId, this.state, this.replicaRegion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DomainReplicationStates model) {
            if (model.wasPropertyExplicitlySet("domainId")) {
                this.domainId(model.getDomainId());
            }
            if (model.wasPropertyExplicitlySet("state")) {
                this.state(model.getState());
            }
            if (model.wasPropertyExplicitlySet("replicaRegion")) {
                this.replicaRegion(model.getReplicaRegion());
            }
            return this;
        }
    }
}

