/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteIntegrationInstanceRequest
extends BmcRequest<Void> {
    private String integrationInstanceId;
    private String ifMatch;
    private String opcRequestId;

    @ConstructorProperties(value={"integrationInstanceId", "ifMatch", "opcRequestId"})
    DeleteIntegrationInstanceRequest(String integrationInstanceId, String ifMatch, String opcRequestId) {
        this.integrationInstanceId = integrationInstanceId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteIntegrationInstanceRequest, Void> {
        private String integrationInstanceId;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteIntegrationInstanceRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteIntegrationInstanceRequest build() {
            DeleteIntegrationInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DeleteIntegrationInstanceRequest buildWithoutInvocationCallback() {
            return new DeleteIntegrationInstanceRequest(this.integrationInstanceId, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "DeleteIntegrationInstanceRequest.Builder(integrationInstanceId=" + this.integrationInstanceId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

