/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.integration.model.NetworkEndpointDetails;
import com.oracle.bmc.integration.model.VirtualCloudNetwork;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="networkEndpointType")
@JsonFilter(value="explicitlySetFilter")
public final class PublicEndpointDetails
extends NetworkEndpointDetails {
    @JsonProperty(value="allowlistedHttpIps")
    private final List<String> allowlistedHttpIps;
    @JsonProperty(value="allowlistedHttpVcns")
    private final List<VirtualCloudNetwork> allowlistedHttpVcns;
    @JsonProperty(value="isIntegrationVcnAllowlisted")
    private final Boolean isIntegrationVcnAllowlisted;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PublicEndpointDetails(List<String> allowlistedHttpIps, List<VirtualCloudNetwork> allowlistedHttpVcns, Boolean isIntegrationVcnAllowlisted) {
        this.allowlistedHttpIps = allowlistedHttpIps;
        this.allowlistedHttpVcns = allowlistedHttpVcns;
        this.isIntegrationVcnAllowlisted = isIntegrationVcnAllowlisted;
    }

    public List<String> getAllowlistedHttpIps() {
        return this.allowlistedHttpIps;
    }

    public List<VirtualCloudNetwork> getAllowlistedHttpVcns() {
        return this.allowlistedHttpVcns;
    }

    public Boolean getIsIntegrationVcnAllowlisted() {
        return this.isIntegrationVcnAllowlisted;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PublicEndpointDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", allowlistedHttpIps=").append(String.valueOf(this.allowlistedHttpIps));
        sb.append(", allowlistedHttpVcns=").append(String.valueOf(this.allowlistedHttpVcns));
        sb.append(", isIntegrationVcnAllowlisted=").append(String.valueOf(this.isIntegrationVcnAllowlisted));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublicEndpointDetails)) {
            return false;
        }
        PublicEndpointDetails other = (PublicEndpointDetails)((Object)o);
        return Objects.equals(this.allowlistedHttpIps, other.allowlistedHttpIps) && Objects.equals(this.allowlistedHttpVcns, other.allowlistedHttpVcns) && Objects.equals(this.isIntegrationVcnAllowlisted, other.isIntegrationVcnAllowlisted) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.allowlistedHttpIps == null ? 43 : this.allowlistedHttpIps.hashCode());
        result = result * 59 + (this.allowlistedHttpVcns == null ? 43 : this.allowlistedHttpVcns.hashCode());
        result = result * 59 + (this.isIntegrationVcnAllowlisted == null ? 43 : this.isIntegrationVcnAllowlisted.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="allowlistedHttpIps")
        private List<String> allowlistedHttpIps;
        @JsonProperty(value="allowlistedHttpVcns")
        private List<VirtualCloudNetwork> allowlistedHttpVcns;
        @JsonProperty(value="isIntegrationVcnAllowlisted")
        private Boolean isIntegrationVcnAllowlisted;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder allowlistedHttpIps(List<String> allowlistedHttpIps) {
            this.allowlistedHttpIps = allowlistedHttpIps;
            this.__explicitlySet__.add("allowlistedHttpIps");
            return this;
        }

        public Builder allowlistedHttpVcns(List<VirtualCloudNetwork> allowlistedHttpVcns) {
            this.allowlistedHttpVcns = allowlistedHttpVcns;
            this.__explicitlySet__.add("allowlistedHttpVcns");
            return this;
        }

        public Builder isIntegrationVcnAllowlisted(Boolean isIntegrationVcnAllowlisted) {
            this.isIntegrationVcnAllowlisted = isIntegrationVcnAllowlisted;
            this.__explicitlySet__.add("isIntegrationVcnAllowlisted");
            return this;
        }

        public PublicEndpointDetails build() {
            PublicEndpointDetails model = new PublicEndpointDetails(this.allowlistedHttpIps, this.allowlistedHttpVcns, this.isIntegrationVcnAllowlisted);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PublicEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("allowlistedHttpIps")) {
                this.allowlistedHttpIps(model.getAllowlistedHttpIps());
            }
            if (model.wasPropertyExplicitlySet("allowlistedHttpVcns")) {
                this.allowlistedHttpVcns(model.getAllowlistedHttpVcns());
            }
            if (model.wasPropertyExplicitlySet("isIntegrationVcnAllowlisted")) {
                this.isIntegrationVcnAllowlisted(model.getIsIntegrationVcnAllowlisted());
            }
            return this;
        }
    }
}

