/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.integration.IntegrationInstancePaginators;
import com.oracle.bmc.integration.IntegrationInstanceWaiters;
import com.oracle.bmc.integration.model.IntegrationInstance;
import com.oracle.bmc.integration.model.IntegrationInstanceSummary;
import com.oracle.bmc.integration.model.WorkRequest;
import com.oracle.bmc.integration.model.WorkRequestError;
import com.oracle.bmc.integration.model.WorkRequestLogEntry;
import com.oracle.bmc.integration.model.WorkRequestSummary;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceCompartmentRequest;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceNetworkEndpointRequest;
import com.oracle.bmc.integration.requests.ChangePrivateEndpointOutboundConnectionRequest;
import com.oracle.bmc.integration.requests.CreateIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.DeleteIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.EnableProcessAutomationRequest;
import com.oracle.bmc.integration.requests.GetIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.GetWorkRequestRequest;
import com.oracle.bmc.integration.requests.ListIntegrationInstancesRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.integration.requests.StartIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.StopIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.UpdateIntegrationInstanceRequest;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceCompartmentResponse;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceNetworkEndpointResponse;
import com.oracle.bmc.integration.responses.ChangePrivateEndpointOutboundConnectionResponse;
import com.oracle.bmc.integration.responses.CreateIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.DeleteIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.EnableProcessAutomationResponse;
import com.oracle.bmc.integration.responses.GetIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.GetWorkRequestResponse;
import com.oracle.bmc.integration.responses.ListIntegrationInstancesResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.integration.responses.StartIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.StopIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.UpdateIntegrationInstanceResponse;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationInstanceClient
extends BaseSyncClient
implements com.oracle.bmc.integration.IntegrationInstance {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INTEGRATIONINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://integration.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationInstanceClient.class);
    private final IntegrationInstanceWaiters waiters;
    private final IntegrationInstancePaginators paginators;

    IntegrationInstanceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("IntegrationInstance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new IntegrationInstanceWaiters(executorService, this);
        this.paginators = new IntegrationInstancePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeIntegrationInstanceCompartmentResponse changeIntegrationInstanceCompartment(ChangeIntegrationInstanceCompartmentRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIntegrationInstanceCompartmentDetails(), "changeIntegrationInstanceCompartmentDetails is required");
        return (ChangeIntegrationInstanceCompartmentResponse)this.clientCall(request, ChangeIntegrationInstanceCompartmentResponse::builder).logger(LOG, "changeIntegrationInstanceCompartment").serviceDetails("IntegrationInstance", "ChangeIntegrationInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangeIntegrationInstanceCompartment").method(Method.POST).requestBuilder(ChangeIntegrationInstanceCompartmentRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIntegrationInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIntegrationInstanceCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeIntegrationInstanceNetworkEndpointResponse changeIntegrationInstanceNetworkEndpoint(ChangeIntegrationInstanceNetworkEndpointRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIntegrationInstanceNetworkEndpointDetails(), "changeIntegrationInstanceNetworkEndpointDetails is required");
        return (ChangeIntegrationInstanceNetworkEndpointResponse)this.clientCall(request, ChangeIntegrationInstanceNetworkEndpointResponse::builder).logger(LOG, "changeIntegrationInstanceNetworkEndpoint").serviceDetails("IntegrationInstance", "ChangeIntegrationInstanceNetworkEndpoint", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangeIntegrationInstanceNetworkEndpoint").method(Method.POST).requestBuilder(ChangeIntegrationInstanceNetworkEndpointRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changeNetworkEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIntegrationInstanceNetworkEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIntegrationInstanceNetworkEndpointResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangePrivateEndpointOutboundConnectionResponse changePrivateEndpointOutboundConnection(ChangePrivateEndpointOutboundConnectionRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateEndpointOutboundConnectionDetails(), "changePrivateEndpointOutboundConnectionDetails is required");
        return (ChangePrivateEndpointOutboundConnectionResponse)this.clientCall(request, ChangePrivateEndpointOutboundConnectionResponse::builder).logger(LOG, "changePrivateEndpointOutboundConnection").serviceDetails("IntegrationInstance", "ChangePrivateEndpointOutboundConnection", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangePrivateEndpointOutboundConnection").method(Method.POST).requestBuilder(ChangePrivateEndpointOutboundConnectionRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changePrivateEndpointOutboundConnection").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangePrivateEndpointOutboundConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangePrivateEndpointOutboundConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateIntegrationInstanceResponse createIntegrationInstance(CreateIntegrationInstanceRequest request) {
        Objects.requireNonNull(request.getCreateIntegrationInstanceDetails(), "createIntegrationInstanceDetails is required");
        return (CreateIntegrationInstanceResponse)this.clientCall(request, CreateIntegrationInstanceResponse::builder).logger(LOG, "createIntegrationInstance").serviceDetails("IntegrationInstance", "CreateIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/CreateIntegrationInstance").method(Method.POST).requestBuilder(CreateIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteIntegrationInstanceResponse deleteIntegrationInstance(DeleteIntegrationInstanceRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return (DeleteIntegrationInstanceResponse)this.clientCall(request, DeleteIntegrationInstanceResponse::builder).logger(LOG, "deleteIntegrationInstance").serviceDetails("IntegrationInstance", "DeleteIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/DeleteIntegrationInstance").method(Method.DELETE).requestBuilder(DeleteIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EnableProcessAutomationResponse enableProcessAutomation(EnableProcessAutomationRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return (EnableProcessAutomationResponse)this.clientCall(request, EnableProcessAutomationResponse::builder).logger(LOG, "enableProcessAutomation").serviceDetails("IntegrationInstance", "EnableProcessAutomation", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/EnableProcessAutomation").method(Method.POST).requestBuilder(EnableProcessAutomationRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("enableProcessAutomation").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", EnableProcessAutomationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableProcessAutomationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetIntegrationInstanceResponse getIntegrationInstance(GetIntegrationInstanceRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return (GetIntegrationInstanceResponse)this.clientCall(request, GetIntegrationInstanceResponse::builder).logger(LOG, "getIntegrationInstance").serviceDetails("IntegrationInstance", "GetIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/GetIntegrationInstance").method(Method.GET).requestBuilder(GetIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IntegrationInstance.class, GetIntegrationInstanceResponse.Builder::integrationInstance).handleResponseHeaderString("etag", GetIntegrationInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("IntegrationInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public ListIntegrationInstancesResponse listIntegrationInstances(ListIntegrationInstancesRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListIntegrationInstancesResponse)this.clientCall(request, ListIntegrationInstancesResponse::builder).logger(LOG, "listIntegrationInstances").serviceDetails("IntegrationInstance", "ListIntegrationInstances", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstanceSummary/ListIntegrationInstances").method(Method.GET).requestBuilder(ListIntegrationInstancesRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(IntegrationInstanceSummary.class, ListIntegrationInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIntegrationInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIntegrationInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListIntegrationInstancesResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("IntegrationInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestErrorsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("IntegrationInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestLogsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("IntegrationInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("integrationInstanceId", (Object)request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).callSync();
    }

    @Override
    public StartIntegrationInstanceResponse startIntegrationInstance(StartIntegrationInstanceRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return (StartIntegrationInstanceResponse)this.clientCall(request, StartIntegrationInstanceResponse::builder).logger(LOG, "startIntegrationInstance").serviceDetails("IntegrationInstance", "StartIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/StartIntegrationInstance").method(Method.POST).requestBuilder(StartIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public StopIntegrationInstanceResponse stopIntegrationInstance(StopIntegrationInstanceRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return (StopIntegrationInstanceResponse)this.clientCall(request, StopIntegrationInstanceResponse::builder).logger(LOG, "stopIntegrationInstance").serviceDetails("IntegrationInstance", "StopIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/StopIntegrationInstance").method(Method.POST).requestBuilder(StopIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateIntegrationInstanceResponse updateIntegrationInstance(UpdateIntegrationInstanceRequest request) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIntegrationInstanceDetails(), "updateIntegrationInstanceDetails is required");
        return (UpdateIntegrationInstanceResponse)this.clientCall(request, UpdateIntegrationInstanceResponse::builder).logger(LOG, "updateIntegrationInstance").serviceDetails("IntegrationInstance", "UpdateIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/UpdateIntegrationInstance").method(Method.PUT).requestBuilder(UpdateIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIntegrationInstanceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public IntegrationInstanceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public IntegrationInstancePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public IntegrationInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)IntegrationInstanceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(IntegrationInstanceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public IntegrationInstanceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)IntegrationInstanceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IntegrationInstanceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "integration";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"integration");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public IntegrationInstanceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new IntegrationInstanceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

