/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.integration.IntegrationInstanceAsync;
import com.oracle.bmc.integration.model.IntegrationInstance;
import com.oracle.bmc.integration.model.IntegrationInstanceSummary;
import com.oracle.bmc.integration.model.WorkRequest;
import com.oracle.bmc.integration.model.WorkRequestError;
import com.oracle.bmc.integration.model.WorkRequestLogEntry;
import com.oracle.bmc.integration.model.WorkRequestSummary;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceCompartmentRequest;
import com.oracle.bmc.integration.requests.ChangeIntegrationInstanceNetworkEndpointRequest;
import com.oracle.bmc.integration.requests.ChangePrivateEndpointOutboundConnectionRequest;
import com.oracle.bmc.integration.requests.CreateIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.DeleteIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.EnableProcessAutomationRequest;
import com.oracle.bmc.integration.requests.ExtendDataRetentionRequest;
import com.oracle.bmc.integration.requests.GetIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.GetWorkRequestRequest;
import com.oracle.bmc.integration.requests.ListIntegrationInstancesRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.integration.requests.ListWorkRequestsRequest;
import com.oracle.bmc.integration.requests.StartIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.StopIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.UpdateIntegrationInstanceRequest;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceCompartmentResponse;
import com.oracle.bmc.integration.responses.ChangeIntegrationInstanceNetworkEndpointResponse;
import com.oracle.bmc.integration.responses.ChangePrivateEndpointOutboundConnectionResponse;
import com.oracle.bmc.integration.responses.CreateIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.DeleteIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.EnableProcessAutomationResponse;
import com.oracle.bmc.integration.responses.ExtendDataRetentionResponse;
import com.oracle.bmc.integration.responses.GetIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.GetWorkRequestResponse;
import com.oracle.bmc.integration.responses.ListIntegrationInstancesResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.integration.responses.ListWorkRequestsResponse;
import com.oracle.bmc.integration.responses.StartIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.StopIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.UpdateIntegrationInstanceResponse;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationInstanceAsyncClient
extends BaseAsyncClient
implements IntegrationInstanceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INTEGRATIONINSTANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://integration.{region}.ocp.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationInstanceAsyncClient.class);

    IntegrationInstanceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeIntegrationInstanceCompartmentResponse> changeIntegrationInstanceCompartment(ChangeIntegrationInstanceCompartmentRequest request, AsyncHandler<ChangeIntegrationInstanceCompartmentRequest, ChangeIntegrationInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIntegrationInstanceCompartmentDetails(), "changeIntegrationInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeIntegrationInstanceCompartmentResponse::builder).logger(LOG, "changeIntegrationInstanceCompartment").serviceDetails("IntegrationInstance", "ChangeIntegrationInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangeIntegrationInstanceCompartment").method(Method.POST).requestBuilder(ChangeIntegrationInstanceCompartmentRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIntegrationInstanceCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIntegrationInstanceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeIntegrationInstanceNetworkEndpointResponse> changeIntegrationInstanceNetworkEndpoint(ChangeIntegrationInstanceNetworkEndpointRequest request, AsyncHandler<ChangeIntegrationInstanceNetworkEndpointRequest, ChangeIntegrationInstanceNetworkEndpointResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeIntegrationInstanceNetworkEndpointDetails(), "changeIntegrationInstanceNetworkEndpointDetails is required");
        return this.clientCall(request, ChangeIntegrationInstanceNetworkEndpointResponse::builder).logger(LOG, "changeIntegrationInstanceNetworkEndpoint").serviceDetails("IntegrationInstance", "ChangeIntegrationInstanceNetworkEndpoint", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangeIntegrationInstanceNetworkEndpoint").method(Method.POST).requestBuilder(ChangeIntegrationInstanceNetworkEndpointRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changeNetworkEndpoint").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeIntegrationInstanceNetworkEndpointResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeIntegrationInstanceNetworkEndpointResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangePrivateEndpointOutboundConnectionResponse> changePrivateEndpointOutboundConnection(ChangePrivateEndpointOutboundConnectionRequest request, AsyncHandler<ChangePrivateEndpointOutboundConnectionRequest, ChangePrivateEndpointOutboundConnectionResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangePrivateEndpointOutboundConnectionDetails(), "changePrivateEndpointOutboundConnectionDetails is required");
        return this.clientCall(request, ChangePrivateEndpointOutboundConnectionResponse::builder).logger(LOG, "changePrivateEndpointOutboundConnection").serviceDetails("IntegrationInstance", "ChangePrivateEndpointOutboundConnection", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ChangePrivateEndpointOutboundConnection").method(Method.POST).requestBuilder(ChangePrivateEndpointOutboundConnectionRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("changePrivateEndpointOutboundConnection").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangePrivateEndpointOutboundConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangePrivateEndpointOutboundConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateIntegrationInstanceResponse> createIntegrationInstance(CreateIntegrationInstanceRequest request, AsyncHandler<CreateIntegrationInstanceRequest, CreateIntegrationInstanceResponse> handler) {
        Objects.requireNonNull(request.getCreateIntegrationInstanceDetails(), "createIntegrationInstanceDetails is required");
        return this.clientCall(request, CreateIntegrationInstanceResponse::builder).logger(LOG, "createIntegrationInstance").serviceDetails("IntegrationInstance", "CreateIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/CreateIntegrationInstance").method(Method.POST).requestBuilder(CreateIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", CreateIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteIntegrationInstanceResponse> deleteIntegrationInstance(DeleteIntegrationInstanceRequest request, AsyncHandler<DeleteIntegrationInstanceRequest, DeleteIntegrationInstanceResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteIntegrationInstanceResponse::builder).logger(LOG, "deleteIntegrationInstance").serviceDetails("IntegrationInstance", "DeleteIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/DeleteIntegrationInstance").method(Method.DELETE).requestBuilder(DeleteIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<EnableProcessAutomationResponse> enableProcessAutomation(EnableProcessAutomationRequest request, AsyncHandler<EnableProcessAutomationRequest, EnableProcessAutomationResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, EnableProcessAutomationResponse::builder).logger(LOG, "enableProcessAutomation").serviceDetails("IntegrationInstance", "EnableProcessAutomation", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/EnableProcessAutomation").method(Method.POST).requestBuilder(EnableProcessAutomationRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("enableProcessAutomation").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", EnableProcessAutomationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableProcessAutomationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExtendDataRetentionResponse> extendDataRetention(ExtendDataRetentionRequest request, AsyncHandler<ExtendDataRetentionRequest, ExtendDataRetentionResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExtendDataRetentionDetails(), "extendDataRetentionDetails is required");
        return this.clientCall(request, ExtendDataRetentionResponse::builder).logger(LOG, "extendDataRetention").serviceDetails("IntegrationInstance", "ExtendDataRetention", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/ExtendDataRetention").method(Method.POST).requestBuilder(ExtendDataRetentionRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("extendDataRetention").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-work-request-id", ExtendDataRetentionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ExtendDataRetentionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIntegrationInstanceResponse> getIntegrationInstance(GetIntegrationInstanceRequest request, AsyncHandler<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetIntegrationInstanceResponse::builder).logger(LOG, "getIntegrationInstance").serviceDetails("IntegrationInstance", "GetIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/GetIntegrationInstance").method(Method.GET).requestBuilder(GetIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(IntegrationInstance.class, GetIntegrationInstanceResponse.Builder::integrationInstance).handleResponseHeaderString("etag", GetIntegrationInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("IntegrationInstance", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callAsync(handler);
    }

    @Override
    public Future<ListIntegrationInstancesResponse> listIntegrationInstances(ListIntegrationInstancesRequest request, AsyncHandler<ListIntegrationInstancesRequest, ListIntegrationInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListIntegrationInstancesResponse::builder).logger(LOG, "listIntegrationInstances").serviceDetails("IntegrationInstance", "ListIntegrationInstances", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstanceSummary/ListIntegrationInstances").method(Method.GET).requestBuilder(ListIntegrationInstancesRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(IntegrationInstanceSummary.class, ListIntegrationInstancesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIntegrationInstancesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIntegrationInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListIntegrationInstancesResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("IntegrationInstance", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestError.class, ListWorkRequestErrorsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestErrorsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("IntegrationInstance", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestLogEntry.class, ListWorkRequestLogsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestLogsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("IntegrationInstance", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/WorkRequestSummary/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20190131").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("integrationInstanceId", (Object)request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(WorkRequestSummary.class, ListWorkRequestsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-previous-page", ListWorkRequestsResponse.Builder::opcPreviousPage).callAsync(handler);
    }

    @Override
    public Future<StartIntegrationInstanceResponse> startIntegrationInstance(StartIntegrationInstanceRequest request, AsyncHandler<StartIntegrationInstanceRequest, StartIntegrationInstanceResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartIntegrationInstanceResponse::builder).logger(LOG, "startIntegrationInstance").serviceDetails("IntegrationInstance", "StartIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/StartIntegrationInstance").method(Method.POST).requestBuilder(StartIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StartIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StartIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<StopIntegrationInstanceResponse> stopIntegrationInstance(StopIntegrationInstanceRequest request, AsyncHandler<StopIntegrationInstanceRequest, StopIntegrationInstanceResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopIntegrationInstanceResponse::builder).logger(LOG, "stopIntegrationInstance").serviceDetails("IntegrationInstance", "StopIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/StopIntegrationInstance").method(Method.POST).requestBuilder(StopIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-work-request-id", StopIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", StopIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateIntegrationInstanceResponse> updateIntegrationInstance(UpdateIntegrationInstanceRequest request, AsyncHandler<UpdateIntegrationInstanceRequest, UpdateIntegrationInstanceResponse> handler) {
        Validate.notBlank((String)request.getIntegrationInstanceId(), (String)"integrationInstanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateIntegrationInstanceDetails(), "updateIntegrationInstanceDetails is required");
        return this.clientCall(request, UpdateIntegrationInstanceResponse::builder).logger(LOG, "updateIntegrationInstance").serviceDetails("IntegrationInstance", "UpdateIntegrationInstance", "https://docs.oracle.com/iaas/api/#/en/integration/20190131/IntegrationInstance/UpdateIntegrationInstance").method(Method.PUT).requestBuilder(UpdateIntegrationInstanceRequest::builder).basePath("/20190131").appendPathParam("integrationInstances").appendPathParam(request.getIntegrationInstanceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", UpdateIntegrationInstanceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateIntegrationInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)IntegrationInstanceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(IntegrationInstanceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)IntegrationInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)IntegrationInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)IntegrationInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)IntegrationInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public IntegrationInstanceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)IntegrationInstanceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IntegrationInstanceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "integration";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"integration");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public IntegrationInstanceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new IntegrationInstanceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

