/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration;

import com.oracle.bmc.integration.IntegrationInstance;
import com.oracle.bmc.integration.model.IntegrationInstance;
import com.oracle.bmc.integration.requests.GetIntegrationInstanceRequest;
import com.oracle.bmc.integration.requests.GetWorkRequestRequest;
import com.oracle.bmc.integration.responses.GetIntegrationInstanceResponse;
import com.oracle.bmc.integration.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class IntegrationInstanceWaiters {
    private final ExecutorService executorService;
    private final IntegrationInstance client;

    public IntegrationInstanceWaiters(ExecutorService executorService, IntegrationInstance client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse> forIntegrationInstance(GetIntegrationInstanceRequest request, IntegrationInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forIntegrationInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse> forIntegrationInstance(GetIntegrationInstanceRequest request, IntegrationInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forIntegrationInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse> forIntegrationInstance(GetIntegrationInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, IntegrationInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forIntegrationInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse> forIntegrationInstance(BmcGenericWaiter waiter, GetIntegrationInstanceRequest request, IntegrationInstance.LifecycleState ... targetStates) {
        final HashSet<IntegrationInstance.LifecycleState> targetStatesSet = new HashSet<IntegrationInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetIntegrationInstanceRequest, GetIntegrationInstanceResponse>(){

            @Override
            public GetIntegrationInstanceResponse apply(GetIntegrationInstanceRequest request) {
                return IntegrationInstanceWaiters.this.client.getIntegrationInstance(request);
            }
        }, (Predicate)new Predicate<GetIntegrationInstanceResponse>(){

            @Override
            public boolean test(GetIntegrationInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getIntegrationInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)IntegrationInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return IntegrationInstanceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

