/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.integration.model.CreateCustomEndpointDetails;
import com.oracle.bmc.integration.model.NetworkEndpointDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateIntegrationInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="integrationInstanceType")
    private final IntegrationInstanceType integrationInstanceType;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="idcsAt")
    private final String idcsAt;
    @JsonProperty(value="messagePacks")
    private final Integer messagePacks;
    @JsonProperty(value="isVisualBuilderEnabled")
    private final Boolean isVisualBuilderEnabled;
    @JsonProperty(value="customEndpoint")
    private final CreateCustomEndpointDetails customEndpoint;
    @JsonProperty(value="alternateCustomEndpoints")
    private final List<CreateCustomEndpointDetails> alternateCustomEndpoints;
    @JsonProperty(value="consumptionModel")
    private final ConsumptionModel consumptionModel;
    @JsonProperty(value="isFileServerEnabled")
    private final Boolean isFileServerEnabled;
    @JsonProperty(value="networkEndpointDetails")
    private final NetworkEndpointDetails networkEndpointDetails;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="domainId")
    private final String domainId;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "integrationInstanceType", "freeformTags", "definedTags", "isByol", "idcsAt", "messagePacks", "isVisualBuilderEnabled", "customEndpoint", "alternateCustomEndpoints", "consumptionModel", "isFileServerEnabled", "networkEndpointDetails", "shape", "domainId"})
    public CreateIntegrationInstanceDetails(String displayName, String compartmentId, IntegrationInstanceType integrationInstanceType, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isByol, String idcsAt, Integer messagePacks, Boolean isVisualBuilderEnabled, CreateCustomEndpointDetails customEndpoint, List<CreateCustomEndpointDetails> alternateCustomEndpoints, ConsumptionModel consumptionModel, Boolean isFileServerEnabled, NetworkEndpointDetails networkEndpointDetails, Shape shape, String domainId) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.integrationInstanceType = integrationInstanceType;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isByol = isByol;
        this.idcsAt = idcsAt;
        this.messagePacks = messagePacks;
        this.isVisualBuilderEnabled = isVisualBuilderEnabled;
        this.customEndpoint = customEndpoint;
        this.alternateCustomEndpoints = alternateCustomEndpoints;
        this.consumptionModel = consumptionModel;
        this.isFileServerEnabled = isFileServerEnabled;
        this.networkEndpointDetails = networkEndpointDetails;
        this.shape = shape;
        this.domainId = domainId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public IntegrationInstanceType getIntegrationInstanceType() {
        return this.integrationInstanceType;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public String getIdcsAt() {
        return this.idcsAt;
    }

    public Integer getMessagePacks() {
        return this.messagePacks;
    }

    public Boolean getIsVisualBuilderEnabled() {
        return this.isVisualBuilderEnabled;
    }

    public CreateCustomEndpointDetails getCustomEndpoint() {
        return this.customEndpoint;
    }

    public List<CreateCustomEndpointDetails> getAlternateCustomEndpoints() {
        return this.alternateCustomEndpoints;
    }

    public ConsumptionModel getConsumptionModel() {
        return this.consumptionModel;
    }

    public Boolean getIsFileServerEnabled() {
        return this.isFileServerEnabled;
    }

    public NetworkEndpointDetails getNetworkEndpointDetails() {
        return this.networkEndpointDetails;
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateIntegrationInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", integrationInstanceType=").append(String.valueOf((Object)this.integrationInstanceType));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", isByol=").append(String.valueOf(this.isByol));
        sb.append(", idcsAt=").append(String.valueOf(this.idcsAt));
        sb.append(", messagePacks=").append(String.valueOf(this.messagePacks));
        sb.append(", isVisualBuilderEnabled=").append(String.valueOf(this.isVisualBuilderEnabled));
        sb.append(", customEndpoint=").append(String.valueOf((Object)this.customEndpoint));
        sb.append(", alternateCustomEndpoints=").append(String.valueOf(this.alternateCustomEndpoints));
        sb.append(", consumptionModel=").append(String.valueOf((Object)this.consumptionModel));
        sb.append(", isFileServerEnabled=").append(String.valueOf(this.isFileServerEnabled));
        sb.append(", networkEndpointDetails=").append(String.valueOf((Object)this.networkEndpointDetails));
        sb.append(", shape=").append(String.valueOf((Object)this.shape));
        sb.append(", domainId=").append(String.valueOf(this.domainId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateIntegrationInstanceDetails)) {
            return false;
        }
        CreateIntegrationInstanceDetails other = (CreateIntegrationInstanceDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.integrationInstanceType, (Object)other.integrationInstanceType) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.isByol, other.isByol) && Objects.equals(this.idcsAt, other.idcsAt) && Objects.equals(this.messagePacks, other.messagePacks) && Objects.equals(this.isVisualBuilderEnabled, other.isVisualBuilderEnabled) && Objects.equals((Object)this.customEndpoint, (Object)other.customEndpoint) && Objects.equals(this.alternateCustomEndpoints, other.alternateCustomEndpoints) && Objects.equals((Object)this.consumptionModel, (Object)other.consumptionModel) && Objects.equals(this.isFileServerEnabled, other.isFileServerEnabled) && Objects.equals((Object)this.networkEndpointDetails, (Object)other.networkEndpointDetails) && Objects.equals((Object)this.shape, (Object)other.shape) && Objects.equals(this.domainId, other.domainId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.integrationInstanceType == null ? 43 : this.integrationInstanceType.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.isByol == null ? 43 : this.isByol.hashCode());
        result = result * 59 + (this.idcsAt == null ? 43 : this.idcsAt.hashCode());
        result = result * 59 + (this.messagePacks == null ? 43 : this.messagePacks.hashCode());
        result = result * 59 + (this.isVisualBuilderEnabled == null ? 43 : this.isVisualBuilderEnabled.hashCode());
        result = result * 59 + (this.customEndpoint == null ? 43 : this.customEndpoint.hashCode());
        result = result * 59 + (this.alternateCustomEndpoints == null ? 43 : this.alternateCustomEndpoints.hashCode());
        result = result * 59 + (this.consumptionModel == null ? 43 : this.consumptionModel.hashCode());
        result = result * 59 + (this.isFileServerEnabled == null ? 43 : this.isFileServerEnabled.hashCode());
        result = result * 59 + (this.networkEndpointDetails == null ? 43 : this.networkEndpointDetails.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.domainId == null ? 43 : this.domainId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Shape implements BmcEnum
    {
        Development("DEVELOPMENT"),
        Production("PRODUCTION");

        private final String value;
        private static Map<String, Shape> map;

        private Shape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Shape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Shape: " + key);
        }

        static {
            map = new HashMap<String, Shape>();
            for (Shape v : Shape.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConsumptionModel implements BmcEnum
    {
        Ucm("UCM"),
        Gov("GOV"),
        Oic4Saas("OIC4SAAS");

        private final String value;
        private static Map<String, ConsumptionModel> map;

        private ConsumptionModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConsumptionModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ConsumptionModel: " + key);
        }

        static {
            map = new HashMap<String, ConsumptionModel>();
            for (ConsumptionModel v : ConsumptionModel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IntegrationInstanceType implements BmcEnum
    {
        Standard("STANDARD"),
        Enterprise("ENTERPRISE"),
        Standardx("STANDARDX"),
        Enterprisex("ENTERPRISEX"),
        Healthcare("HEALTHCARE");

        private final String value;
        private static Map<String, IntegrationInstanceType> map;

        private IntegrationInstanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntegrationInstanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IntegrationInstanceType: " + key);
        }

        static {
            map = new HashMap<String, IntegrationInstanceType>();
            for (IntegrationInstanceType v : IntegrationInstanceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="integrationInstanceType")
        private IntegrationInstanceType integrationInstanceType;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="idcsAt")
        private String idcsAt;
        @JsonProperty(value="messagePacks")
        private Integer messagePacks;
        @JsonProperty(value="isVisualBuilderEnabled")
        private Boolean isVisualBuilderEnabled;
        @JsonProperty(value="customEndpoint")
        private CreateCustomEndpointDetails customEndpoint;
        @JsonProperty(value="alternateCustomEndpoints")
        private List<CreateCustomEndpointDetails> alternateCustomEndpoints;
        @JsonProperty(value="consumptionModel")
        private ConsumptionModel consumptionModel;
        @JsonProperty(value="isFileServerEnabled")
        private Boolean isFileServerEnabled;
        @JsonProperty(value="networkEndpointDetails")
        private NetworkEndpointDetails networkEndpointDetails;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="domainId")
        private String domainId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder integrationInstanceType(IntegrationInstanceType integrationInstanceType) {
            this.integrationInstanceType = integrationInstanceType;
            this.__explicitlySet__.add("integrationInstanceType");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder idcsAt(String idcsAt) {
            this.idcsAt = idcsAt;
            this.__explicitlySet__.add("idcsAt");
            return this;
        }

        public Builder messagePacks(Integer messagePacks) {
            this.messagePacks = messagePacks;
            this.__explicitlySet__.add("messagePacks");
            return this;
        }

        public Builder isVisualBuilderEnabled(Boolean isVisualBuilderEnabled) {
            this.isVisualBuilderEnabled = isVisualBuilderEnabled;
            this.__explicitlySet__.add("isVisualBuilderEnabled");
            return this;
        }

        public Builder customEndpoint(CreateCustomEndpointDetails customEndpoint) {
            this.customEndpoint = customEndpoint;
            this.__explicitlySet__.add("customEndpoint");
            return this;
        }

        public Builder alternateCustomEndpoints(List<CreateCustomEndpointDetails> alternateCustomEndpoints) {
            this.alternateCustomEndpoints = alternateCustomEndpoints;
            this.__explicitlySet__.add("alternateCustomEndpoints");
            return this;
        }

        public Builder consumptionModel(ConsumptionModel consumptionModel) {
            this.consumptionModel = consumptionModel;
            this.__explicitlySet__.add("consumptionModel");
            return this;
        }

        public Builder isFileServerEnabled(Boolean isFileServerEnabled) {
            this.isFileServerEnabled = isFileServerEnabled;
            this.__explicitlySet__.add("isFileServerEnabled");
            return this;
        }

        public Builder networkEndpointDetails(NetworkEndpointDetails networkEndpointDetails) {
            this.networkEndpointDetails = networkEndpointDetails;
            this.__explicitlySet__.add("networkEndpointDetails");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder domainId(String domainId) {
            this.domainId = domainId;
            this.__explicitlySet__.add("domainId");
            return this;
        }

        public CreateIntegrationInstanceDetails build() {
            CreateIntegrationInstanceDetails model = new CreateIntegrationInstanceDetails(this.displayName, this.compartmentId, this.integrationInstanceType, this.freeformTags, this.definedTags, this.isByol, this.idcsAt, this.messagePacks, this.isVisualBuilderEnabled, this.customEndpoint, this.alternateCustomEndpoints, this.consumptionModel, this.isFileServerEnabled, this.networkEndpointDetails, this.shape, this.domainId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateIntegrationInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("integrationInstanceType")) {
                this.integrationInstanceType(model.getIntegrationInstanceType());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("isByol")) {
                this.isByol(model.getIsByol());
            }
            if (model.wasPropertyExplicitlySet("idcsAt")) {
                this.idcsAt(model.getIdcsAt());
            }
            if (model.wasPropertyExplicitlySet("messagePacks")) {
                this.messagePacks(model.getMessagePacks());
            }
            if (model.wasPropertyExplicitlySet("isVisualBuilderEnabled")) {
                this.isVisualBuilderEnabled(model.getIsVisualBuilderEnabled());
            }
            if (model.wasPropertyExplicitlySet("customEndpoint")) {
                this.customEndpoint(model.getCustomEndpoint());
            }
            if (model.wasPropertyExplicitlySet("alternateCustomEndpoints")) {
                this.alternateCustomEndpoints(model.getAlternateCustomEndpoints());
            }
            if (model.wasPropertyExplicitlySet("consumptionModel")) {
                this.consumptionModel(model.getConsumptionModel());
            }
            if (model.wasPropertyExplicitlySet("isFileServerEnabled")) {
                this.isFileServerEnabled(model.getIsFileServerEnabled());
            }
            if (model.wasPropertyExplicitlySet("networkEndpointDetails")) {
                this.networkEndpointDetails(model.getNetworkEndpointDetails());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("domainId")) {
                this.domainId(model.getDomainId());
            }
            return this;
        }
    }
}

