/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomEndpointDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="certificateSecretId")
    private final String certificateSecretId;
    @JsonProperty(value="certificateSecretVersion")
    private final Integer certificateSecretVersion;
    @JsonProperty(value="alias")
    private final String alias;

    @Deprecated
    @ConstructorProperties(value={"hostname", "certificateSecretId", "certificateSecretVersion", "alias"})
    public CustomEndpointDetails(String hostname, String certificateSecretId, Integer certificateSecretVersion, String alias) {
        this.hostname = hostname;
        this.certificateSecretId = certificateSecretId;
        this.certificateSecretVersion = certificateSecretVersion;
        this.alias = alias;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getCertificateSecretId() {
        return this.certificateSecretId;
    }

    public Integer getCertificateSecretVersion() {
        return this.certificateSecretVersion;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomEndpointDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", certificateSecretId=").append(String.valueOf(this.certificateSecretId));
        sb.append(", certificateSecretVersion=").append(String.valueOf(this.certificateSecretVersion));
        sb.append(", alias=").append(String.valueOf(this.alias));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomEndpointDetails)) {
            return false;
        }
        CustomEndpointDetails other = (CustomEndpointDetails)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals(this.certificateSecretId, other.certificateSecretId) && Objects.equals(this.certificateSecretVersion, other.certificateSecretVersion) && Objects.equals(this.alias, other.alias) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.certificateSecretId == null ? 43 : this.certificateSecretId.hashCode());
        result = result * 59 + (this.certificateSecretVersion == null ? 43 : this.certificateSecretVersion.hashCode());
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="certificateSecretId")
        private String certificateSecretId;
        @JsonProperty(value="certificateSecretVersion")
        private Integer certificateSecretVersion;
        @JsonProperty(value="alias")
        private String alias;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder certificateSecretId(String certificateSecretId) {
            this.certificateSecretId = certificateSecretId;
            this.__explicitlySet__.add("certificateSecretId");
            return this;
        }

        public Builder certificateSecretVersion(Integer certificateSecretVersion) {
            this.certificateSecretVersion = certificateSecretVersion;
            this.__explicitlySet__.add("certificateSecretVersion");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public CustomEndpointDetails build() {
            CustomEndpointDetails model = new CustomEndpointDetails(this.hostname, this.certificateSecretId, this.certificateSecretVersion, this.alias);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("certificateSecretId")) {
                this.certificateSecretId(model.getCertificateSecretId());
            }
            if (model.wasPropertyExplicitlySet("certificateSecretVersion")) {
                this.certificateSecretVersion(model.getCertificateSecretVersion());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            return this;
        }
    }
}

