/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.integration.model.AttachmentDetails;
import com.oracle.bmc.integration.model.CustomEndpointDetails;
import com.oracle.bmc.integration.model.IdcsInfoDetails;
import com.oracle.bmc.integration.model.NetworkEndpointDetails;
import com.oracle.bmc.integration.model.OutboundConnection;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IntegrationInstance
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="integrationInstanceType")
    private final IntegrationInstanceType integrationInstanceType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="stateMessage")
    private final String stateMessage;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="instanceUrl")
    private final String instanceUrl;
    @JsonProperty(value="messagePacks")
    private final Integer messagePacks;
    @JsonProperty(value="isFileServerEnabled")
    private final Boolean isFileServerEnabled;
    @JsonProperty(value="isVisualBuilderEnabled")
    private final Boolean isVisualBuilderEnabled;
    @JsonProperty(value="customEndpoint")
    private final CustomEndpointDetails customEndpoint;
    @JsonProperty(value="alternateCustomEndpoints")
    private final List<CustomEndpointDetails> alternateCustomEndpoints;
    @JsonProperty(value="consumptionModel")
    private final ConsumptionModel consumptionModel;
    @JsonProperty(value="networkEndpointDetails")
    private final NetworkEndpointDetails networkEndpointDetails;
    @JsonProperty(value="idcsInfo")
    private final IdcsInfoDetails idcsInfo;
    @JsonProperty(value="attachments")
    private final List<AttachmentDetails> attachments;
    @JsonProperty(value="shape")
    private final Shape shape;
    @JsonProperty(value="privateEndpointOutboundConnection")
    private final OutboundConnection privateEndpointOutboundConnection;
    @JsonProperty(value="dataRetentionPeriod")
    private final DataRetentionPeriod dataRetentionPeriod;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "integrationInstanceType", "timeCreated", "timeUpdated", "lifecycleState", "stateMessage", "freeformTags", "definedTags", "systemTags", "isByol", "instanceUrl", "messagePacks", "isFileServerEnabled", "isVisualBuilderEnabled", "customEndpoint", "alternateCustomEndpoints", "consumptionModel", "networkEndpointDetails", "idcsInfo", "attachments", "shape", "privateEndpointOutboundConnection", "dataRetentionPeriod"})
    public IntegrationInstance(String id, String displayName, String compartmentId, IntegrationInstanceType integrationInstanceType, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String stateMessage, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, Boolean isByol, String instanceUrl, Integer messagePacks, Boolean isFileServerEnabled, Boolean isVisualBuilderEnabled, CustomEndpointDetails customEndpoint, List<CustomEndpointDetails> alternateCustomEndpoints, ConsumptionModel consumptionModel, NetworkEndpointDetails networkEndpointDetails, IdcsInfoDetails idcsInfo, List<AttachmentDetails> attachments, Shape shape, OutboundConnection privateEndpointOutboundConnection, DataRetentionPeriod dataRetentionPeriod) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.integrationInstanceType = integrationInstanceType;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.stateMessage = stateMessage;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.isByol = isByol;
        this.instanceUrl = instanceUrl;
        this.messagePacks = messagePacks;
        this.isFileServerEnabled = isFileServerEnabled;
        this.isVisualBuilderEnabled = isVisualBuilderEnabled;
        this.customEndpoint = customEndpoint;
        this.alternateCustomEndpoints = alternateCustomEndpoints;
        this.consumptionModel = consumptionModel;
        this.networkEndpointDetails = networkEndpointDetails;
        this.idcsInfo = idcsInfo;
        this.attachments = attachments;
        this.shape = shape;
        this.privateEndpointOutboundConnection = privateEndpointOutboundConnection;
        this.dataRetentionPeriod = dataRetentionPeriod;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public IntegrationInstanceType getIntegrationInstanceType() {
        return this.integrationInstanceType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public Integer getMessagePacks() {
        return this.messagePacks;
    }

    public Boolean getIsFileServerEnabled() {
        return this.isFileServerEnabled;
    }

    public Boolean getIsVisualBuilderEnabled() {
        return this.isVisualBuilderEnabled;
    }

    public CustomEndpointDetails getCustomEndpoint() {
        return this.customEndpoint;
    }

    public List<CustomEndpointDetails> getAlternateCustomEndpoints() {
        return this.alternateCustomEndpoints;
    }

    public ConsumptionModel getConsumptionModel() {
        return this.consumptionModel;
    }

    public NetworkEndpointDetails getNetworkEndpointDetails() {
        return this.networkEndpointDetails;
    }

    public IdcsInfoDetails getIdcsInfo() {
        return this.idcsInfo;
    }

    public List<AttachmentDetails> getAttachments() {
        return this.attachments;
    }

    public Shape getShape() {
        return this.shape;
    }

    public OutboundConnection getPrivateEndpointOutboundConnection() {
        return this.privateEndpointOutboundConnection;
    }

    public DataRetentionPeriod getDataRetentionPeriod() {
        return this.dataRetentionPeriod;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("IntegrationInstance(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", integrationInstanceType=").append(String.valueOf((Object)this.integrationInstanceType));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", stateMessage=").append(String.valueOf(this.stateMessage));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", isByol=").append(String.valueOf(this.isByol));
        sb.append(", instanceUrl=").append(String.valueOf(this.instanceUrl));
        sb.append(", messagePacks=").append(String.valueOf(this.messagePacks));
        sb.append(", isFileServerEnabled=").append(String.valueOf(this.isFileServerEnabled));
        sb.append(", isVisualBuilderEnabled=").append(String.valueOf(this.isVisualBuilderEnabled));
        sb.append(", customEndpoint=").append(String.valueOf((Object)this.customEndpoint));
        sb.append(", alternateCustomEndpoints=").append(String.valueOf(this.alternateCustomEndpoints));
        sb.append(", consumptionModel=").append(String.valueOf((Object)this.consumptionModel));
        sb.append(", networkEndpointDetails=").append(String.valueOf((Object)this.networkEndpointDetails));
        sb.append(", idcsInfo=").append(String.valueOf((Object)this.idcsInfo));
        sb.append(", attachments=").append(String.valueOf(this.attachments));
        sb.append(", shape=").append(String.valueOf((Object)this.shape));
        sb.append(", privateEndpointOutboundConnection=").append(String.valueOf((Object)this.privateEndpointOutboundConnection));
        sb.append(", dataRetentionPeriod=").append(String.valueOf((Object)this.dataRetentionPeriod));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegrationInstance)) {
            return false;
        }
        IntegrationInstance other = (IntegrationInstance)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.integrationInstanceType, (Object)other.integrationInstanceType) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.stateMessage, other.stateMessage) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.isByol, other.isByol) && Objects.equals(this.instanceUrl, other.instanceUrl) && Objects.equals(this.messagePacks, other.messagePacks) && Objects.equals(this.isFileServerEnabled, other.isFileServerEnabled) && Objects.equals(this.isVisualBuilderEnabled, other.isVisualBuilderEnabled) && Objects.equals((Object)this.customEndpoint, (Object)other.customEndpoint) && Objects.equals(this.alternateCustomEndpoints, other.alternateCustomEndpoints) && Objects.equals((Object)this.consumptionModel, (Object)other.consumptionModel) && Objects.equals((Object)this.networkEndpointDetails, (Object)other.networkEndpointDetails) && Objects.equals((Object)this.idcsInfo, (Object)other.idcsInfo) && Objects.equals(this.attachments, other.attachments) && Objects.equals((Object)this.shape, (Object)other.shape) && Objects.equals((Object)this.privateEndpointOutboundConnection, (Object)other.privateEndpointOutboundConnection) && Objects.equals((Object)this.dataRetentionPeriod, (Object)other.dataRetentionPeriod) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.integrationInstanceType == null ? 43 : this.integrationInstanceType.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.stateMessage == null ? 43 : this.stateMessage.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.isByol == null ? 43 : this.isByol.hashCode());
        result = result * 59 + (this.instanceUrl == null ? 43 : this.instanceUrl.hashCode());
        result = result * 59 + (this.messagePacks == null ? 43 : this.messagePacks.hashCode());
        result = result * 59 + (this.isFileServerEnabled == null ? 43 : this.isFileServerEnabled.hashCode());
        result = result * 59 + (this.isVisualBuilderEnabled == null ? 43 : this.isVisualBuilderEnabled.hashCode());
        result = result * 59 + (this.customEndpoint == null ? 43 : this.customEndpoint.hashCode());
        result = result * 59 + (this.alternateCustomEndpoints == null ? 43 : this.alternateCustomEndpoints.hashCode());
        result = result * 59 + (this.consumptionModel == null ? 43 : this.consumptionModel.hashCode());
        result = result * 59 + (this.networkEndpointDetails == null ? 43 : this.networkEndpointDetails.hashCode());
        result = result * 59 + (this.idcsInfo == null ? 43 : this.idcsInfo.hashCode());
        result = result * 59 + (this.attachments == null ? 43 : this.attachments.hashCode());
        result = result * 59 + (this.shape == null ? 43 : this.shape.hashCode());
        result = result * 59 + (this.privateEndpointOutboundConnection == null ? 43 : this.privateEndpointOutboundConnection.hashCode());
        result = result * 59 + (this.dataRetentionPeriod == null ? 43 : this.dataRetentionPeriod.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DataRetentionPeriod implements BmcEnum
    {
        Months1("MONTHS_1"),
        Months3("MONTHS_3"),
        Months6("MONTHS_6"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DataRetentionPeriod> map;

        private DataRetentionPeriod(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataRetentionPeriod create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DataRetentionPeriod', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DataRetentionPeriod.class);
            map = new HashMap<String, DataRetentionPeriod>();
            for (DataRetentionPeriod v : DataRetentionPeriod.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Shape implements BmcEnum
    {
        Development("DEVELOPMENT"),
        Production("PRODUCTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Shape> map;

        private Shape(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Shape create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Shape', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Shape.class);
            map = new HashMap<String, Shape>();
            for (Shape v : Shape.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ConsumptionModel implements BmcEnum
    {
        Ucm("UCM"),
        Gov("GOV"),
        Oic4Saas("OIC4SAAS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConsumptionModel> map;

        private ConsumptionModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConsumptionModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConsumptionModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConsumptionModel.class);
            map = new HashMap<String, ConsumptionModel>();
            for (ConsumptionModel v : ConsumptionModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        Standby("STANDBY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IntegrationInstanceType implements BmcEnum
    {
        Standard("STANDARD"),
        Enterprise("ENTERPRISE"),
        Standardx("STANDARDX"),
        Enterprisex("ENTERPRISEX"),
        Healthcare("HEALTHCARE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IntegrationInstanceType> map;

        private IntegrationInstanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntegrationInstanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IntegrationInstanceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IntegrationInstanceType.class);
            map = new HashMap<String, IntegrationInstanceType>();
            for (IntegrationInstanceType v : IntegrationInstanceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="integrationInstanceType")
        private IntegrationInstanceType integrationInstanceType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="stateMessage")
        private String stateMessage;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="instanceUrl")
        private String instanceUrl;
        @JsonProperty(value="messagePacks")
        private Integer messagePacks;
        @JsonProperty(value="isFileServerEnabled")
        private Boolean isFileServerEnabled;
        @JsonProperty(value="isVisualBuilderEnabled")
        private Boolean isVisualBuilderEnabled;
        @JsonProperty(value="customEndpoint")
        private CustomEndpointDetails customEndpoint;
        @JsonProperty(value="alternateCustomEndpoints")
        private List<CustomEndpointDetails> alternateCustomEndpoints;
        @JsonProperty(value="consumptionModel")
        private ConsumptionModel consumptionModel;
        @JsonProperty(value="networkEndpointDetails")
        private NetworkEndpointDetails networkEndpointDetails;
        @JsonProperty(value="idcsInfo")
        private IdcsInfoDetails idcsInfo;
        @JsonProperty(value="attachments")
        private List<AttachmentDetails> attachments;
        @JsonProperty(value="shape")
        private Shape shape;
        @JsonProperty(value="privateEndpointOutboundConnection")
        private OutboundConnection privateEndpointOutboundConnection;
        @JsonProperty(value="dataRetentionPeriod")
        private DataRetentionPeriod dataRetentionPeriod;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder integrationInstanceType(IntegrationInstanceType integrationInstanceType) {
            this.integrationInstanceType = integrationInstanceType;
            this.__explicitlySet__.add("integrationInstanceType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            this.__explicitlySet__.add("stateMessage");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            this.__explicitlySet__.add("instanceUrl");
            return this;
        }

        public Builder messagePacks(Integer messagePacks) {
            this.messagePacks = messagePacks;
            this.__explicitlySet__.add("messagePacks");
            return this;
        }

        public Builder isFileServerEnabled(Boolean isFileServerEnabled) {
            this.isFileServerEnabled = isFileServerEnabled;
            this.__explicitlySet__.add("isFileServerEnabled");
            return this;
        }

        public Builder isVisualBuilderEnabled(Boolean isVisualBuilderEnabled) {
            this.isVisualBuilderEnabled = isVisualBuilderEnabled;
            this.__explicitlySet__.add("isVisualBuilderEnabled");
            return this;
        }

        public Builder customEndpoint(CustomEndpointDetails customEndpoint) {
            this.customEndpoint = customEndpoint;
            this.__explicitlySet__.add("customEndpoint");
            return this;
        }

        public Builder alternateCustomEndpoints(List<CustomEndpointDetails> alternateCustomEndpoints) {
            this.alternateCustomEndpoints = alternateCustomEndpoints;
            this.__explicitlySet__.add("alternateCustomEndpoints");
            return this;
        }

        public Builder consumptionModel(ConsumptionModel consumptionModel) {
            this.consumptionModel = consumptionModel;
            this.__explicitlySet__.add("consumptionModel");
            return this;
        }

        public Builder networkEndpointDetails(NetworkEndpointDetails networkEndpointDetails) {
            this.networkEndpointDetails = networkEndpointDetails;
            this.__explicitlySet__.add("networkEndpointDetails");
            return this;
        }

        public Builder idcsInfo(IdcsInfoDetails idcsInfo) {
            this.idcsInfo = idcsInfo;
            this.__explicitlySet__.add("idcsInfo");
            return this;
        }

        public Builder attachments(List<AttachmentDetails> attachments) {
            this.attachments = attachments;
            this.__explicitlySet__.add("attachments");
            return this;
        }

        public Builder shape(Shape shape) {
            this.shape = shape;
            this.__explicitlySet__.add("shape");
            return this;
        }

        public Builder privateEndpointOutboundConnection(OutboundConnection privateEndpointOutboundConnection) {
            this.privateEndpointOutboundConnection = privateEndpointOutboundConnection;
            this.__explicitlySet__.add("privateEndpointOutboundConnection");
            return this;
        }

        public Builder dataRetentionPeriod(DataRetentionPeriod dataRetentionPeriod) {
            this.dataRetentionPeriod = dataRetentionPeriod;
            this.__explicitlySet__.add("dataRetentionPeriod");
            return this;
        }

        public IntegrationInstance build() {
            IntegrationInstance model = new IntegrationInstance(this.id, this.displayName, this.compartmentId, this.integrationInstanceType, this.timeCreated, this.timeUpdated, this.lifecycleState, this.stateMessage, this.freeformTags, this.definedTags, this.systemTags, this.isByol, this.instanceUrl, this.messagePacks, this.isFileServerEnabled, this.isVisualBuilderEnabled, this.customEndpoint, this.alternateCustomEndpoints, this.consumptionModel, this.networkEndpointDetails, this.idcsInfo, this.attachments, this.shape, this.privateEndpointOutboundConnection, this.dataRetentionPeriod);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(IntegrationInstance model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("integrationInstanceType")) {
                this.integrationInstanceType(model.getIntegrationInstanceType());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("stateMessage")) {
                this.stateMessage(model.getStateMessage());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("isByol")) {
                this.isByol(model.getIsByol());
            }
            if (model.wasPropertyExplicitlySet("instanceUrl")) {
                this.instanceUrl(model.getInstanceUrl());
            }
            if (model.wasPropertyExplicitlySet("messagePacks")) {
                this.messagePacks(model.getMessagePacks());
            }
            if (model.wasPropertyExplicitlySet("isFileServerEnabled")) {
                this.isFileServerEnabled(model.getIsFileServerEnabled());
            }
            if (model.wasPropertyExplicitlySet("isVisualBuilderEnabled")) {
                this.isVisualBuilderEnabled(model.getIsVisualBuilderEnabled());
            }
            if (model.wasPropertyExplicitlySet("customEndpoint")) {
                this.customEndpoint(model.getCustomEndpoint());
            }
            if (model.wasPropertyExplicitlySet("alternateCustomEndpoints")) {
                this.alternateCustomEndpoints(model.getAlternateCustomEndpoints());
            }
            if (model.wasPropertyExplicitlySet("consumptionModel")) {
                this.consumptionModel(model.getConsumptionModel());
            }
            if (model.wasPropertyExplicitlySet("networkEndpointDetails")) {
                this.networkEndpointDetails(model.getNetworkEndpointDetails());
            }
            if (model.wasPropertyExplicitlySet("idcsInfo")) {
                this.idcsInfo(model.getIdcsInfo());
            }
            if (model.wasPropertyExplicitlySet("attachments")) {
                this.attachments(model.getAttachments());
            }
            if (model.wasPropertyExplicitlySet("shape")) {
                this.shape(model.getShape());
            }
            if (model.wasPropertyExplicitlySet("privateEndpointOutboundConnection")) {
                this.privateEndpointOutboundConnection(model.getPrivateEndpointOutboundConnection());
            }
            if (model.wasPropertyExplicitlySet("dataRetentionPeriod")) {
                this.dataRetentionPeriod(model.getDataRetentionPeriod());
            }
            return this;
        }
    }
}

