/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetIntegrationInstanceRequest
extends BmcRequest<Void> {
    private String integrationInstanceId;
    private String opcRequestId;

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().integrationInstanceId(this.integrationInstanceId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",integrationInstanceId=").append(String.valueOf(this.integrationInstanceId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetIntegrationInstanceRequest)) {
            return false;
        }
        GetIntegrationInstanceRequest other = (GetIntegrationInstanceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.integrationInstanceId, other.integrationInstanceId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.integrationInstanceId == null ? 43 : this.integrationInstanceId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetIntegrationInstanceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String integrationInstanceId = null;
        private String opcRequestId = null;

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetIntegrationInstanceRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetIntegrationInstanceRequest build() {
            GetIntegrationInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetIntegrationInstanceRequest buildWithoutInvocationCallback() {
            GetIntegrationInstanceRequest request = new GetIntegrationInstanceRequest();
            request.integrationInstanceId = this.integrationInstanceId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

