/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AddOracleManagedCustomEndpointDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="dnsType")
    private final DnsType dnsType;
    @JsonProperty(value="dnsZoneName")
    private final String dnsZoneName;

    @Deprecated
    @ConstructorProperties(value={"hostname", "dnsType", "dnsZoneName"})
    public AddOracleManagedCustomEndpointDetails(String hostname, DnsType dnsType, String dnsZoneName) {
        this.hostname = hostname;
        this.dnsType = dnsType;
        this.dnsZoneName = dnsZoneName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public DnsType getDnsType() {
        return this.dnsType;
    }

    public String getDnsZoneName() {
        return this.dnsZoneName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AddOracleManagedCustomEndpointDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", dnsType=").append(String.valueOf((Object)this.dnsType));
        sb.append(", dnsZoneName=").append(String.valueOf(this.dnsZoneName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddOracleManagedCustomEndpointDetails)) {
            return false;
        }
        AddOracleManagedCustomEndpointDetails other = (AddOracleManagedCustomEndpointDetails)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals((Object)this.dnsType, (Object)other.dnsType) && Objects.equals(this.dnsZoneName, other.dnsZoneName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.dnsType == null ? 43 : this.dnsType.hashCode());
        result = result * 59 + (this.dnsZoneName == null ? 43 : this.dnsZoneName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DnsType implements BmcEnum
    {
        Oci("OCI");

        private final String value;
        private static Map<String, DnsType> map;

        private DnsType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DnsType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DnsType: " + key);
        }

        static {
            map = new HashMap<String, DnsType>();
            for (DnsType v : DnsType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="dnsType")
        private DnsType dnsType;
        @JsonProperty(value="dnsZoneName")
        private String dnsZoneName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder dnsType(DnsType dnsType) {
            this.dnsType = dnsType;
            this.__explicitlySet__.add("dnsType");
            return this;
        }

        public Builder dnsZoneName(String dnsZoneName) {
            this.dnsZoneName = dnsZoneName;
            this.__explicitlySet__.add("dnsZoneName");
            return this;
        }

        public AddOracleManagedCustomEndpointDetails build() {
            AddOracleManagedCustomEndpointDetails model = new AddOracleManagedCustomEndpointDetails(this.hostname, this.dnsType, this.dnsZoneName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AddOracleManagedCustomEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("dnsType")) {
                this.dnsType(model.getDnsType());
            }
            if (model.wasPropertyExplicitlySet("dnsZoneName")) {
                this.dnsZoneName(model.getDnsZoneName());
            }
            return this;
        }
    }
}

