/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CrossRegionIntegrationInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="timeRoleChanged")
    private final Date timeRoleChanged;

    @Deprecated
    @ConstructorProperties(value={"role", "id", "region", "timeRoleChanged"})
    public CrossRegionIntegrationInstanceDetails(Role role, String id, String region, Date timeRoleChanged) {
        this.role = role;
        this.id = id;
        this.region = region;
        this.timeRoleChanged = timeRoleChanged;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Role getRole() {
        return this.role;
    }

    public String getId() {
        return this.id;
    }

    public String getRegion() {
        return this.region;
    }

    public Date getTimeRoleChanged() {
        return this.timeRoleChanged;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CrossRegionIntegrationInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("role=").append(String.valueOf((Object)this.role));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", timeRoleChanged=").append(String.valueOf(this.timeRoleChanged));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrossRegionIntegrationInstanceDetails)) {
            return false;
        }
        CrossRegionIntegrationInstanceDetails other = (CrossRegionIntegrationInstanceDetails)((Object)o);
        return Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.id, other.id) && Objects.equals(this.region, other.region) && Objects.equals(this.timeRoleChanged, other.timeRoleChanged) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.timeRoleChanged == null ? 43 : this.timeRoleChanged.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Secondary("SECONDARY"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="timeRoleChanged")
        private Date timeRoleChanged;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder timeRoleChanged(Date timeRoleChanged) {
            this.timeRoleChanged = timeRoleChanged;
            this.__explicitlySet__.add("timeRoleChanged");
            return this;
        }

        public CrossRegionIntegrationInstanceDetails build() {
            CrossRegionIntegrationInstanceDetails model = new CrossRegionIntegrationInstanceDetails(this.role, this.id, this.region, this.timeRoleChanged);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CrossRegionIntegrationInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("timeRoleChanged")) {
                this.timeRoleChanged(model.getTimeRoleChanged());
            }
            return this;
        }
    }
}

