/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.integration.model.CrossRegionIntegrationInstanceDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DisasterRecoveryDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="role")
    private final Role role;
    @JsonProperty(value="regionalInstanceUrl")
    private final String regionalInstanceUrl;
    @JsonProperty(value="crossRegionIntegrationInstanceDetails")
    private final CrossRegionIntegrationInstanceDetails crossRegionIntegrationInstanceDetails;

    @Deprecated
    @ConstructorProperties(value={"role", "regionalInstanceUrl", "crossRegionIntegrationInstanceDetails"})
    public DisasterRecoveryDetails(Role role, String regionalInstanceUrl, CrossRegionIntegrationInstanceDetails crossRegionIntegrationInstanceDetails) {
        this.role = role;
        this.regionalInstanceUrl = regionalInstanceUrl;
        this.crossRegionIntegrationInstanceDetails = crossRegionIntegrationInstanceDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Role getRole() {
        return this.role;
    }

    public String getRegionalInstanceUrl() {
        return this.regionalInstanceUrl;
    }

    public CrossRegionIntegrationInstanceDetails getCrossRegionIntegrationInstanceDetails() {
        return this.crossRegionIntegrationInstanceDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DisasterRecoveryDetails(");
        sb.append("super=").append(super.toString());
        sb.append("role=").append(String.valueOf((Object)this.role));
        sb.append(", regionalInstanceUrl=").append(String.valueOf(this.regionalInstanceUrl));
        sb.append(", crossRegionIntegrationInstanceDetails=").append(String.valueOf((Object)this.crossRegionIntegrationInstanceDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisasterRecoveryDetails)) {
            return false;
        }
        DisasterRecoveryDetails other = (DisasterRecoveryDetails)((Object)o);
        return Objects.equals((Object)this.role, (Object)other.role) && Objects.equals(this.regionalInstanceUrl, other.regionalInstanceUrl) && Objects.equals((Object)this.crossRegionIntegrationInstanceDetails, (Object)other.crossRegionIntegrationInstanceDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.role == null ? 43 : this.role.hashCode());
        result = result * 59 + (this.regionalInstanceUrl == null ? 43 : this.regionalInstanceUrl.hashCode());
        result = result * 59 + (this.crossRegionIntegrationInstanceDetails == null ? 43 : this.crossRegionIntegrationInstanceDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Role implements BmcEnum
    {
        Primary("PRIMARY"),
        Secondary("SECONDARY"),
        Unknown("UNKNOWN"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Role> map;

        private Role(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Role create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Role', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Role.class);
            map = new HashMap<String, Role>();
            for (Role v : Role.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="role")
        private Role role;
        @JsonProperty(value="regionalInstanceUrl")
        private String regionalInstanceUrl;
        @JsonProperty(value="crossRegionIntegrationInstanceDetails")
        private CrossRegionIntegrationInstanceDetails crossRegionIntegrationInstanceDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder role(Role role) {
            this.role = role;
            this.__explicitlySet__.add("role");
            return this;
        }

        public Builder regionalInstanceUrl(String regionalInstanceUrl) {
            this.regionalInstanceUrl = regionalInstanceUrl;
            this.__explicitlySet__.add("regionalInstanceUrl");
            return this;
        }

        public Builder crossRegionIntegrationInstanceDetails(CrossRegionIntegrationInstanceDetails crossRegionIntegrationInstanceDetails) {
            this.crossRegionIntegrationInstanceDetails = crossRegionIntegrationInstanceDetails;
            this.__explicitlySet__.add("crossRegionIntegrationInstanceDetails");
            return this;
        }

        public DisasterRecoveryDetails build() {
            DisasterRecoveryDetails model = new DisasterRecoveryDetails(this.role, this.regionalInstanceUrl, this.crossRegionIntegrationInstanceDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DisasterRecoveryDetails model) {
            if (model.wasPropertyExplicitlySet("role")) {
                this.role(model.getRole());
            }
            if (model.wasPropertyExplicitlySet("regionalInstanceUrl")) {
                this.regionalInstanceUrl(model.getRegionalInstanceUrl());
            }
            if (model.wasPropertyExplicitlySet("crossRegionIntegrationInstanceDetails")) {
                this.crossRegionIntegrationInstanceDetails(model.getCrossRegionIntegrationInstanceDetails());
            }
            return this;
        }
    }
}

