/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.integration.model.UpdateCustomEndpointDetails;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateIntegrationInstanceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="integrationInstanceType")
    private final IntegrationInstanceType integrationInstanceType;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="messagePacks")
    private final Integer messagePacks;
    @JsonProperty(value="isFileServerEnabled")
    private final Boolean isFileServerEnabled;
    @JsonProperty(value="isVisualBuilderEnabled")
    private final Boolean isVisualBuilderEnabled;
    @JsonProperty(value="customEndpoint")
    private final UpdateCustomEndpointDetails customEndpoint;
    @JsonProperty(value="alternateCustomEndpoints")
    private final List<UpdateCustomEndpointDetails> alternateCustomEndpoints;

    @Deprecated
    @ConstructorProperties(value={"displayName", "integrationInstanceType", "freeformTags", "definedTags", "isByol", "messagePacks", "isFileServerEnabled", "isVisualBuilderEnabled", "customEndpoint", "alternateCustomEndpoints"})
    public UpdateIntegrationInstanceDetails(String displayName, IntegrationInstanceType integrationInstanceType, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isByol, Integer messagePacks, Boolean isFileServerEnabled, Boolean isVisualBuilderEnabled, UpdateCustomEndpointDetails customEndpoint, List<UpdateCustomEndpointDetails> alternateCustomEndpoints) {
        this.displayName = displayName;
        this.integrationInstanceType = integrationInstanceType;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isByol = isByol;
        this.messagePacks = messagePacks;
        this.isFileServerEnabled = isFileServerEnabled;
        this.isVisualBuilderEnabled = isVisualBuilderEnabled;
        this.customEndpoint = customEndpoint;
        this.alternateCustomEndpoints = alternateCustomEndpoints;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IntegrationInstanceType getIntegrationInstanceType() {
        return this.integrationInstanceType;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public Integer getMessagePacks() {
        return this.messagePacks;
    }

    public Boolean getIsFileServerEnabled() {
        return this.isFileServerEnabled;
    }

    public Boolean getIsVisualBuilderEnabled() {
        return this.isVisualBuilderEnabled;
    }

    public UpdateCustomEndpointDetails getCustomEndpoint() {
        return this.customEndpoint;
    }

    public List<UpdateCustomEndpointDetails> getAlternateCustomEndpoints() {
        return this.alternateCustomEndpoints;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateIntegrationInstanceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", integrationInstanceType=").append(String.valueOf((Object)this.integrationInstanceType));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", isByol=").append(String.valueOf(this.isByol));
        sb.append(", messagePacks=").append(String.valueOf(this.messagePacks));
        sb.append(", isFileServerEnabled=").append(String.valueOf(this.isFileServerEnabled));
        sb.append(", isVisualBuilderEnabled=").append(String.valueOf(this.isVisualBuilderEnabled));
        sb.append(", customEndpoint=").append(String.valueOf((Object)this.customEndpoint));
        sb.append(", alternateCustomEndpoints=").append(String.valueOf(this.alternateCustomEndpoints));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIntegrationInstanceDetails)) {
            return false;
        }
        UpdateIntegrationInstanceDetails other = (UpdateIntegrationInstanceDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.integrationInstanceType, (Object)other.integrationInstanceType) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.isByol, other.isByol) && Objects.equals(this.messagePacks, other.messagePacks) && Objects.equals(this.isFileServerEnabled, other.isFileServerEnabled) && Objects.equals(this.isVisualBuilderEnabled, other.isVisualBuilderEnabled) && Objects.equals((Object)this.customEndpoint, (Object)other.customEndpoint) && Objects.equals(this.alternateCustomEndpoints, other.alternateCustomEndpoints) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.integrationInstanceType == null ? 43 : this.integrationInstanceType.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.isByol == null ? 43 : this.isByol.hashCode());
        result = result * 59 + (this.messagePacks == null ? 43 : this.messagePacks.hashCode());
        result = result * 59 + (this.isFileServerEnabled == null ? 43 : this.isFileServerEnabled.hashCode());
        result = result * 59 + (this.isVisualBuilderEnabled == null ? 43 : this.isVisualBuilderEnabled.hashCode());
        result = result * 59 + (this.customEndpoint == null ? 43 : this.customEndpoint.hashCode());
        result = result * 59 + (this.alternateCustomEndpoints == null ? 43 : this.alternateCustomEndpoints.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum IntegrationInstanceType implements BmcEnum
    {
        Standard("STANDARD"),
        Enterprise("ENTERPRISE"),
        Standardx("STANDARDX"),
        Enterprisex("ENTERPRISEX"),
        Healthcare("HEALTHCARE");

        private final String value;
        private static Map<String, IntegrationInstanceType> map;

        private IntegrationInstanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntegrationInstanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid IntegrationInstanceType: " + key);
        }

        static {
            map = new HashMap<String, IntegrationInstanceType>();
            for (IntegrationInstanceType v : IntegrationInstanceType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="integrationInstanceType")
        private IntegrationInstanceType integrationInstanceType;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="messagePacks")
        private Integer messagePacks;
        @JsonProperty(value="isFileServerEnabled")
        private Boolean isFileServerEnabled;
        @JsonProperty(value="isVisualBuilderEnabled")
        private Boolean isVisualBuilderEnabled;
        @JsonProperty(value="customEndpoint")
        private UpdateCustomEndpointDetails customEndpoint;
        @JsonProperty(value="alternateCustomEndpoints")
        private List<UpdateCustomEndpointDetails> alternateCustomEndpoints;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder integrationInstanceType(IntegrationInstanceType integrationInstanceType) {
            this.integrationInstanceType = integrationInstanceType;
            this.__explicitlySet__.add("integrationInstanceType");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder messagePacks(Integer messagePacks) {
            this.messagePacks = messagePacks;
            this.__explicitlySet__.add("messagePacks");
            return this;
        }

        public Builder isFileServerEnabled(Boolean isFileServerEnabled) {
            this.isFileServerEnabled = isFileServerEnabled;
            this.__explicitlySet__.add("isFileServerEnabled");
            return this;
        }

        public Builder isVisualBuilderEnabled(Boolean isVisualBuilderEnabled) {
            this.isVisualBuilderEnabled = isVisualBuilderEnabled;
            this.__explicitlySet__.add("isVisualBuilderEnabled");
            return this;
        }

        public Builder customEndpoint(UpdateCustomEndpointDetails customEndpoint) {
            this.customEndpoint = customEndpoint;
            this.__explicitlySet__.add("customEndpoint");
            return this;
        }

        public Builder alternateCustomEndpoints(List<UpdateCustomEndpointDetails> alternateCustomEndpoints) {
            this.alternateCustomEndpoints = alternateCustomEndpoints;
            this.__explicitlySet__.add("alternateCustomEndpoints");
            return this;
        }

        public UpdateIntegrationInstanceDetails build() {
            UpdateIntegrationInstanceDetails model = new UpdateIntegrationInstanceDetails(this.displayName, this.integrationInstanceType, this.freeformTags, this.definedTags, this.isByol, this.messagePacks, this.isFileServerEnabled, this.isVisualBuilderEnabled, this.customEndpoint, this.alternateCustomEndpoints);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateIntegrationInstanceDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("integrationInstanceType")) {
                this.integrationInstanceType(model.getIntegrationInstanceType());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("isByol")) {
                this.isByol(model.getIsByol());
            }
            if (model.wasPropertyExplicitlySet("messagePacks")) {
                this.messagePacks(model.getMessagePacks());
            }
            if (model.wasPropertyExplicitlySet("isFileServerEnabled")) {
                this.isFileServerEnabled(model.getIsFileServerEnabled());
            }
            if (model.wasPropertyExplicitlySet("isVisualBuilderEnabled")) {
                this.isVisualBuilderEnabled(model.getIsVisualBuilderEnabled());
            }
            if (model.wasPropertyExplicitlySet("customEndpoint")) {
                this.customEndpoint(model.getCustomEndpoint());
            }
            if (model.wasPropertyExplicitlySet("alternateCustomEndpoints")) {
                this.alternateCustomEndpoints(model.getAlternateCustomEndpoints());
            }
            return this;
        }
    }
}

