/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CustomEndpointDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="managedType")
    private final ManagedType managedType;
    @JsonProperty(value="dnsZoneName")
    private final String dnsZoneName;
    @JsonProperty(value="dnsType")
    private final DnsType dnsType;
    @JsonProperty(value="certificateSecretId")
    private final String certificateSecretId;
    @JsonProperty(value="certificateSecretVersion")
    private final Integer certificateSecretVersion;
    @JsonProperty(value="alias")
    private final String alias;

    @Deprecated
    @ConstructorProperties(value={"hostname", "managedType", "dnsZoneName", "dnsType", "certificateSecretId", "certificateSecretVersion", "alias"})
    public CustomEndpointDetails(String hostname, ManagedType managedType, String dnsZoneName, DnsType dnsType, String certificateSecretId, Integer certificateSecretVersion, String alias) {
        this.hostname = hostname;
        this.managedType = managedType;
        this.dnsZoneName = dnsZoneName;
        this.dnsType = dnsType;
        this.certificateSecretId = certificateSecretId;
        this.certificateSecretVersion = certificateSecretVersion;
        this.alias = alias;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getHostname() {
        return this.hostname;
    }

    public ManagedType getManagedType() {
        return this.managedType;
    }

    public String getDnsZoneName() {
        return this.dnsZoneName;
    }

    public DnsType getDnsType() {
        return this.dnsType;
    }

    public String getCertificateSecretId() {
        return this.certificateSecretId;
    }

    public Integer getCertificateSecretVersion() {
        return this.certificateSecretVersion;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CustomEndpointDetails(");
        sb.append("super=").append(super.toString());
        sb.append("hostname=").append(String.valueOf(this.hostname));
        sb.append(", managedType=").append(String.valueOf((Object)this.managedType));
        sb.append(", dnsZoneName=").append(String.valueOf(this.dnsZoneName));
        sb.append(", dnsType=").append(String.valueOf((Object)this.dnsType));
        sb.append(", certificateSecretId=").append(String.valueOf(this.certificateSecretId));
        sb.append(", certificateSecretVersion=").append(String.valueOf(this.certificateSecretVersion));
        sb.append(", alias=").append(String.valueOf(this.alias));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomEndpointDetails)) {
            return false;
        }
        CustomEndpointDetails other = (CustomEndpointDetails)((Object)o);
        return Objects.equals(this.hostname, other.hostname) && Objects.equals((Object)this.managedType, (Object)other.managedType) && Objects.equals(this.dnsZoneName, other.dnsZoneName) && Objects.equals((Object)this.dnsType, (Object)other.dnsType) && Objects.equals(this.certificateSecretId, other.certificateSecretId) && Objects.equals(this.certificateSecretVersion, other.certificateSecretVersion) && Objects.equals(this.alias, other.alias) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.managedType == null ? 43 : this.managedType.hashCode());
        result = result * 59 + (this.dnsZoneName == null ? 43 : this.dnsZoneName.hashCode());
        result = result * 59 + (this.dnsType == null ? 43 : this.dnsType.hashCode());
        result = result * 59 + (this.certificateSecretId == null ? 43 : this.certificateSecretId.hashCode());
        result = result * 59 + (this.certificateSecretVersion == null ? 43 : this.certificateSecretVersion.hashCode());
        result = result * 59 + (this.alias == null ? 43 : this.alias.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum DnsType implements BmcEnum
    {
        Oci("OCI"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DnsType> map;

        private DnsType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DnsType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DnsType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DnsType.class);
            map = new HashMap<String, DnsType>();
            for (DnsType v : DnsType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ManagedType implements BmcEnum
    {
        OracleManaged("ORACLE_MANAGED"),
        CustomerManaged("CUSTOMER_MANAGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ManagedType> map;

        private ManagedType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ManagedType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ManagedType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ManagedType.class);
            map = new HashMap<String, ManagedType>();
            for (ManagedType v : ManagedType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="managedType")
        private ManagedType managedType;
        @JsonProperty(value="dnsZoneName")
        private String dnsZoneName;
        @JsonProperty(value="dnsType")
        private DnsType dnsType;
        @JsonProperty(value="certificateSecretId")
        private String certificateSecretId;
        @JsonProperty(value="certificateSecretVersion")
        private Integer certificateSecretVersion;
        @JsonProperty(value="alias")
        private String alias;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder managedType(ManagedType managedType) {
            this.managedType = managedType;
            this.__explicitlySet__.add("managedType");
            return this;
        }

        public Builder dnsZoneName(String dnsZoneName) {
            this.dnsZoneName = dnsZoneName;
            this.__explicitlySet__.add("dnsZoneName");
            return this;
        }

        public Builder dnsType(DnsType dnsType) {
            this.dnsType = dnsType;
            this.__explicitlySet__.add("dnsType");
            return this;
        }

        public Builder certificateSecretId(String certificateSecretId) {
            this.certificateSecretId = certificateSecretId;
            this.__explicitlySet__.add("certificateSecretId");
            return this;
        }

        public Builder certificateSecretVersion(Integer certificateSecretVersion) {
            this.certificateSecretVersion = certificateSecretVersion;
            this.__explicitlySet__.add("certificateSecretVersion");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.__explicitlySet__.add("alias");
            return this;
        }

        public CustomEndpointDetails build() {
            CustomEndpointDetails model = new CustomEndpointDetails(this.hostname, this.managedType, this.dnsZoneName, this.dnsType, this.certificateSecretId, this.certificateSecretVersion, this.alias);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CustomEndpointDetails model) {
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("managedType")) {
                this.managedType(model.getManagedType());
            }
            if (model.wasPropertyExplicitlySet("dnsZoneName")) {
                this.dnsZoneName(model.getDnsZoneName());
            }
            if (model.wasPropertyExplicitlySet("dnsType")) {
                this.dnsType(model.getDnsType());
            }
            if (model.wasPropertyExplicitlySet("certificateSecretId")) {
                this.certificateSecretId(model.getCertificateSecretId());
            }
            if (model.wasPropertyExplicitlySet("certificateSecretVersion")) {
                this.certificateSecretVersion(model.getCertificateSecretVersion());
            }
            if (model.wasPropertyExplicitlySet("alias")) {
                this.alias(model.getAlias());
            }
            return this;
        }
    }
}

