/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.integration.model.ExtendDataRetentionDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ExtendDataRetentionRequest
extends BmcRequest<ExtendDataRetentionDetails> {
    private String integrationInstanceId;
    private ExtendDataRetentionDetails extendDataRetentionDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public ExtendDataRetentionDetails getExtendDataRetentionDetails() {
        return this.extendDataRetentionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public ExtendDataRetentionDetails getBody$() {
        return this.extendDataRetentionDetails;
    }

    public Builder toBuilder() {
        return new Builder().integrationInstanceId(this.integrationInstanceId).extendDataRetentionDetails(this.extendDataRetentionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",integrationInstanceId=").append(String.valueOf(this.integrationInstanceId));
        sb.append(",extendDataRetentionDetails=").append(String.valueOf((Object)this.extendDataRetentionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendDataRetentionRequest)) {
            return false;
        }
        ExtendDataRetentionRequest other = (ExtendDataRetentionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.integrationInstanceId, other.integrationInstanceId) && Objects.equals((Object)this.extendDataRetentionDetails, (Object)other.extendDataRetentionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.integrationInstanceId == null ? 43 : this.integrationInstanceId.hashCode());
        result = result * 59 + (this.extendDataRetentionDetails == null ? 43 : this.extendDataRetentionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ExtendDataRetentionRequest, ExtendDataRetentionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String integrationInstanceId = null;
        private ExtendDataRetentionDetails extendDataRetentionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder extendDataRetentionDetails(ExtendDataRetentionDetails extendDataRetentionDetails) {
            this.extendDataRetentionDetails = extendDataRetentionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ExtendDataRetentionRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.extendDataRetentionDetails(o.getExtendDataRetentionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ExtendDataRetentionRequest build() {
            ExtendDataRetentionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ExtendDataRetentionDetails body) {
            this.extendDataRetentionDetails(body);
            return this;
        }

        public ExtendDataRetentionRequest buildWithoutInvocationCallback() {
            ExtendDataRetentionRequest request = new ExtendDataRetentionRequest();
            request.integrationInstanceId = this.integrationInstanceId;
            request.extendDataRetentionDetails = this.extendDataRetentionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

