/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.AgentType;
import com.oracle.bmc.jms.model.JreSecurityStatus;
import com.oracle.bmc.jms.model.Plugin;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Agent
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="type")
    private final AgentType type;
    @JsonProperty(value="javaVersion")
    private final String javaVersion;
    @JsonProperty(value="javaSecurityStatus")
    private final JreSecurityStatus javaSecurityStatus;
    @JsonProperty(value="plugins")
    private final List<Plugin> plugins;

    @Deprecated
    @ConstructorProperties(value={"displayName", "type", "javaVersion", "javaSecurityStatus", "plugins"})
    public Agent(String displayName, AgentType type, String javaVersion, JreSecurityStatus javaSecurityStatus, List<Plugin> plugins) {
        this.displayName = displayName;
        this.type = type;
        this.javaVersion = javaVersion;
        this.javaSecurityStatus = javaSecurityStatus;
        this.plugins = plugins;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AgentType getType() {
        return this.type;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public JreSecurityStatus getJavaSecurityStatus() {
        return this.javaSecurityStatus;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Agent(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", javaVersion=").append(String.valueOf(this.javaVersion));
        sb.append(", javaSecurityStatus=").append(String.valueOf((Object)this.javaSecurityStatus));
        sb.append(", plugins=").append(String.valueOf(this.plugins));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Agent)) {
            return false;
        }
        Agent other = (Agent)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.javaVersion, other.javaVersion) && Objects.equals((Object)this.javaSecurityStatus, (Object)other.javaSecurityStatus) && Objects.equals(this.plugins, other.plugins) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.javaVersion == null ? 43 : this.javaVersion.hashCode());
        result = result * 59 + (this.javaSecurityStatus == null ? 43 : this.javaSecurityStatus.hashCode());
        result = result * 59 + (this.plugins == null ? 43 : this.plugins.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="type")
        private AgentType type;
        @JsonProperty(value="javaVersion")
        private String javaVersion;
        @JsonProperty(value="javaSecurityStatus")
        private JreSecurityStatus javaSecurityStatus;
        @JsonProperty(value="plugins")
        private List<Plugin> plugins;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder type(AgentType type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder javaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            this.__explicitlySet__.add("javaVersion");
            return this;
        }

        public Builder javaSecurityStatus(JreSecurityStatus javaSecurityStatus) {
            this.javaSecurityStatus = javaSecurityStatus;
            this.__explicitlySet__.add("javaSecurityStatus");
            return this;
        }

        public Builder plugins(List<Plugin> plugins) {
            this.plugins = plugins;
            this.__explicitlySet__.add("plugins");
            return this;
        }

        public Agent build() {
            Agent model = new Agent(this.displayName, this.type, this.javaVersion, this.javaSecurityStatus, this.plugins);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Agent model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("javaVersion")) {
                this.javaVersion(model.getJavaVersion());
            }
            if (model.wasPropertyExplicitlySet("javaSecurityStatus")) {
                this.javaSecurityStatus(model.getJavaSecurityStatus());
            }
            if (model.wasPropertyExplicitlySet("plugins")) {
                this.plugins(model.getPlugins());
            }
            return this;
        }
    }
}

