/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.OperatingSystem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class InstallationUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="installationKey")
    private final String installationKey;
    @JsonProperty(value="jreVendor")
    private final String jreVendor;
    @JsonProperty(value="jreDistribution")
    private final String jreDistribution;
    @JsonProperty(value="jreVersion")
    private final String jreVersion;
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="os")
    private final String os;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="operatingSystem")
    private final OperatingSystem operatingSystem;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="approximateManagedInstanceCount")
    private final Integer approximateManagedInstanceCount;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"installationKey", "jreVendor", "jreDistribution", "jreVersion", "path", "os", "architecture", "operatingSystem", "approximateApplicationCount", "approximateManagedInstanceCount", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public InstallationUsage(String installationKey, String jreVendor, String jreDistribution, String jreVersion, String path, String os, String architecture, OperatingSystem operatingSystem, Integer approximateApplicationCount, Integer approximateManagedInstanceCount, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.installationKey = installationKey;
        this.jreVendor = jreVendor;
        this.jreDistribution = jreDistribution;
        this.jreVersion = jreVersion;
        this.path = path;
        this.os = os;
        this.architecture = architecture;
        this.operatingSystem = operatingSystem;
        this.approximateApplicationCount = approximateApplicationCount;
        this.approximateManagedInstanceCount = approximateManagedInstanceCount;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getInstallationKey() {
        return this.installationKey;
    }

    public String getJreVendor() {
        return this.jreVendor;
    }

    public String getJreDistribution() {
        return this.jreDistribution;
    }

    public String getJreVersion() {
        return this.jreVersion;
    }

    public String getPath() {
        return this.path;
    }

    public String getOs() {
        return this.os;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Integer getApproximateManagedInstanceCount() {
        return this.approximateManagedInstanceCount;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("InstallationUsage(");
        sb.append("super=").append(super.toString());
        sb.append("installationKey=").append(String.valueOf(this.installationKey));
        sb.append(", jreVendor=").append(String.valueOf(this.jreVendor));
        sb.append(", jreDistribution=").append(String.valueOf(this.jreDistribution));
        sb.append(", jreVersion=").append(String.valueOf(this.jreVersion));
        sb.append(", path=").append(String.valueOf(this.path));
        sb.append(", os=").append(String.valueOf(this.os));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", operatingSystem=").append(String.valueOf((Object)this.operatingSystem));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", approximateManagedInstanceCount=").append(String.valueOf(this.approximateManagedInstanceCount));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InstallationUsage)) {
            return false;
        }
        InstallationUsage other = (InstallationUsage)((Object)o);
        return Objects.equals(this.installationKey, other.installationKey) && Objects.equals(this.jreVendor, other.jreVendor) && Objects.equals(this.jreDistribution, other.jreDistribution) && Objects.equals(this.jreVersion, other.jreVersion) && Objects.equals(this.path, other.path) && Objects.equals(this.os, other.os) && Objects.equals(this.architecture, other.architecture) && Objects.equals((Object)this.operatingSystem, (Object)other.operatingSystem) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.approximateManagedInstanceCount, other.approximateManagedInstanceCount) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.installationKey == null ? 43 : this.installationKey.hashCode());
        result = result * 59 + (this.jreVendor == null ? 43 : this.jreVendor.hashCode());
        result = result * 59 + (this.jreDistribution == null ? 43 : this.jreDistribution.hashCode());
        result = result * 59 + (this.jreVersion == null ? 43 : this.jreVersion.hashCode());
        result = result * 59 + (this.path == null ? 43 : this.path.hashCode());
        result = result * 59 + (this.os == null ? 43 : this.os.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.approximateManagedInstanceCount == null ? 43 : this.approximateManagedInstanceCount.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="installationKey")
        private String installationKey;
        @JsonProperty(value="jreVendor")
        private String jreVendor;
        @JsonProperty(value="jreDistribution")
        private String jreDistribution;
        @JsonProperty(value="jreVersion")
        private String jreVersion;
        @JsonProperty(value="path")
        private String path;
        @JsonProperty(value="os")
        private String os;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="approximateManagedInstanceCount")
        private Integer approximateManagedInstanceCount;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder installationKey(String installationKey) {
            this.installationKey = installationKey;
            this.__explicitlySet__.add("installationKey");
            return this;
        }

        public Builder jreVendor(String jreVendor) {
            this.jreVendor = jreVendor;
            this.__explicitlySet__.add("jreVendor");
            return this;
        }

        public Builder jreDistribution(String jreDistribution) {
            this.jreDistribution = jreDistribution;
            this.__explicitlySet__.add("jreDistribution");
            return this;
        }

        public Builder jreVersion(String jreVersion) {
            this.jreVersion = jreVersion;
            this.__explicitlySet__.add("jreVersion");
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            this.__explicitlySet__.add("path");
            return this;
        }

        public Builder os(String os) {
            this.os = os;
            this.__explicitlySet__.add("os");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder approximateManagedInstanceCount(Integer approximateManagedInstanceCount) {
            this.approximateManagedInstanceCount = approximateManagedInstanceCount;
            this.__explicitlySet__.add("approximateManagedInstanceCount");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public InstallationUsage build() {
            InstallationUsage model = new InstallationUsage(this.installationKey, this.jreVendor, this.jreDistribution, this.jreVersion, this.path, this.os, this.architecture, this.operatingSystem, this.approximateApplicationCount, this.approximateManagedInstanceCount, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(InstallationUsage model) {
            if (model.wasPropertyExplicitlySet("installationKey")) {
                this.installationKey(model.getInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("jreVendor")) {
                this.jreVendor(model.getJreVendor());
            }
            if (model.wasPropertyExplicitlySet("jreDistribution")) {
                this.jreDistribution(model.getJreDistribution());
            }
            if (model.wasPropertyExplicitlySet("jreVersion")) {
                this.jreVersion(model.getJreVersion());
            }
            if (model.wasPropertyExplicitlySet("path")) {
                this.path(model.getPath());
            }
            if (model.wasPropertyExplicitlySet("os")) {
                this.os(model.getOs());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateManagedInstanceCount")) {
                this.approximateManagedInstanceCount(model.getApproximateManagedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

