/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaMigrationAnalysisTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="applicationInstallationKey")
    private final String applicationInstallationKey;
    @JsonProperty(value="sourceJdkVersion")
    private final String sourceJdkVersion;
    @JsonProperty(value="targetJdkVersion")
    private final String targetJdkVersion;

    @Deprecated
    @ConstructorProperties(value={"managedInstanceId", "applicationInstallationKey", "sourceJdkVersion", "targetJdkVersion"})
    public JavaMigrationAnalysisTarget(String managedInstanceId, String applicationInstallationKey, String sourceJdkVersion, String targetJdkVersion) {
        this.managedInstanceId = managedInstanceId;
        this.applicationInstallationKey = applicationInstallationKey;
        this.sourceJdkVersion = sourceJdkVersion;
        this.targetJdkVersion = targetJdkVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getApplicationInstallationKey() {
        return this.applicationInstallationKey;
    }

    public String getSourceJdkVersion() {
        return this.sourceJdkVersion;
    }

    public String getTargetJdkVersion() {
        return this.targetJdkVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaMigrationAnalysisTarget(");
        sb.append("super=").append(super.toString());
        sb.append("managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", applicationInstallationKey=").append(String.valueOf(this.applicationInstallationKey));
        sb.append(", sourceJdkVersion=").append(String.valueOf(this.sourceJdkVersion));
        sb.append(", targetJdkVersion=").append(String.valueOf(this.targetJdkVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMigrationAnalysisTarget)) {
            return false;
        }
        JavaMigrationAnalysisTarget other = (JavaMigrationAnalysisTarget)((Object)o);
        return Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.applicationInstallationKey, other.applicationInstallationKey) && Objects.equals(this.sourceJdkVersion, other.sourceJdkVersion) && Objects.equals(this.targetJdkVersion, other.targetJdkVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.applicationInstallationKey == null ? 43 : this.applicationInstallationKey.hashCode());
        result = result * 59 + (this.sourceJdkVersion == null ? 43 : this.sourceJdkVersion.hashCode());
        result = result * 59 + (this.targetJdkVersion == null ? 43 : this.targetJdkVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="applicationInstallationKey")
        private String applicationInstallationKey;
        @JsonProperty(value="sourceJdkVersion")
        private String sourceJdkVersion;
        @JsonProperty(value="targetJdkVersion")
        private String targetJdkVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder applicationInstallationKey(String applicationInstallationKey) {
            this.applicationInstallationKey = applicationInstallationKey;
            this.__explicitlySet__.add("applicationInstallationKey");
            return this;
        }

        public Builder sourceJdkVersion(String sourceJdkVersion) {
            this.sourceJdkVersion = sourceJdkVersion;
            this.__explicitlySet__.add("sourceJdkVersion");
            return this;
        }

        public Builder targetJdkVersion(String targetJdkVersion) {
            this.targetJdkVersion = targetJdkVersion;
            this.__explicitlySet__.add("targetJdkVersion");
            return this;
        }

        public JavaMigrationAnalysisTarget build() {
            JavaMigrationAnalysisTarget model = new JavaMigrationAnalysisTarget(this.managedInstanceId, this.applicationInstallationKey, this.sourceJdkVersion, this.targetJdkVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaMigrationAnalysisTarget model) {
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("applicationInstallationKey")) {
                this.applicationInstallationKey(model.getApplicationInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("sourceJdkVersion")) {
                this.sourceJdkVersion(model.getSourceJdkVersion());
            }
            if (model.wasPropertyExplicitlySet("targetJdkVersion")) {
                this.targetJdkVersion(model.getTargetJdkVersion());
            }
            return this;
        }
    }
}

