/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaRuntimeId
extends ExplicitlySetBmcModel {
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="vendor")
    private final String vendor;
    @JsonProperty(value="distribution")
    private final String distribution;
    @JsonProperty(value="jreKey")
    private final String jreKey;

    @Deprecated
    @ConstructorProperties(value={"version", "vendor", "distribution", "jreKey"})
    public JavaRuntimeId(String version, String vendor, String distribution, String jreKey) {
        this.version = version;
        this.vendor = vendor;
        this.distribution = distribution;
        this.jreKey = jreKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getVersion() {
        return this.version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getJreKey() {
        return this.jreKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaRuntimeId(");
        sb.append("super=").append(super.toString());
        sb.append("version=").append(String.valueOf(this.version));
        sb.append(", vendor=").append(String.valueOf(this.vendor));
        sb.append(", distribution=").append(String.valueOf(this.distribution));
        sb.append(", jreKey=").append(String.valueOf(this.jreKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaRuntimeId)) {
            return false;
        }
        JavaRuntimeId other = (JavaRuntimeId)((Object)o);
        return Objects.equals(this.version, other.version) && Objects.equals(this.vendor, other.vendor) && Objects.equals(this.distribution, other.distribution) && Objects.equals(this.jreKey, other.jreKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = result * 59 + (this.distribution == null ? 43 : this.distribution.hashCode());
        result = result * 59 + (this.jreKey == null ? 43 : this.jreKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="vendor")
        private String vendor;
        @JsonProperty(value="distribution")
        private String distribution;
        @JsonProperty(value="jreKey")
        private String jreKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        public Builder distribution(String distribution) {
            this.distribution = distribution;
            this.__explicitlySet__.add("distribution");
            return this;
        }

        public Builder jreKey(String jreKey) {
            this.jreKey = jreKey;
            this.__explicitlySet__.add("jreKey");
            return this;
        }

        public JavaRuntimeId build() {
            JavaRuntimeId model = new JavaRuntimeId(this.version, this.vendor, this.distribution, this.jreKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaRuntimeId model) {
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            if (model.wasPropertyExplicitlySet("distribution")) {
                this.distribution(model.getDistribution());
            }
            if (model.wasPropertyExplicitlySet("jreKey")) {
                this.jreKey(model.getJreKey());
            }
            return this;
        }
    }
}

