/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaServerUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="serverKey")
    private final String serverKey;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="serverName")
    private final String serverName;
    @JsonProperty(value="serverVersion")
    private final String serverVersion;
    @JsonProperty(value="serverInstanceCount")
    private final Integer serverInstanceCount;
    @JsonProperty(value="approximateDeployedApplicationCount")
    private final Integer approximateDeployedApplicationCount;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"serverKey", "fleetId", "serverName", "serverVersion", "serverInstanceCount", "approximateDeployedApplicationCount", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public JavaServerUsage(String serverKey, String fleetId, String serverName, String serverVersion, Integer serverInstanceCount, Integer approximateDeployedApplicationCount, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.serverKey = serverKey;
        this.fleetId = fleetId;
        this.serverName = serverName;
        this.serverVersion = serverVersion;
        this.serverInstanceCount = serverInstanceCount;
        this.approximateDeployedApplicationCount = approximateDeployedApplicationCount;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public Integer getServerInstanceCount() {
        return this.serverInstanceCount;
    }

    public Integer getApproximateDeployedApplicationCount() {
        return this.approximateDeployedApplicationCount;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaServerUsage(");
        sb.append("super=").append(super.toString());
        sb.append("serverKey=").append(String.valueOf(this.serverKey));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", serverName=").append(String.valueOf(this.serverName));
        sb.append(", serverVersion=").append(String.valueOf(this.serverVersion));
        sb.append(", serverInstanceCount=").append(String.valueOf(this.serverInstanceCount));
        sb.append(", approximateDeployedApplicationCount=").append(String.valueOf(this.approximateDeployedApplicationCount));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaServerUsage)) {
            return false;
        }
        JavaServerUsage other = (JavaServerUsage)((Object)o);
        return Objects.equals(this.serverKey, other.serverKey) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.serverName, other.serverName) && Objects.equals(this.serverVersion, other.serverVersion) && Objects.equals(this.serverInstanceCount, other.serverInstanceCount) && Objects.equals(this.approximateDeployedApplicationCount, other.approximateDeployedApplicationCount) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.serverKey == null ? 43 : this.serverKey.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.serverName == null ? 43 : this.serverName.hashCode());
        result = result * 59 + (this.serverVersion == null ? 43 : this.serverVersion.hashCode());
        result = result * 59 + (this.serverInstanceCount == null ? 43 : this.serverInstanceCount.hashCode());
        result = result * 59 + (this.approximateDeployedApplicationCount == null ? 43 : this.approximateDeployedApplicationCount.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="serverKey")
        private String serverKey;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="serverName")
        private String serverName;
        @JsonProperty(value="serverVersion")
        private String serverVersion;
        @JsonProperty(value="serverInstanceCount")
        private Integer serverInstanceCount;
        @JsonProperty(value="approximateDeployedApplicationCount")
        private Integer approximateDeployedApplicationCount;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder serverKey(String serverKey) {
            this.serverKey = serverKey;
            this.__explicitlySet__.add("serverKey");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder serverName(String serverName) {
            this.serverName = serverName;
            this.__explicitlySet__.add("serverName");
            return this;
        }

        public Builder serverVersion(String serverVersion) {
            this.serverVersion = serverVersion;
            this.__explicitlySet__.add("serverVersion");
            return this;
        }

        public Builder serverInstanceCount(Integer serverInstanceCount) {
            this.serverInstanceCount = serverInstanceCount;
            this.__explicitlySet__.add("serverInstanceCount");
            return this;
        }

        public Builder approximateDeployedApplicationCount(Integer approximateDeployedApplicationCount) {
            this.approximateDeployedApplicationCount = approximateDeployedApplicationCount;
            this.__explicitlySet__.add("approximateDeployedApplicationCount");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public JavaServerUsage build() {
            JavaServerUsage model = new JavaServerUsage(this.serverKey, this.fleetId, this.serverName, this.serverVersion, this.serverInstanceCount, this.approximateDeployedApplicationCount, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaServerUsage model) {
            if (model.wasPropertyExplicitlySet("serverKey")) {
                this.serverKey(model.getServerKey());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("serverName")) {
                this.serverName(model.getServerName());
            }
            if (model.wasPropertyExplicitlySet("serverVersion")) {
                this.serverVersion(model.getServerVersion());
            }
            if (model.wasPropertyExplicitlySet("serverInstanceCount")) {
                this.serverInstanceCount(model.getServerInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("approximateDeployedApplicationCount")) {
                this.approximateDeployedApplicationCount(model.getApproximateDeployedApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

