/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.RequestPerformanceTuningAnalysesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestPerformanceTuningAnalysesRequest
extends BmcRequest<RequestPerformanceTuningAnalysesDetails> {
    private String fleetId;
    private RequestPerformanceTuningAnalysesDetails requestPerformanceTuningAnalysesDetails;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public RequestPerformanceTuningAnalysesDetails getRequestPerformanceTuningAnalysesDetails() {
        return this.requestPerformanceTuningAnalysesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RequestPerformanceTuningAnalysesDetails getBody$() {
        return this.requestPerformanceTuningAnalysesDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).requestPerformanceTuningAnalysesDetails(this.requestPerformanceTuningAnalysesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",requestPerformanceTuningAnalysesDetails=").append(String.valueOf((Object)this.requestPerformanceTuningAnalysesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestPerformanceTuningAnalysesRequest)) {
            return false;
        }
        RequestPerformanceTuningAnalysesRequest other = (RequestPerformanceTuningAnalysesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.requestPerformanceTuningAnalysesDetails, (Object)other.requestPerformanceTuningAnalysesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.requestPerformanceTuningAnalysesDetails == null ? 43 : this.requestPerformanceTuningAnalysesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestPerformanceTuningAnalysesRequest, RequestPerformanceTuningAnalysesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private RequestPerformanceTuningAnalysesDetails requestPerformanceTuningAnalysesDetails = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder requestPerformanceTuningAnalysesDetails(RequestPerformanceTuningAnalysesDetails requestPerformanceTuningAnalysesDetails) {
            this.requestPerformanceTuningAnalysesDetails = requestPerformanceTuningAnalysesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestPerformanceTuningAnalysesRequest o) {
            this.fleetId(o.getFleetId());
            this.requestPerformanceTuningAnalysesDetails(o.getRequestPerformanceTuningAnalysesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestPerformanceTuningAnalysesRequest build() {
            RequestPerformanceTuningAnalysesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RequestPerformanceTuningAnalysesDetails body) {
            this.requestPerformanceTuningAnalysesDetails(body);
            return this;
        }

        public RequestPerformanceTuningAnalysesRequest buildWithoutInvocationCallback() {
            RequestPerformanceTuningAnalysesRequest request = new RequestPerformanceTuningAnalysesRequest();
            request.fleetId = this.fleetId;
            request.requestPerformanceTuningAnalysesDetails = this.requestPerformanceTuningAnalysesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

