/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.jms.JavaManagementService;
import com.oracle.bmc.jms.JavaManagementServicePaginators;
import com.oracle.bmc.jms.JavaManagementServiceWaiters;
import com.oracle.bmc.jms.model.AgentInstallerCollection;
import com.oracle.bmc.jms.model.AnnouncementCollection;
import com.oracle.bmc.jms.model.ApplicationInstallationUsageSummaryCollection;
import com.oracle.bmc.jms.model.ApplicationUsageCollection;
import com.oracle.bmc.jms.model.Blocklist;
import com.oracle.bmc.jms.model.BlocklistCollection;
import com.oracle.bmc.jms.model.CryptoAnalysisResult;
import com.oracle.bmc.jms.model.CryptoAnalysisResultCollection;
import com.oracle.bmc.jms.model.DeployedApplicationInstallationUsageSummaryCollection;
import com.oracle.bmc.jms.model.DeployedApplicationUsageCollection;
import com.oracle.bmc.jms.model.DrsFile;
import com.oracle.bmc.jms.model.DrsFileCollection;
import com.oracle.bmc.jms.model.ExportSetting;
import com.oracle.bmc.jms.model.ExportStatus;
import com.oracle.bmc.jms.model.Fleet;
import com.oracle.bmc.jms.model.FleetAdvancedFeatureConfiguration;
import com.oracle.bmc.jms.model.FleetAgentConfiguration;
import com.oracle.bmc.jms.model.FleetCollection;
import com.oracle.bmc.jms.model.FleetDiagnosisCollection;
import com.oracle.bmc.jms.model.InstallationSiteCollection;
import com.oracle.bmc.jms.model.InstallationUsageCollection;
import com.oracle.bmc.jms.model.JavaFamily;
import com.oracle.bmc.jms.model.JavaFamilyCollection;
import com.oracle.bmc.jms.model.JavaMigrationAnalysisResult;
import com.oracle.bmc.jms.model.JavaMigrationAnalysisResultCollection;
import com.oracle.bmc.jms.model.JavaRelease;
import com.oracle.bmc.jms.model.JavaReleaseCollection;
import com.oracle.bmc.jms.model.JavaServerInstanceUsageCollection;
import com.oracle.bmc.jms.model.JavaServerUsageCollection;
import com.oracle.bmc.jms.model.JmsPlugin;
import com.oracle.bmc.jms.model.JmsPluginCollection;
import com.oracle.bmc.jms.model.JreUsageCollection;
import com.oracle.bmc.jms.model.LibraryUsageCollection;
import com.oracle.bmc.jms.model.ManagedInstanceUsageCollection;
import com.oracle.bmc.jms.model.PerformanceTuningAnalysisResult;
import com.oracle.bmc.jms.model.PerformanceTuningAnalysisResultCollection;
import com.oracle.bmc.jms.model.ResourceInventory;
import com.oracle.bmc.jms.model.WorkItemCollection;
import com.oracle.bmc.jms.model.WorkRequest;
import com.oracle.bmc.jms.model.WorkRequestCollection;
import com.oracle.bmc.jms.model.WorkRequestErrorCollection;
import com.oracle.bmc.jms.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.jms.requests.AddFleetInstallationSitesRequest;
import com.oracle.bmc.jms.requests.CancelWorkRequestRequest;
import com.oracle.bmc.jms.requests.ChangeFleetCompartmentRequest;
import com.oracle.bmc.jms.requests.CreateBlocklistRequest;
import com.oracle.bmc.jms.requests.CreateDrsFileRequest;
import com.oracle.bmc.jms.requests.CreateFleetRequest;
import com.oracle.bmc.jms.requests.CreateJmsPluginRequest;
import com.oracle.bmc.jms.requests.DeleteBlocklistRequest;
import com.oracle.bmc.jms.requests.DeleteCryptoAnalysisResultRequest;
import com.oracle.bmc.jms.requests.DeleteDrsFileRequest;
import com.oracle.bmc.jms.requests.DeleteFleetRequest;
import com.oracle.bmc.jms.requests.DeleteJavaMigrationAnalysisResultRequest;
import com.oracle.bmc.jms.requests.DeleteJmsPluginRequest;
import com.oracle.bmc.jms.requests.DeletePerformanceTuningAnalysisResultRequest;
import com.oracle.bmc.jms.requests.DisableDrsRequest;
import com.oracle.bmc.jms.requests.EnableDrsRequest;
import com.oracle.bmc.jms.requests.GenerateAgentDeployScriptRequest;
import com.oracle.bmc.jms.requests.GenerateAgentInstallerConfigurationRequest;
import com.oracle.bmc.jms.requests.GenerateLoadPipelineScriptRequest;
import com.oracle.bmc.jms.requests.GetCryptoAnalysisResultRequest;
import com.oracle.bmc.jms.requests.GetDrsFileRequest;
import com.oracle.bmc.jms.requests.GetExportSettingRequest;
import com.oracle.bmc.jms.requests.GetExportStatusRequest;
import com.oracle.bmc.jms.requests.GetFleetAdvancedFeatureConfigurationRequest;
import com.oracle.bmc.jms.requests.GetFleetAgentConfigurationRequest;
import com.oracle.bmc.jms.requests.GetFleetRequest;
import com.oracle.bmc.jms.requests.GetJavaFamilyRequest;
import com.oracle.bmc.jms.requests.GetJavaMigrationAnalysisResultRequest;
import com.oracle.bmc.jms.requests.GetJavaReleaseRequest;
import com.oracle.bmc.jms.requests.GetJmsPluginRequest;
import com.oracle.bmc.jms.requests.GetPerformanceTuningAnalysisResultRequest;
import com.oracle.bmc.jms.requests.GetWorkRequestRequest;
import com.oracle.bmc.jms.requests.ListAgentInstallersRequest;
import com.oracle.bmc.jms.requests.ListAnnouncementsRequest;
import com.oracle.bmc.jms.requests.ListBlocklistsRequest;
import com.oracle.bmc.jms.requests.ListCryptoAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListDrsFilesRequest;
import com.oracle.bmc.jms.requests.ListFleetDiagnosesRequest;
import com.oracle.bmc.jms.requests.ListFleetsRequest;
import com.oracle.bmc.jms.requests.ListInstallationSitesRequest;
import com.oracle.bmc.jms.requests.ListJavaFamiliesRequest;
import com.oracle.bmc.jms.requests.ListJavaMigrationAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListJavaReleasesRequest;
import com.oracle.bmc.jms.requests.ListJmsPluginsRequest;
import com.oracle.bmc.jms.requests.ListJreUsageRequest;
import com.oracle.bmc.jms.requests.ListPerformanceTuningAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListWorkItemsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestsRequest;
import com.oracle.bmc.jms.requests.RemoveFleetInstallationSitesRequest;
import com.oracle.bmc.jms.requests.RequestCryptoAnalysesRequest;
import com.oracle.bmc.jms.requests.RequestDeployedApplicationMigrationAnalysesRequest;
import com.oracle.bmc.jms.requests.RequestJavaMigrationAnalysesRequest;
import com.oracle.bmc.jms.requests.RequestJfrRecordingsRequest;
import com.oracle.bmc.jms.requests.RequestPerformanceTuningAnalysesRequest;
import com.oracle.bmc.jms.requests.ScanJavaServerUsageRequest;
import com.oracle.bmc.jms.requests.ScanLibraryUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeApplicationInstallationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeApplicationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeDeployedApplicationInstallationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeDeployedApplicationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeInstallationUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJavaServerInstanceUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJavaServerUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeJreUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeLibraryUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeManagedInstanceUsageRequest;
import com.oracle.bmc.jms.requests.SummarizeResourceInventoryRequest;
import com.oracle.bmc.jms.requests.UpdateDrsFileRequest;
import com.oracle.bmc.jms.requests.UpdateExportSettingRequest;
import com.oracle.bmc.jms.requests.UpdateFleetAdvancedFeatureConfigurationRequest;
import com.oracle.bmc.jms.requests.UpdateFleetAgentConfigurationRequest;
import com.oracle.bmc.jms.requests.UpdateFleetRequest;
import com.oracle.bmc.jms.requests.UpdateJmsPluginRequest;
import com.oracle.bmc.jms.responses.AddFleetInstallationSitesResponse;
import com.oracle.bmc.jms.responses.CancelWorkRequestResponse;
import com.oracle.bmc.jms.responses.ChangeFleetCompartmentResponse;
import com.oracle.bmc.jms.responses.CreateBlocklistResponse;
import com.oracle.bmc.jms.responses.CreateDrsFileResponse;
import com.oracle.bmc.jms.responses.CreateFleetResponse;
import com.oracle.bmc.jms.responses.CreateJmsPluginResponse;
import com.oracle.bmc.jms.responses.DeleteBlocklistResponse;
import com.oracle.bmc.jms.responses.DeleteCryptoAnalysisResultResponse;
import com.oracle.bmc.jms.responses.DeleteDrsFileResponse;
import com.oracle.bmc.jms.responses.DeleteFleetResponse;
import com.oracle.bmc.jms.responses.DeleteJavaMigrationAnalysisResultResponse;
import com.oracle.bmc.jms.responses.DeleteJmsPluginResponse;
import com.oracle.bmc.jms.responses.DeletePerformanceTuningAnalysisResultResponse;
import com.oracle.bmc.jms.responses.DisableDrsResponse;
import com.oracle.bmc.jms.responses.EnableDrsResponse;
import com.oracle.bmc.jms.responses.GenerateAgentDeployScriptResponse;
import com.oracle.bmc.jms.responses.GenerateAgentInstallerConfigurationResponse;
import com.oracle.bmc.jms.responses.GenerateLoadPipelineScriptResponse;
import com.oracle.bmc.jms.responses.GetCryptoAnalysisResultResponse;
import com.oracle.bmc.jms.responses.GetDrsFileResponse;
import com.oracle.bmc.jms.responses.GetExportSettingResponse;
import com.oracle.bmc.jms.responses.GetExportStatusResponse;
import com.oracle.bmc.jms.responses.GetFleetAdvancedFeatureConfigurationResponse;
import com.oracle.bmc.jms.responses.GetFleetAgentConfigurationResponse;
import com.oracle.bmc.jms.responses.GetFleetResponse;
import com.oracle.bmc.jms.responses.GetJavaFamilyResponse;
import com.oracle.bmc.jms.responses.GetJavaMigrationAnalysisResultResponse;
import com.oracle.bmc.jms.responses.GetJavaReleaseResponse;
import com.oracle.bmc.jms.responses.GetJmsPluginResponse;
import com.oracle.bmc.jms.responses.GetPerformanceTuningAnalysisResultResponse;
import com.oracle.bmc.jms.responses.GetWorkRequestResponse;
import com.oracle.bmc.jms.responses.ListAgentInstallersResponse;
import com.oracle.bmc.jms.responses.ListAnnouncementsResponse;
import com.oracle.bmc.jms.responses.ListBlocklistsResponse;
import com.oracle.bmc.jms.responses.ListCryptoAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListDrsFilesResponse;
import com.oracle.bmc.jms.responses.ListFleetDiagnosesResponse;
import com.oracle.bmc.jms.responses.ListFleetsResponse;
import com.oracle.bmc.jms.responses.ListInstallationSitesResponse;
import com.oracle.bmc.jms.responses.ListJavaFamiliesResponse;
import com.oracle.bmc.jms.responses.ListJavaMigrationAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListJavaReleasesResponse;
import com.oracle.bmc.jms.responses.ListJmsPluginsResponse;
import com.oracle.bmc.jms.responses.ListJreUsageResponse;
import com.oracle.bmc.jms.responses.ListPerformanceTuningAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListWorkItemsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestsResponse;
import com.oracle.bmc.jms.responses.RemoveFleetInstallationSitesResponse;
import com.oracle.bmc.jms.responses.RequestCryptoAnalysesResponse;
import com.oracle.bmc.jms.responses.RequestDeployedApplicationMigrationAnalysesResponse;
import com.oracle.bmc.jms.responses.RequestJavaMigrationAnalysesResponse;
import com.oracle.bmc.jms.responses.RequestJfrRecordingsResponse;
import com.oracle.bmc.jms.responses.RequestPerformanceTuningAnalysesResponse;
import com.oracle.bmc.jms.responses.ScanJavaServerUsageResponse;
import com.oracle.bmc.jms.responses.ScanLibraryUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeApplicationInstallationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeApplicationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeDeployedApplicationInstallationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeDeployedApplicationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeInstallationUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJavaServerInstanceUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJavaServerUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeJreUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeLibraryUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeManagedInstanceUsageResponse;
import com.oracle.bmc.jms.responses.SummarizeResourceInventoryResponse;
import com.oracle.bmc.jms.responses.UpdateDrsFileResponse;
import com.oracle.bmc.jms.responses.UpdateExportSettingResponse;
import com.oracle.bmc.jms.responses.UpdateFleetAdvancedFeatureConfigurationResponse;
import com.oracle.bmc.jms.responses.UpdateFleetAgentConfigurationResponse;
import com.oracle.bmc.jms.responses.UpdateFleetResponse;
import com.oracle.bmc.jms.responses.UpdateJmsPluginResponse;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaManagementServiceClient
extends BaseSyncClient
implements JavaManagementService {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("JAVAMANAGEMENTSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://javamanagement.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(JavaManagementServiceClient.class);
    private final JavaManagementServiceWaiters waiters;
    private final JavaManagementServicePaginators paginators;

    JavaManagementServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    JavaManagementServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("JavaManagementService-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new JavaManagementServiceWaiters(executorService, this);
        this.paginators = new JavaManagementServicePaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"JavaManagementServiceClient", (String)"generateAgentDeployScript,generateAgentInstallerConfiguration,generateLoadPipelineScript"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public AddFleetInstallationSitesResponse addFleetInstallationSites(AddFleetInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAddFleetInstallationSitesDetails(), "addFleetInstallationSitesDetails is required");
        return (AddFleetInstallationSitesResponse)this.clientCall(request, AddFleetInstallationSitesResponse::builder).logger(LOG, "addFleetInstallationSites").serviceDetails("JavaManagementService", "AddFleetInstallationSites", "").method(Method.POST).requestBuilder(AddFleetInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("addInstallationSites").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", AddFleetInstallationSitesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", AddFleetInstallationSitesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("JavaManagementService", "CancelWorkRequest", "").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeFleetCompartmentResponse changeFleetCompartment(ChangeFleetCompartmentRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeFleetCompartmentDetails(), "changeFleetCompartmentDetails is required");
        return (ChangeFleetCompartmentResponse)this.clientCall(request, ChangeFleetCompartmentResponse::builder).logger(LOG, "changeFleetCompartment").serviceDetails("JavaManagementService", "ChangeFleetCompartment", "").method(Method.POST).requestBuilder(ChangeFleetCompartmentRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeFleetCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeFleetCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBlocklistResponse createBlocklist(CreateBlocklistRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateBlocklistDetails(), "createBlocklistDetails is required");
        return (CreateBlocklistResponse)this.clientCall(request, CreateBlocklistResponse::builder).logger(LOG, "createBlocklist").serviceDetails("JavaManagementService", "CreateBlocklist", "").method(Method.POST).requestBuilder(CreateBlocklistRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Blocklist.class, CreateBlocklistResponse.Builder::blocklist).handleResponseHeaderString("opc-request-id", CreateBlocklistResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateBlocklistResponse.Builder::etag).callSync();
    }

    @Override
    public CreateDrsFileResponse createDrsFile(CreateDrsFileRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateDrsFileDetails(), "createDrsFileDetails is required");
        return (CreateDrsFileResponse)this.clientCall(request, CreateDrsFileResponse::builder).logger(LOG, "createDrsFile").serviceDetails("JavaManagementService", "CreateDrsFile", "").method(Method.POST).requestBuilder(CreateDrsFileRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("drsFiles").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateDrsFileResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDrsFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateFleetResponse createFleet(CreateFleetRequest request) {
        Objects.requireNonNull(request.getCreateFleetDetails(), "createFleetDetails is required");
        return (CreateFleetResponse)this.clientCall(request, CreateFleetResponse::builder).logger(LOG, "createFleet").serviceDetails("JavaManagementService", "CreateFleet", "").method(Method.POST).requestBuilder(CreateFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", CreateFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateFleetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateJmsPluginResponse createJmsPlugin(CreateJmsPluginRequest request) {
        Objects.requireNonNull(request.getCreateJmsPluginDetails(), "createJmsPluginDetails is required");
        return (CreateJmsPluginResponse)this.clientCall(request, CreateJmsPluginResponse::builder).logger(LOG, "createJmsPlugin").serviceDetails("JavaManagementService", "CreateJmsPlugin", "").method(Method.POST).requestBuilder(CreateJmsPluginRequest::builder).basePath("/20210610").appendPathParam("jmsPlugins").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JmsPlugin.class, CreateJmsPluginResponse.Builder::jmsPlugin).handleResponseHeaderString("opc-request-id", CreateJmsPluginResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateJmsPluginResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteBlocklistResponse deleteBlocklist(DeleteBlocklistRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getBlocklistKey(), (String)"blocklistKey must not be blank", (Object[])new Object[0]);
        return (DeleteBlocklistResponse)this.clientCall(request, DeleteBlocklistResponse::builder).logger(LOG, "deleteBlocklist").serviceDetails("JavaManagementService", "DeleteBlocklist", "").method(Method.DELETE).requestBuilder(DeleteBlocklistRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").appendPathParam(request.getBlocklistKey()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteBlocklistResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteCryptoAnalysisResultResponse deleteCryptoAnalysisResult(DeleteCryptoAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCryptoAnalysisResultId(), (String)"cryptoAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (DeleteCryptoAnalysisResultResponse)this.clientCall(request, DeleteCryptoAnalysisResultResponse::builder).logger(LOG, "deleteCryptoAnalysisResult").serviceDetails("JavaManagementService", "DeleteCryptoAnalysisResult", "").method(Method.DELETE).requestBuilder(DeleteCryptoAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendPathParam(request.getCryptoAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteCryptoAnalysisResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteCryptoAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDrsFileResponse deleteDrsFile(DeleteDrsFileRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDrsFileKey(), (String)"drsFileKey must not be blank", (Object[])new Object[0]);
        return (DeleteDrsFileResponse)this.clientCall(request, DeleteDrsFileResponse::builder).logger(LOG, "deleteDrsFile").serviceDetails("JavaManagementService", "DeleteDrsFile", "").method(Method.DELETE).requestBuilder(DeleteDrsFileRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("drsFiles").appendPathParam(request.getDrsFileKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDrsFileResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDrsFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteFleetResponse deleteFleet(DeleteFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (DeleteFleetResponse)this.clientCall(request, DeleteFleetResponse::builder).logger(LOG, "deleteFleet").serviceDetails("JavaManagementService", "DeleteFleet", "").method(Method.DELETE).requestBuilder(DeleteFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteFleetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJavaMigrationAnalysisResultResponse deleteJavaMigrationAnalysisResult(DeleteJavaMigrationAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJavaMigrationAnalysisResultId(), (String)"javaMigrationAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (DeleteJavaMigrationAnalysisResultResponse)this.clientCall(request, DeleteJavaMigrationAnalysisResultResponse::builder).logger(LOG, "deleteJavaMigrationAnalysisResult").serviceDetails("JavaManagementService", "DeleteJavaMigrationAnalysisResult", "").method(Method.DELETE).requestBuilder(DeleteJavaMigrationAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("javaMigrationAnalysisResults").appendPathParam(request.getJavaMigrationAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteJavaMigrationAnalysisResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteJavaMigrationAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteJmsPluginResponse deleteJmsPlugin(DeleteJmsPluginRequest request) {
        Validate.notBlank((String)request.getJmsPluginId(), (String)"jmsPluginId must not be blank", (Object[])new Object[0]);
        return (DeleteJmsPluginResponse)this.clientCall(request, DeleteJmsPluginResponse::builder).logger(LOG, "deleteJmsPlugin").serviceDetails("JavaManagementService", "DeleteJmsPlugin", "").method(Method.DELETE).requestBuilder(DeleteJmsPluginRequest::builder).basePath("/20210610").appendPathParam("jmsPlugins").appendPathParam(request.getJmsPluginId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteJmsPluginResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePerformanceTuningAnalysisResultResponse deletePerformanceTuningAnalysisResult(DeletePerformanceTuningAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPerformanceTuningAnalysisResultId(), (String)"performanceTuningAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (DeletePerformanceTuningAnalysisResultResponse)this.clientCall(request, DeletePerformanceTuningAnalysisResultResponse::builder).logger(LOG, "deletePerformanceTuningAnalysisResult").serviceDetails("JavaManagementService", "DeletePerformanceTuningAnalysisResult", "").method(Method.DELETE).requestBuilder(DeletePerformanceTuningAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("performanceTuningAnalysisResults").appendPathParam(request.getPerformanceTuningAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeletePerformanceTuningAnalysisResultResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeletePerformanceTuningAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DisableDrsResponse disableDrs(DisableDrsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDisableDrsDetails(), "disableDrsDetails is required");
        return (DisableDrsResponse)this.clientCall(request, DisableDrsResponse::builder).logger(LOG, "disableDrs").serviceDetails("JavaManagementService", "DisableDrs", "").method(Method.POST).requestBuilder(DisableDrsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("disableDrs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", DisableDrsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DisableDrsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public EnableDrsResponse enableDrs(EnableDrsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getEnableDrsDetails(), "enableDrsDetails is required");
        return (EnableDrsResponse)this.clientCall(request, EnableDrsResponse::builder).logger(LOG, "enableDrs").serviceDetails("JavaManagementService", "EnableDrs", "").method(Method.POST).requestBuilder(EnableDrsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("enableDrs").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", EnableDrsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", EnableDrsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GenerateAgentDeployScriptResponse generateAgentDeployScript(GenerateAgentDeployScriptRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateAgentDeployScriptDetails(), "generateAgentDeployScriptDetails is required");
        return (GenerateAgentDeployScriptResponse)this.clientCall(request, GenerateAgentDeployScriptResponse::builder).logger(LOG, "generateAgentDeployScript").serviceDetails("JavaManagementService", "GenerateAgentDeployScript", "").method(Method.POST).requestBuilder(GenerateAgentDeployScriptRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("generateAgentDeployScript").accept(new String[]{"text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(InputStream.class, GenerateAgentDeployScriptResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GenerateAgentDeployScriptResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GenerateAgentDeployScriptResponse.Builder::contentLength).handleResponseHeaderString("content-type", GenerateAgentDeployScriptResponse.Builder::contentType).callSync();
    }

    @Override
    public GenerateAgentInstallerConfigurationResponse generateAgentInstallerConfiguration(GenerateAgentInstallerConfigurationRequest request) {
        Objects.requireNonNull(request.getGenerateAgentInstallerConfigurationDetails(), "generateAgentInstallerConfigurationDetails is required");
        return (GenerateAgentInstallerConfigurationResponse)this.clientCall(request, GenerateAgentInstallerConfigurationResponse::builder).logger(LOG, "generateAgentInstallerConfiguration").serviceDetails("JavaManagementService", "GenerateAgentInstallerConfiguration", "").method(Method.POST).requestBuilder(GenerateAgentInstallerConfigurationRequest::builder).basePath("/20210610").appendPathParam("agentInstallers").appendPathParam("actions").appendPathParam("generateAgentInstallerConfiguration").accept(new String[]{"text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(InputStream.class, GenerateAgentInstallerConfigurationResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GenerateAgentInstallerConfigurationResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GenerateAgentInstallerConfigurationResponse.Builder::contentLength).handleResponseHeaderString("content-type", GenerateAgentInstallerConfigurationResponse.Builder::contentType).callSync();
    }

    @Override
    public GenerateLoadPipelineScriptResponse generateLoadPipelineScript(GenerateLoadPipelineScriptRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getGenerateLoadPipelineScriptDetails(), "generateLoadPipelineScriptDetails is required");
        return (GenerateLoadPipelineScriptResponse)this.clientCall(request, GenerateLoadPipelineScriptResponse::builder).logger(LOG, "generateLoadPipelineScript").serviceDetails("JavaManagementService", "GenerateLoadPipelineScript", "").method(Method.POST).requestBuilder(GenerateLoadPipelineScriptRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("generateLoadPipelineScript").accept(new String[]{"text/plain"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(InputStream.class, GenerateLoadPipelineScriptResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GenerateLoadPipelineScriptResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GenerateLoadPipelineScriptResponse.Builder::contentLength).handleResponseHeaderString("content-type", GenerateLoadPipelineScriptResponse.Builder::contentType).callSync();
    }

    @Override
    public GetCryptoAnalysisResultResponse getCryptoAnalysisResult(GetCryptoAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCryptoAnalysisResultId(), (String)"cryptoAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (GetCryptoAnalysisResultResponse)this.clientCall(request, GetCryptoAnalysisResultResponse::builder).logger(LOG, "getCryptoAnalysisResult").serviceDetails("JavaManagementService", "GetCryptoAnalysisResult", "").method(Method.GET).requestBuilder(GetCryptoAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendPathParam(request.getCryptoAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CryptoAnalysisResult.class, GetCryptoAnalysisResultResponse.Builder::cryptoAnalysisResult).handleResponseHeaderString("etag", GetCryptoAnalysisResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCryptoAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDrsFileResponse getDrsFile(GetDrsFileRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getDrsFileKey(), (String)"drsFileKey must not be blank", (Object[])new Object[0]);
        return (GetDrsFileResponse)this.clientCall(request, GetDrsFileResponse::builder).logger(LOG, "getDrsFile").serviceDetails("JavaManagementService", "GetDrsFile", "").method(Method.GET).requestBuilder(GetDrsFileRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("drsFiles").appendPathParam(request.getDrsFileKey()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrsFile.class, GetDrsFileResponse.Builder::drsFile).handleResponseHeaderString("etag", GetDrsFileResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDrsFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetExportSettingResponse getExportSetting(GetExportSettingRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetExportSettingResponse)this.clientCall(request, GetExportSettingResponse::builder).logger(LOG, "getExportSetting").serviceDetails("JavaManagementService", "GetExportSetting", "").method(Method.GET).requestBuilder(GetExportSettingRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("exportSetting").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ExportSetting.class, GetExportSettingResponse.Builder::exportSetting).handleResponseHeaderString("etag", GetExportSettingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExportSettingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetExportStatusResponse getExportStatus(GetExportStatusRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetExportStatusResponse)this.clientCall(request, GetExportStatusResponse::builder).logger(LOG, "getExportStatus").serviceDetails("JavaManagementService", "GetExportStatus", "").method(Method.GET).requestBuilder(GetExportStatusRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("exportStatus").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ExportStatus.class, GetExportStatusResponse.Builder::exportStatus).handleResponseHeaderString("etag", GetExportStatusResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetExportStatusResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFleetResponse getFleet(GetFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetResponse)this.clientCall(request, GetFleetResponse::builder).logger(LOG, "getFleet").serviceDetails("JavaManagementService", "GetFleet", "").method(Method.GET).requestBuilder(GetFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Fleet.class, GetFleetResponse.Builder::fleet).handleResponseHeaderString("etag", GetFleetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFleetAdvancedFeatureConfigurationResponse getFleetAdvancedFeatureConfiguration(GetFleetAdvancedFeatureConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetAdvancedFeatureConfigurationResponse)this.clientCall(request, GetFleetAdvancedFeatureConfigurationResponse::builder).logger(LOG, "getFleetAdvancedFeatureConfiguration").serviceDetails("JavaManagementService", "GetFleetAdvancedFeatureConfiguration", "").method(Method.GET).requestBuilder(GetFleetAdvancedFeatureConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("advancedFeatureConfiguration").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FleetAdvancedFeatureConfiguration.class, GetFleetAdvancedFeatureConfigurationResponse.Builder::fleetAdvancedFeatureConfiguration).handleResponseHeaderString("opc-request-id", GetFleetAdvancedFeatureConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetFleetAdvancedFeatureConfigurationResponse.Builder::etag).callSync();
    }

    @Override
    public GetFleetAgentConfigurationResponse getFleetAgentConfiguration(GetFleetAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (GetFleetAgentConfigurationResponse)this.clientCall(request, GetFleetAgentConfigurationResponse::builder).logger(LOG, "getFleetAgentConfiguration").serviceDetails("JavaManagementService", "GetFleetAgentConfiguration", "").method(Method.GET).requestBuilder(GetFleetAgentConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("agentConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FleetAgentConfiguration.class, GetFleetAgentConfigurationResponse.Builder::fleetAgentConfiguration).handleResponseHeaderString("etag", GetFleetAgentConfigurationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFleetAgentConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaFamilyResponse getJavaFamily(GetJavaFamilyRequest request) {
        Validate.notBlank((String)request.getFamilyVersion(), (String)"familyVersion must not be blank", (Object[])new Object[0]);
        return (GetJavaFamilyResponse)this.clientCall(request, GetJavaFamilyResponse::builder).logger(LOG, "getJavaFamily").serviceDetails("JavaManagementService", "GetJavaFamily", "").method(Method.GET).requestBuilder(GetJavaFamilyRequest::builder).basePath("/20210610").appendPathParam("javaFamilies").appendPathParam(request.getFamilyVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaFamily.class, GetJavaFamilyResponse.Builder::javaFamily).handleResponseHeaderString("opc-request-id", GetJavaFamilyResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaMigrationAnalysisResultResponse getJavaMigrationAnalysisResult(GetJavaMigrationAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getJavaMigrationAnalysisResultId(), (String)"javaMigrationAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (GetJavaMigrationAnalysisResultResponse)this.clientCall(request, GetJavaMigrationAnalysisResultResponse::builder).logger(LOG, "getJavaMigrationAnalysisResult").serviceDetails("JavaManagementService", "GetJavaMigrationAnalysisResult", "").method(Method.GET).requestBuilder(GetJavaMigrationAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("javaMigrationAnalysisResults").appendPathParam(request.getJavaMigrationAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaMigrationAnalysisResult.class, GetJavaMigrationAnalysisResultResponse.Builder::javaMigrationAnalysisResult).handleResponseHeaderString("etag", GetJavaMigrationAnalysisResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetJavaMigrationAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJavaReleaseResponse getJavaRelease(GetJavaReleaseRequest request) {
        Validate.notBlank((String)request.getReleaseVersion(), (String)"releaseVersion must not be blank", (Object[])new Object[0]);
        return (GetJavaReleaseResponse)this.clientCall(request, GetJavaReleaseResponse::builder).logger(LOG, "getJavaRelease").serviceDetails("JavaManagementService", "GetJavaRelease", "").method(Method.GET).requestBuilder(GetJavaReleaseRequest::builder).basePath("/20210610").appendPathParam("javaReleases").appendPathParam(request.getReleaseVersion()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaRelease.class, GetJavaReleaseResponse.Builder::javaRelease).handleResponseHeaderString("opc-request-id", GetJavaReleaseResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetJmsPluginResponse getJmsPlugin(GetJmsPluginRequest request) {
        Validate.notBlank((String)request.getJmsPluginId(), (String)"jmsPluginId must not be blank", (Object[])new Object[0]);
        return (GetJmsPluginResponse)this.clientCall(request, GetJmsPluginResponse::builder).logger(LOG, "getJmsPlugin").serviceDetails("JavaManagementService", "GetJmsPlugin", "").method(Method.GET).requestBuilder(GetJmsPluginRequest::builder).basePath("/20210610").appendPathParam("jmsPlugins").appendPathParam(request.getJmsPluginId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JmsPlugin.class, GetJmsPluginResponse.Builder::jmsPlugin).handleResponseHeaderString("opc-request-id", GetJmsPluginResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetJmsPluginResponse.Builder::retryAfter).handleResponseHeaderString("etag", GetJmsPluginResponse.Builder::etag).callSync();
    }

    @Override
    public GetPerformanceTuningAnalysisResultResponse getPerformanceTuningAnalysisResult(GetPerformanceTuningAnalysisResultRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPerformanceTuningAnalysisResultId(), (String)"performanceTuningAnalysisResultId must not be blank", (Object[])new Object[0]);
        return (GetPerformanceTuningAnalysisResultResponse)this.clientCall(request, GetPerformanceTuningAnalysisResultResponse::builder).logger(LOG, "getPerformanceTuningAnalysisResult").serviceDetails("JavaManagementService", "GetPerformanceTuningAnalysisResult", "").method(Method.GET).requestBuilder(GetPerformanceTuningAnalysisResultRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("performanceTuningAnalysisResults").appendPathParam(request.getPerformanceTuningAnalysisResultId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PerformanceTuningAnalysisResult.class, GetPerformanceTuningAnalysisResultResponse.Builder::performanceTuningAnalysisResult).handleResponseHeaderString("etag", GetPerformanceTuningAnalysisResultResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPerformanceTuningAnalysisResultResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("JavaManagementService", "GetWorkRequest", "").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).callSync();
    }

    @Override
    public ListAgentInstallersResponse listAgentInstallers(ListAgentInstallersRequest request) {
        return (ListAgentInstallersResponse)this.clientCall(request, ListAgentInstallersResponse::builder).logger(LOG, "listAgentInstallers").serviceDetails("JavaManagementService", "ListAgentInstallers", "").method(Method.GET).requestBuilder(ListAgentInstallersRequest::builder).basePath("/20210610").appendPathParam("agentInstallers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendEnumQueryParam("platformArchitecture", (BmcEnum)request.getPlatformArchitecture()).appendEnumQueryParam("osFamily", (BmcEnum)request.getOsFamily()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AgentInstallerCollection.class, ListAgentInstallersResponse.Builder::agentInstallerCollection).handleResponseHeaderString("opc-request-id", ListAgentInstallersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAgentInstallersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListAnnouncementsResponse listAnnouncements(ListAnnouncementsRequest request) {
        return (ListAnnouncementsResponse)this.clientCall(request, ListAnnouncementsResponse::builder).logger(LOG, "listAnnouncements").serviceDetails("JavaManagementService", "ListAnnouncements", "").method(Method.GET).requestBuilder(ListAnnouncementsRequest::builder).basePath("/20210610").appendPathParam("announcements").appendQueryParam("summaryContains", (Object)request.getSummaryContains()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(AnnouncementCollection.class, ListAnnouncementsResponse.Builder::announcementCollection).handleResponseHeaderString("opc-request-id", ListAnnouncementsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnouncementsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBlocklistsResponse listBlocklists(ListBlocklistsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListBlocklistsResponse)this.clientCall(request, ListBlocklistsResponse::builder).logger(LOG, "listBlocklists").serviceDetails("JavaManagementService", "ListBlocklists", "").method(Method.GET).requestBuilder(ListBlocklistsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("blocklists").appendEnumQueryParam("operation", (BmcEnum)request.getOperation()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BlocklistCollection.class, ListBlocklistsResponse.Builder::blocklistCollection).handleResponseHeaderString("opc-request-id", ListBlocklistsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBlocklistsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListCryptoAnalysisResultsResponse listCryptoAnalysisResults(ListCryptoAnalysisResultsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListCryptoAnalysisResultsResponse)this.clientCall(request, ListCryptoAnalysisResultsResponse::builder).logger(LOG, "listCryptoAnalysisResults").serviceDetails("JavaManagementService", "ListCryptoAnalysisResults", "").method(Method.GET).requestBuilder(ListCryptoAnalysisResultsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("cryptoAnalysisResults").appendEnumQueryParam("aggregationMode", (BmcEnum)request.getAggregationMode()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("hostName", (Object)request.getHostName()).appendQueryParam("nonCompliantFindingCount", (Object)request.getNonCompliantFindingCount()).appendQueryParam("nonCompliantFindingCountGreaterThan", (Object)request.getNonCompliantFindingCountGreaterThan()).appendQueryParam("findingCount", (Object)request.getFindingCount()).appendQueryParam("findingCountGreaterThan", (Object)request.getFindingCountGreaterThan()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CryptoAnalysisResultCollection.class, ListCryptoAnalysisResultsResponse.Builder::cryptoAnalysisResultCollection).handleResponseHeaderString("opc-request-id", ListCryptoAnalysisResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCryptoAnalysisResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDrsFilesResponse listDrsFiles(ListDrsFilesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListDrsFilesResponse)this.clientCall(request, ListDrsFilesResponse::builder).logger(LOG, "listDrsFiles").serviceDetails("JavaManagementService", "ListDrsFiles", "").method(Method.GET).requestBuilder(ListDrsFilesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("drsFiles").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DrsFileCollection.class, ListDrsFilesResponse.Builder::drsFileCollection).handleResponseHeaderString("opc-request-id", ListDrsFilesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDrsFilesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFleetDiagnosesResponse listFleetDiagnoses(ListFleetDiagnosesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListFleetDiagnosesResponse)this.clientCall(request, ListFleetDiagnosesResponse::builder).logger(LOG, "listFleetDiagnoses").serviceDetails("JavaManagementService", "ListFleetDiagnoses", "").method(Method.GET).requestBuilder(ListFleetDiagnosesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("diagnoses").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FleetDiagnosisCollection.class, ListFleetDiagnosesResponse.Builder::fleetDiagnosisCollection).handleResponseHeaderString("opc-request-id", ListFleetDiagnosesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetDiagnosesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListFleetsResponse listFleets(ListFleetsRequest request) {
        return (ListFleetsResponse)this.clientCall(request, ListFleetsResponse::builder).logger(LOG, "listFleets").serviceDetails("JavaManagementService", "ListFleets", "").method(Method.GET).requestBuilder(ListFleetsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FleetCollection.class, ListFleetsResponse.Builder::fleetCollection).handleResponseHeaderString("opc-request-id", ListFleetsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListFleetsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListInstallationSitesResponse listInstallationSites(ListInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListInstallationSitesResponse)this.clientCall(request, ListInstallationSitesResponse::builder).logger(LOG, "listInstallationSites").serviceDetails("JavaManagementService", "ListInstallationSites", "").method(Method.GET).requestBuilder(ListInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("installationSites").appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).appendQueryParam("pathContains", (Object)request.getPathContains()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InstallationSiteCollection.class, ListInstallationSitesResponse.Builder::installationSiteCollection).handleResponseHeaderString("opc-request-id", ListInstallationSitesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListInstallationSitesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaFamiliesResponse listJavaFamilies(ListJavaFamiliesRequest request) {
        return (ListJavaFamiliesResponse)this.clientCall(request, ListJavaFamiliesResponse::builder).logger(LOG, "listJavaFamilies").serviceDetails("JavaManagementService", "ListJavaFamilies", "").method(Method.GET).requestBuilder(ListJavaFamiliesRequest::builder).basePath("/20210610").appendPathParam("javaFamilies").appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("isSupportedVersion", (Object)request.getIsSupportedVersion()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaFamilyCollection.class, ListJavaFamiliesResponse.Builder::javaFamilyCollection).handleResponseHeaderString("opc-request-id", ListJavaFamiliesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaFamiliesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaMigrationAnalysisResultsResponse listJavaMigrationAnalysisResults(ListJavaMigrationAnalysisResultsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListJavaMigrationAnalysisResultsResponse)this.clientCall(request, ListJavaMigrationAnalysisResultsResponse::builder).logger(LOG, "listJavaMigrationAnalysisResults").serviceDetails("JavaManagementService", "ListJavaMigrationAnalysisResults", "").method(Method.GET).requestBuilder(ListJavaMigrationAnalysisResultsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("javaMigrationAnalysisResults").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("hostName", (Object)request.getHostName()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaMigrationAnalysisResultCollection.class, ListJavaMigrationAnalysisResultsResponse.Builder::javaMigrationAnalysisResultCollection).handleResponseHeaderString("opc-request-id", ListJavaMigrationAnalysisResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaMigrationAnalysisResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJavaReleasesResponse listJavaReleases(ListJavaReleasesRequest request) {
        return (ListJavaReleasesResponse)this.clientCall(request, ListJavaReleasesResponse::builder).logger(LOG, "listJavaReleases").serviceDetails("JavaManagementService", "ListJavaReleases", "").method(Method.GET).requestBuilder(ListJavaReleasesRequest::builder).basePath("/20210610").appendPathParam("javaReleases").appendQueryParam("releaseVersion", (Object)request.getReleaseVersion()).appendQueryParam("familyVersion", (Object)request.getFamilyVersion()).appendEnumQueryParam("releaseType", (BmcEnum)request.getReleaseType()).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).appendEnumQueryParam("licenseType", (BmcEnum)request.getLicenseType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaReleaseCollection.class, ListJavaReleasesResponse.Builder::javaReleaseCollection).handleResponseHeaderString("opc-request-id", ListJavaReleasesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJavaReleasesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJmsPluginsResponse listJmsPlugins(ListJmsPluginsRequest request) {
        return (ListJmsPluginsResponse)this.clientCall(request, ListJmsPluginsResponse::builder).logger(LOG, "listJmsPlugins").serviceDetails("JavaManagementService", "ListJmsPlugins", "").method(Method.GET).requestBuilder(ListJmsPluginsRequest::builder).basePath("/20210610").appendPathParam("jmsPlugins").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("compartmentIdInSubtree", (Object)request.getCompartmentIdInSubtree()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendQueryParam("agentId", (Object)request.getAgentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("availabilityStatus", (BmcEnum)request.getAvailabilityStatus()).appendQueryParam("timeRegisteredLessThanOrEqualTo", (Object)request.getTimeRegisteredLessThanOrEqualTo()).appendQueryParam("timeLastSeenLessThanOrEqualTo", (Object)request.getTimeLastSeenLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("hostnameContains", (Object)request.getHostnameContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JmsPluginCollection.class, ListJmsPluginsResponse.Builder::jmsPluginCollection).handleResponseHeaderString("opc-request-id", ListJmsPluginsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJmsPluginsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListJreUsageResponse listJreUsage(ListJreUsageRequest request) {
        return (ListJreUsageResponse)this.clientCall(request, ListJreUsageResponse::builder).logger(LOG, "listJreUsage").serviceDetails("JavaManagementService", "ListJreUsage", "").method(Method.GET).requestBuilder(ListJreUsageRequest::builder).basePath("/20210610").appendPathParam("listJreUsage").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("hostId", (Object)request.getHostId()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JreUsageCollection.class, ListJreUsageResponse.Builder::jreUsageCollection).handleResponseHeaderString("opc-request-id", ListJreUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListJreUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPerformanceTuningAnalysisResultsResponse listPerformanceTuningAnalysisResults(ListPerformanceTuningAnalysisResultsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (ListPerformanceTuningAnalysisResultsResponse)this.clientCall(request, ListPerformanceTuningAnalysisResultsResponse::builder).logger(LOG, "listPerformanceTuningAnalysisResults").serviceDetails("JavaManagementService", "ListPerformanceTuningAnalysisResults", "").method(Method.GET).requestBuilder(ListPerformanceTuningAnalysisResultsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("performanceTuningAnalysisResults").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("hostName", (Object)request.getHostName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PerformanceTuningAnalysisResultCollection.class, ListPerformanceTuningAnalysisResultsResponse.Builder::performanceTuningAnalysisResultCollection).handleResponseHeaderString("opc-request-id", ListPerformanceTuningAnalysisResultsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPerformanceTuningAnalysisResultsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkItemsResponse listWorkItems(ListWorkItemsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkItemsResponse)this.clientCall(request, ListWorkItemsResponse::builder).logger(LOG, "listWorkItems").serviceDetails("JavaManagementService", "ListWorkItems", "").method(Method.GET).requestBuilder(ListWorkItemsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("workItems").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkItemCollection.class, ListWorkItemsResponse.Builder::workItemCollection).handleResponseHeaderString("opc-next-page", ListWorkItemsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkItemsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("JavaManagementService", "ListWorkRequestErrors", "").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("JavaManagementService", "ListWorkRequestLogs", "").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("JavaManagementService", "ListWorkRequests", "").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210610").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("fleetId", (Object)request.getFleetId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendEnumQueryParam("operationType", (BmcEnum)request.getOperationType()).appendListQueryParam("status", request.getStatus(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public RemoveFleetInstallationSitesResponse removeFleetInstallationSites(RemoveFleetInstallationSitesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRemoveFleetInstallationSitesDetails(), "removeFleetInstallationSitesDetails is required");
        return (RemoveFleetInstallationSitesResponse)this.clientCall(request, RemoveFleetInstallationSitesResponse::builder).logger(LOG, "removeFleetInstallationSites").serviceDetails("JavaManagementService", "RemoveFleetInstallationSites", "").method(Method.POST).requestBuilder(RemoveFleetInstallationSitesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("removeInstallationSites").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RemoveFleetInstallationSitesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RemoveFleetInstallationSitesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestCryptoAnalysesResponse requestCryptoAnalyses(RequestCryptoAnalysesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestCryptoAnalysesDetails(), "requestCryptoAnalysesDetails is required");
        return (RequestCryptoAnalysesResponse)this.clientCall(request, RequestCryptoAnalysesResponse::builder).logger(LOG, "requestCryptoAnalyses").serviceDetails("JavaManagementService", "RequestCryptoAnalyses", "").method(Method.POST).requestBuilder(RequestCryptoAnalysesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestCryptoAnalyses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RequestCryptoAnalysesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestCryptoAnalysesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestDeployedApplicationMigrationAnalysesResponse requestDeployedApplicationMigrationAnalyses(RequestDeployedApplicationMigrationAnalysesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestDeployedApplicationMigrationAnalysesDetails(), "requestDeployedApplicationMigrationAnalysesDetails is required");
        return (RequestDeployedApplicationMigrationAnalysesResponse)this.clientCall(request, RequestDeployedApplicationMigrationAnalysesResponse::builder).logger(LOG, "requestDeployedApplicationMigrationAnalyses").serviceDetails("JavaManagementService", "RequestDeployedApplicationMigrationAnalyses", "").method(Method.POST).requestBuilder(RequestDeployedApplicationMigrationAnalysesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestDeployedApplicationMigrationAnalyses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RequestDeployedApplicationMigrationAnalysesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestDeployedApplicationMigrationAnalysesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestJavaMigrationAnalysesResponse requestJavaMigrationAnalyses(RequestJavaMigrationAnalysesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestJavaMigrationAnalysesDetails(), "requestJavaMigrationAnalysesDetails is required");
        return (RequestJavaMigrationAnalysesResponse)this.clientCall(request, RequestJavaMigrationAnalysesResponse::builder).logger(LOG, "requestJavaMigrationAnalyses").serviceDetails("JavaManagementService", "RequestJavaMigrationAnalyses", "").method(Method.POST).requestBuilder(RequestJavaMigrationAnalysesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestJavaMigrationAnalyses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RequestJavaMigrationAnalysesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestJavaMigrationAnalysesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestJfrRecordingsResponse requestJfrRecordings(RequestJfrRecordingsRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestJfrRecordingsDetails(), "requestJfrRecordingsDetails is required");
        return (RequestJfrRecordingsResponse)this.clientCall(request, RequestJfrRecordingsResponse::builder).logger(LOG, "requestJfrRecordings").serviceDetails("JavaManagementService", "RequestJfrRecordings", "").method(Method.POST).requestBuilder(RequestJfrRecordingsRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestJfrRecordings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RequestJfrRecordingsResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestJfrRecordingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public RequestPerformanceTuningAnalysesResponse requestPerformanceTuningAnalyses(RequestPerformanceTuningAnalysesRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRequestPerformanceTuningAnalysesDetails(), "requestPerformanceTuningAnalysesDetails is required");
        return (RequestPerformanceTuningAnalysesResponse)this.clientCall(request, RequestPerformanceTuningAnalysesResponse::builder).logger(LOG, "requestPerformanceTuningAnalyses").serviceDetails("JavaManagementService", "RequestPerformanceTuningAnalyses", "").method(Method.POST).requestBuilder(RequestPerformanceTuningAnalysesRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("requestPerformanceTuningAnalyses").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", RequestPerformanceTuningAnalysesResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", RequestPerformanceTuningAnalysesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScanJavaServerUsageResponse scanJavaServerUsage(ScanJavaServerUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScanJavaServerUsageDetails(), "scanJavaServerUsageDetails is required");
        return (ScanJavaServerUsageResponse)this.clientCall(request, ScanJavaServerUsageResponse::builder).logger(LOG, "scanJavaServerUsage").serviceDetails("JavaManagementService", "ScanJavaServerUsage", "").method(Method.POST).requestBuilder(ScanJavaServerUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("scanJavaServerUsage").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ScanJavaServerUsageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScanJavaServerUsageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ScanLibraryUsageResponse scanLibraryUsage(ScanLibraryUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getScanLibraryUsageDetails(), "scanLibraryUsageDetails is required");
        return (ScanLibraryUsageResponse)this.clientCall(request, ScanLibraryUsageResponse::builder).logger(LOG, "scanLibraryUsage").serviceDetails("JavaManagementService", "ScanLibraryUsage", "").method(Method.POST).requestBuilder(ScanLibraryUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("scanLibraryUsage").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ScanLibraryUsageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScanLibraryUsageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SummarizeApplicationInstallationUsageResponse summarizeApplicationInstallationUsage(SummarizeApplicationInstallationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeApplicationInstallationUsageResponse)this.clientCall(request, SummarizeApplicationInstallationUsageResponse::builder).logger(LOG, "summarizeApplicationInstallationUsage").serviceDetails("JavaManagementService", "SummarizeApplicationInstallationUsage", "").method(Method.GET).requestBuilder(SummarizeApplicationInstallationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeApplicationInstallationUsage").appendQueryParam("applicationInstallationKey", (Object)request.getApplicationInstallationKey()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("applicationType", (Object)request.getApplicationType()).appendQueryParam("appInstallationPathContains", (Object)request.getAppInstallationPathContains()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApplicationInstallationUsageSummaryCollection.class, SummarizeApplicationInstallationUsageResponse.Builder::applicationInstallationUsageSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeApplicationInstallationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeApplicationInstallationUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeApplicationUsageResponse summarizeApplicationUsage(SummarizeApplicationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeApplicationUsageResponse)this.clientCall(request, SummarizeApplicationUsageResponse::builder).logger(LOG, "summarizeApplicationUsage").serviceDetails("JavaManagementService", "SummarizeApplicationUsage", "").method(Method.GET).requestBuilder(SummarizeApplicationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeApplicationUsage").appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("applicationType", (Object)request.getApplicationType()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("displayNameContains", (Object)request.getDisplayNameContains()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ApplicationUsageCollection.class, SummarizeApplicationUsageResponse.Builder::applicationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeApplicationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeApplicationUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeDeployedApplicationInstallationUsageResponse summarizeDeployedApplicationInstallationUsage(SummarizeDeployedApplicationInstallationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeDeployedApplicationInstallationUsageResponse)this.clientCall(request, SummarizeDeployedApplicationInstallationUsageResponse::builder).logger(LOG, "summarizeDeployedApplicationInstallationUsage").serviceDetails("JavaManagementService", "SummarizeDeployedApplicationInstallationUsage", "").method(Method.GET).requestBuilder(SummarizeDeployedApplicationInstallationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeDeployedApplicationInstallationUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationInstallationKey", (Object)request.getApplicationInstallationKey()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("applicationNameContains", (Object)request.getApplicationNameContains()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("applicationSourcePathContains", (Object)request.getApplicationSourcePathContains()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployedApplicationInstallationUsageSummaryCollection.class, SummarizeDeployedApplicationInstallationUsageResponse.Builder::deployedApplicationInstallationUsageSummaryCollection).handleResponseHeaderString("opc-request-id", SummarizeDeployedApplicationInstallationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeDeployedApplicationInstallationUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeDeployedApplicationUsageResponse summarizeDeployedApplicationUsage(SummarizeDeployedApplicationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeDeployedApplicationUsageResponse)this.clientCall(request, SummarizeDeployedApplicationUsageResponse::builder).logger(LOG, "summarizeDeployedApplicationUsage").serviceDetails("JavaManagementService", "SummarizeDeployedApplicationUsage", "").method(Method.GET).requestBuilder(SummarizeDeployedApplicationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeDeployedApplicationUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("applicationNameContains", (Object)request.getApplicationNameContains()).appendQueryParam("applicationName", (Object)request.getApplicationName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployedApplicationUsageCollection.class, SummarizeDeployedApplicationUsageResponse.Builder::deployedApplicationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeDeployedApplicationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeDeployedApplicationUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeInstallationUsageResponse summarizeInstallationUsage(SummarizeInstallationUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeInstallationUsageResponse)this.clientCall(request, SummarizeInstallationUsageResponse::builder).logger(LOG, "summarizeInstallationUsage").serviceDetails("JavaManagementService", "SummarizeInstallationUsage", "").method(Method.GET).requestBuilder(SummarizeInstallationUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeInstallationUsage").appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("pathContains", (Object)request.getPathContains()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InstallationUsageCollection.class, SummarizeInstallationUsageResponse.Builder::installationUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeInstallationUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeInstallationUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeJavaServerInstanceUsageResponse summarizeJavaServerInstanceUsage(SummarizeJavaServerInstanceUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJavaServerInstanceUsageResponse)this.clientCall(request, SummarizeJavaServerInstanceUsageResponse::builder).logger(LOG, "summarizeJavaServerInstanceUsage").serviceDetails("JavaManagementService", "SummarizeJavaServerInstanceUsage", "").method(Method.GET).requestBuilder(SummarizeJavaServerInstanceUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJavaServerInstanceUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("serverInstanceNameContains", (Object)request.getServerInstanceNameContains()).appendQueryParam("serverInstanceName", (Object)request.getServerInstanceName()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaServerInstanceUsageCollection.class, SummarizeJavaServerInstanceUsageResponse.Builder::javaServerInstanceUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJavaServerInstanceUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJavaServerInstanceUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeJavaServerUsageResponse summarizeJavaServerUsage(SummarizeJavaServerUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJavaServerUsageResponse)this.clientCall(request, SummarizeJavaServerUsageResponse::builder).logger(LOG, "summarizeJavaServerUsage").serviceDetails("JavaManagementService", "SummarizeJavaServerUsage", "").method(Method.GET).requestBuilder(SummarizeJavaServerUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJavaServerUsage").appendQueryParam("serverKey", (Object)request.getServerKey()).appendQueryParam("serverNameContains", (Object)request.getServerNameContains()).appendQueryParam("serverName", (Object)request.getServerName()).appendQueryParam("serverVersion", (Object)request.getServerVersion()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JavaServerUsageCollection.class, SummarizeJavaServerUsageResponse.Builder::javaServerUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJavaServerUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJavaServerUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeJreUsageResponse summarizeJreUsage(SummarizeJreUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeJreUsageResponse)this.clientCall(request, SummarizeJreUsageResponse::builder).logger(LOG, "summarizeJreUsage").serviceDetails("JavaManagementService", "SummarizeJreUsage", "").method(Method.GET).requestBuilder(SummarizeJreUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeJreUsage").appendQueryParam("jreId", (Object)request.getJreId()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendEnumQueryParam("jreSecurityStatus", (BmcEnum)request.getJreSecurityStatus()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(JreUsageCollection.class, SummarizeJreUsageResponse.Builder::jreUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeJreUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeJreUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeLibraryUsageResponse summarizeLibraryUsage(SummarizeLibraryUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeLibraryUsageResponse)this.clientCall(request, SummarizeLibraryUsageResponse::builder).logger(LOG, "summarizeLibraryUsage").serviceDetails("JavaManagementService", "SummarizeLibraryUsage", "").method(Method.GET).requestBuilder(SummarizeLibraryUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeLibraryUsage").appendQueryParam("serverInstanceKey", (Object)request.getServerInstanceKey()).appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendQueryParam("applicationKey", (Object)request.getApplicationKey()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).appendQueryParam("libraryNameContains", (Object)request.getLibraryNameContains()).appendQueryParam("libraryName", (Object)request.getLibraryName()).appendQueryParam("cvssScoreGreaterThan", (Object)request.getCvssScoreGreaterThan()).appendQueryParam("cvssScoreLessThan", (Object)request.getCvssScoreLessThan()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(LibraryUsageCollection.class, SummarizeLibraryUsageResponse.Builder::libraryUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeLibraryUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeLibraryUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeManagedInstanceUsageResponse summarizeManagedInstanceUsage(SummarizeManagedInstanceUsageRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        return (SummarizeManagedInstanceUsageResponse)this.clientCall(request, SummarizeManagedInstanceUsageResponse::builder).logger(LOG, "summarizeManagedInstanceUsage").serviceDetails("JavaManagementService", "SummarizeManagedInstanceUsage", "").method(Method.GET).requestBuilder(SummarizeManagedInstanceUsageRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("actions").appendPathParam("summarizeManagedInstanceUsage").appendQueryParam("managedInstanceId", (Object)request.getManagedInstanceId()).appendEnumQueryParam("managedInstanceType", (BmcEnum)request.getManagedInstanceType()).appendQueryParam("jreVendor", (Object)request.getJreVendor()).appendQueryParam("jreDistribution", (Object)request.getJreDistribution()).appendQueryParam("jreVersion", (Object)request.getJreVersion()).appendQueryParam("installationPath", (Object)request.getInstallationPath()).appendQueryParam("applicationId", (Object)request.getApplicationId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("osFamily", request.getOsFamily(), CollectionFormatType.Multi).appendQueryParam("hostnameContains", (Object)request.getHostnameContains()).appendQueryParam("libraryKey", (Object)request.getLibraryKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ManagedInstanceUsageCollection.class, SummarizeManagedInstanceUsageResponse.Builder::managedInstanceUsageCollection).handleResponseHeaderString("opc-request-id", SummarizeManagedInstanceUsageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeManagedInstanceUsageResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeResourceInventoryResponse summarizeResourceInventory(SummarizeResourceInventoryRequest request) {
        return (SummarizeResourceInventoryResponse)this.clientCall(request, SummarizeResourceInventoryResponse::builder).logger(LOG, "summarizeResourceInventory").serviceDetails("JavaManagementService", "SummarizeResourceInventory", "").method(Method.GET).requestBuilder(SummarizeResourceInventoryRequest::builder).basePath("/20210610").appendPathParam("summarizeResourceInventory").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("timeStart", (Object)request.getTimeStart()).appendQueryParam("timeEnd", (Object)request.getTimeEnd()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ResourceInventory.class, SummarizeResourceInventoryResponse.Builder::resourceInventory).handleResponseHeaderString("opc-request-id", SummarizeResourceInventoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDrsFileResponse updateDrsFile(UpdateDrsFileRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDrsFileDetails(), "updateDrsFileDetails is required");
        Validate.notBlank((String)request.getDrsFileKey(), (String)"drsFileKey must not be blank", (Object[])new Object[0]);
        return (UpdateDrsFileResponse)this.clientCall(request, UpdateDrsFileResponse::builder).logger(LOG, "updateDrsFile").serviceDetails("JavaManagementService", "UpdateDrsFile", "").method(Method.PUT).requestBuilder(UpdateDrsFileRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("drsFiles").appendPathParam(request.getDrsFileKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateDrsFileResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDrsFileResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateExportSettingResponse updateExportSetting(UpdateExportSettingRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateExportSettingDetails(), "updateExportSettingDetails is required");
        return (UpdateExportSettingResponse)this.clientCall(request, UpdateExportSettingResponse::builder).logger(LOG, "updateExportSetting").serviceDetails("JavaManagementService", "UpdateExportSetting", "").method(Method.PUT).requestBuilder(UpdateExportSettingRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("exportSetting").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ExportSetting.class, UpdateExportSettingResponse.Builder::exportSetting).handleResponseHeaderString("etag", UpdateExportSettingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateExportSettingResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFleetResponse updateFleet(UpdateFleetRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetDetails(), "updateFleetDetails is required");
        return (UpdateFleetResponse)this.clientCall(request, UpdateFleetResponse::builder).logger(LOG, "updateFleet").serviceDetails("JavaManagementService", "UpdateFleet", "").method(Method.PUT).requestBuilder(UpdateFleetRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateFleetAdvancedFeatureConfigurationResponse updateFleetAdvancedFeatureConfiguration(UpdateFleetAdvancedFeatureConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetAdvancedFeatureConfigurationDetails(), "updateFleetAdvancedFeatureConfigurationDetails is required");
        return (UpdateFleetAdvancedFeatureConfigurationResponse)this.clientCall(request, UpdateFleetAdvancedFeatureConfigurationResponse::builder).logger(LOG, "updateFleetAdvancedFeatureConfiguration").serviceDetails("JavaManagementService", "UpdateFleetAdvancedFeatureConfiguration", "").method(Method.PUT).requestBuilder(UpdateFleetAdvancedFeatureConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("advancedFeatureConfiguration").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(FleetAdvancedFeatureConfiguration.class, UpdateFleetAdvancedFeatureConfigurationResponse.Builder::fleetAdvancedFeatureConfiguration).handleResponseHeaderString("opc-request-id", UpdateFleetAdvancedFeatureConfigurationResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateFleetAdvancedFeatureConfigurationResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateFleetAgentConfigurationResponse updateFleetAgentConfiguration(UpdateFleetAgentConfigurationRequest request) {
        Validate.notBlank((String)request.getFleetId(), (String)"fleetId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateFleetAgentConfigurationDetails(), "updateFleetAgentConfigurationDetails is required");
        return (UpdateFleetAgentConfigurationResponse)this.clientCall(request, UpdateFleetAgentConfigurationResponse::builder).logger(LOG, "updateFleetAgentConfiguration").serviceDetails("JavaManagementService", "UpdateFleetAgentConfiguration", "").method(Method.PUT).requestBuilder(UpdateFleetAgentConfigurationRequest::builder).basePath("/20210610").appendPathParam("fleets").appendPathParam(request.getFleetId()).appendPathParam("agentConfiguration").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", UpdateFleetAgentConfigurationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateFleetAgentConfigurationResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateJmsPluginResponse updateJmsPlugin(UpdateJmsPluginRequest request) {
        Validate.notBlank((String)request.getJmsPluginId(), (String)"jmsPluginId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateJmsPluginDetails(), "updateJmsPluginDetails is required");
        return (UpdateJmsPluginResponse)this.clientCall(request, UpdateJmsPluginResponse::builder).logger(LOG, "updateJmsPlugin").serviceDetails("JavaManagementService", "UpdateJmsPlugin", "").method(Method.PUT).requestBuilder(UpdateJmsPluginRequest::builder).basePath("/20210610").appendPathParam("jmsPlugins").appendPathParam(request.getJmsPluginId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(JmsPlugin.class, UpdateJmsPluginResponse.Builder::jmsPlugin).handleResponseHeaderString("etag", UpdateJmsPluginResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateJmsPluginResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public JavaManagementServiceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public JavaManagementServicePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)JavaManagementServiceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(JavaManagementServiceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public JavaManagementServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)JavaManagementServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, JavaManagementServiceClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "jms";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"jms");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public JavaManagementServiceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new JavaManagementServiceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

