/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms;

import com.oracle.bmc.jms.JavaManagementService;
import com.oracle.bmc.jms.model.AgentInstallerSummary;
import com.oracle.bmc.jms.model.AnnouncementSummary;
import com.oracle.bmc.jms.model.Blocklist;
import com.oracle.bmc.jms.model.CryptoAnalysisResultSummary;
import com.oracle.bmc.jms.model.DrsFileSummary;
import com.oracle.bmc.jms.model.FleetDiagnosisSummary;
import com.oracle.bmc.jms.model.FleetSummary;
import com.oracle.bmc.jms.model.InstallationSiteSummary;
import com.oracle.bmc.jms.model.JavaFamilySummary;
import com.oracle.bmc.jms.model.JavaMigrationAnalysisResultSummary;
import com.oracle.bmc.jms.model.JavaReleaseSummary;
import com.oracle.bmc.jms.model.JmsPluginSummary;
import com.oracle.bmc.jms.model.JreUsage;
import com.oracle.bmc.jms.model.PerformanceTuningAnalysisResultSummary;
import com.oracle.bmc.jms.model.WorkItemSummary;
import com.oracle.bmc.jms.model.WorkRequest;
import com.oracle.bmc.jms.model.WorkRequestError;
import com.oracle.bmc.jms.model.WorkRequestLogEntry;
import com.oracle.bmc.jms.requests.ListAgentInstallersRequest;
import com.oracle.bmc.jms.requests.ListAnnouncementsRequest;
import com.oracle.bmc.jms.requests.ListBlocklistsRequest;
import com.oracle.bmc.jms.requests.ListCryptoAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListDrsFilesRequest;
import com.oracle.bmc.jms.requests.ListFleetDiagnosesRequest;
import com.oracle.bmc.jms.requests.ListFleetsRequest;
import com.oracle.bmc.jms.requests.ListInstallationSitesRequest;
import com.oracle.bmc.jms.requests.ListJavaFamiliesRequest;
import com.oracle.bmc.jms.requests.ListJavaMigrationAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListJavaReleasesRequest;
import com.oracle.bmc.jms.requests.ListJmsPluginsRequest;
import com.oracle.bmc.jms.requests.ListJreUsageRequest;
import com.oracle.bmc.jms.requests.ListPerformanceTuningAnalysisResultsRequest;
import com.oracle.bmc.jms.requests.ListWorkItemsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.jms.requests.ListWorkRequestsRequest;
import com.oracle.bmc.jms.responses.ListAgentInstallersResponse;
import com.oracle.bmc.jms.responses.ListAnnouncementsResponse;
import com.oracle.bmc.jms.responses.ListBlocklistsResponse;
import com.oracle.bmc.jms.responses.ListCryptoAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListDrsFilesResponse;
import com.oracle.bmc.jms.responses.ListFleetDiagnosesResponse;
import com.oracle.bmc.jms.responses.ListFleetsResponse;
import com.oracle.bmc.jms.responses.ListInstallationSitesResponse;
import com.oracle.bmc.jms.responses.ListJavaFamiliesResponse;
import com.oracle.bmc.jms.responses.ListJavaMigrationAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListJavaReleasesResponse;
import com.oracle.bmc.jms.responses.ListJmsPluginsResponse;
import com.oracle.bmc.jms.responses.ListJreUsageResponse;
import com.oracle.bmc.jms.responses.ListPerformanceTuningAnalysisResultsResponse;
import com.oracle.bmc.jms.responses.ListWorkItemsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.jms.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class JavaManagementServicePaginators {
    private final JavaManagementService client;

    public JavaManagementServicePaginators(JavaManagementService client) {
        this.client = client;
    }

    public Iterable<ListAgentInstallersResponse> listAgentInstallersResponseIterator(final ListAgentInstallersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAgentInstallersRequest.Builder>(){

            @Override
            public ListAgentInstallersRequest.Builder get() {
                return ListAgentInstallersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentInstallersResponse, String>(){

            @Override
            public String apply(ListAgentInstallersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentInstallersRequest.Builder>, ListAgentInstallersRequest>(){

            @Override
            public ListAgentInstallersRequest apply(RequestBuilderAndToken<ListAgentInstallersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentInstallersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentInstallersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentInstallersRequest, ListAgentInstallersResponse>(){

            @Override
            public ListAgentInstallersResponse apply(ListAgentInstallersRequest request) {
                return JavaManagementServicePaginators.this.client.listAgentInstallers(request);
            }
        });
    }

    public Iterable<AgentInstallerSummary> listAgentInstallersRecordIterator(final ListAgentInstallersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAgentInstallersRequest.Builder>(){

            @Override
            public ListAgentInstallersRequest.Builder get() {
                return ListAgentInstallersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAgentInstallersResponse, String>(){

            @Override
            public String apply(ListAgentInstallersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAgentInstallersRequest.Builder>, ListAgentInstallersRequest>(){

            @Override
            public ListAgentInstallersRequest apply(RequestBuilderAndToken<ListAgentInstallersRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAgentInstallersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAgentInstallersRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAgentInstallersRequest, ListAgentInstallersResponse>(){

            @Override
            public ListAgentInstallersResponse apply(ListAgentInstallersRequest request) {
                return JavaManagementServicePaginators.this.client.listAgentInstallers(request);
            }
        }, (Function)new Function<ListAgentInstallersResponse, List<AgentInstallerSummary>>(){

            @Override
            public List<AgentInstallerSummary> apply(ListAgentInstallersResponse response) {
                return response.getAgentInstallerCollection().getItems();
            }
        });
    }

    public Iterable<ListAnnouncementsResponse> listAnnouncementsResponseIterator(final ListAnnouncementsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnnouncementsRequest.Builder>(){

            @Override
            public ListAnnouncementsRequest.Builder get() {
                return ListAnnouncementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, String>(){

            @Override
            public String apply(ListAnnouncementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementsRequest.Builder>, ListAnnouncementsRequest>(){

            @Override
            public ListAnnouncementsRequest apply(RequestBuilderAndToken<ListAnnouncementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnouncementsRequest, ListAnnouncementsResponse>(){

            @Override
            public ListAnnouncementsResponse apply(ListAnnouncementsRequest request) {
                return JavaManagementServicePaginators.this.client.listAnnouncements(request);
            }
        });
    }

    public Iterable<AnnouncementSummary> listAnnouncementsRecordIterator(final ListAnnouncementsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnnouncementsRequest.Builder>(){

            @Override
            public ListAnnouncementsRequest.Builder get() {
                return ListAnnouncementsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, String>(){

            @Override
            public String apply(ListAnnouncementsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnouncementsRequest.Builder>, ListAnnouncementsRequest>(){

            @Override
            public ListAnnouncementsRequest apply(RequestBuilderAndToken<ListAnnouncementsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnouncementsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnouncementsRequest, ListAnnouncementsResponse>(){

            @Override
            public ListAnnouncementsResponse apply(ListAnnouncementsRequest request) {
                return JavaManagementServicePaginators.this.client.listAnnouncements(request);
            }
        }, (Function)new Function<ListAnnouncementsResponse, List<AnnouncementSummary>>(){

            @Override
            public List<AnnouncementSummary> apply(ListAnnouncementsResponse response) {
                return response.getAnnouncementCollection().getItems();
            }
        });
    }

    public Iterable<ListBlocklistsResponse> listBlocklistsResponseIterator(final ListBlocklistsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBlocklistsRequest.Builder>(){

            @Override
            public ListBlocklistsRequest.Builder get() {
                return ListBlocklistsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlocklistsResponse, String>(){

            @Override
            public String apply(ListBlocklistsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlocklistsRequest.Builder>, ListBlocklistsRequest>(){

            @Override
            public ListBlocklistsRequest apply(RequestBuilderAndToken<ListBlocklistsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlocklistsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlocklistsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlocklistsRequest, ListBlocklistsResponse>(){

            @Override
            public ListBlocklistsResponse apply(ListBlocklistsRequest request) {
                return JavaManagementServicePaginators.this.client.listBlocklists(request);
            }
        });
    }

    public Iterable<Blocklist> listBlocklistsRecordIterator(final ListBlocklistsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBlocklistsRequest.Builder>(){

            @Override
            public ListBlocklistsRequest.Builder get() {
                return ListBlocklistsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBlocklistsResponse, String>(){

            @Override
            public String apply(ListBlocklistsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBlocklistsRequest.Builder>, ListBlocklistsRequest>(){

            @Override
            public ListBlocklistsRequest apply(RequestBuilderAndToken<ListBlocklistsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListBlocklistsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBlocklistsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListBlocklistsRequest, ListBlocklistsResponse>(){

            @Override
            public ListBlocklistsResponse apply(ListBlocklistsRequest request) {
                return JavaManagementServicePaginators.this.client.listBlocklists(request);
            }
        }, (Function)new Function<ListBlocklistsResponse, List<Blocklist>>(){

            @Override
            public List<Blocklist> apply(ListBlocklistsResponse response) {
                return response.getBlocklistCollection().getItems();
            }
        });
    }

    public Iterable<ListCryptoAnalysisResultsResponse> listCryptoAnalysisResultsResponseIterator(final ListCryptoAnalysisResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCryptoAnalysisResultsRequest.Builder>(){

            @Override
            public ListCryptoAnalysisResultsRequest.Builder get() {
                return ListCryptoAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCryptoAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListCryptoAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCryptoAnalysisResultsRequest.Builder>, ListCryptoAnalysisResultsRequest>(){

            @Override
            public ListCryptoAnalysisResultsRequest apply(RequestBuilderAndToken<ListCryptoAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCryptoAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCryptoAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCryptoAnalysisResultsRequest, ListCryptoAnalysisResultsResponse>(){

            @Override
            public ListCryptoAnalysisResultsResponse apply(ListCryptoAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listCryptoAnalysisResults(request);
            }
        });
    }

    public Iterable<CryptoAnalysisResultSummary> listCryptoAnalysisResultsRecordIterator(final ListCryptoAnalysisResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCryptoAnalysisResultsRequest.Builder>(){

            @Override
            public ListCryptoAnalysisResultsRequest.Builder get() {
                return ListCryptoAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCryptoAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListCryptoAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCryptoAnalysisResultsRequest.Builder>, ListCryptoAnalysisResultsRequest>(){

            @Override
            public ListCryptoAnalysisResultsRequest apply(RequestBuilderAndToken<ListCryptoAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCryptoAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCryptoAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCryptoAnalysisResultsRequest, ListCryptoAnalysisResultsResponse>(){

            @Override
            public ListCryptoAnalysisResultsResponse apply(ListCryptoAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listCryptoAnalysisResults(request);
            }
        }, (Function)new Function<ListCryptoAnalysisResultsResponse, List<CryptoAnalysisResultSummary>>(){

            @Override
            public List<CryptoAnalysisResultSummary> apply(ListCryptoAnalysisResultsResponse response) {
                return response.getCryptoAnalysisResultCollection().getItems();
            }
        });
    }

    public Iterable<ListDrsFilesResponse> listDrsFilesResponseIterator(final ListDrsFilesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDrsFilesRequest.Builder>(){

            @Override
            public ListDrsFilesRequest.Builder get() {
                return ListDrsFilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrsFilesResponse, String>(){

            @Override
            public String apply(ListDrsFilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrsFilesRequest.Builder>, ListDrsFilesRequest>(){

            @Override
            public ListDrsFilesRequest apply(RequestBuilderAndToken<ListDrsFilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrsFilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrsFilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrsFilesRequest, ListDrsFilesResponse>(){

            @Override
            public ListDrsFilesResponse apply(ListDrsFilesRequest request) {
                return JavaManagementServicePaginators.this.client.listDrsFiles(request);
            }
        });
    }

    public Iterable<DrsFileSummary> listDrsFilesRecordIterator(final ListDrsFilesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDrsFilesRequest.Builder>(){

            @Override
            public ListDrsFilesRequest.Builder get() {
                return ListDrsFilesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDrsFilesResponse, String>(){

            @Override
            public String apply(ListDrsFilesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDrsFilesRequest.Builder>, ListDrsFilesRequest>(){

            @Override
            public ListDrsFilesRequest apply(RequestBuilderAndToken<ListDrsFilesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDrsFilesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDrsFilesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDrsFilesRequest, ListDrsFilesResponse>(){

            @Override
            public ListDrsFilesResponse apply(ListDrsFilesRequest request) {
                return JavaManagementServicePaginators.this.client.listDrsFiles(request);
            }
        }, (Function)new Function<ListDrsFilesResponse, List<DrsFileSummary>>(){

            @Override
            public List<DrsFileSummary> apply(ListDrsFilesResponse response) {
                return response.getDrsFileCollection().getItems();
            }
        });
    }

    public Iterable<ListFleetDiagnosesResponse> listFleetDiagnosesResponseIterator(final ListFleetDiagnosesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFleetDiagnosesRequest.Builder>(){

            @Override
            public ListFleetDiagnosesRequest.Builder get() {
                return ListFleetDiagnosesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFleetDiagnosesResponse, String>(){

            @Override
            public String apply(ListFleetDiagnosesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFleetDiagnosesRequest.Builder>, ListFleetDiagnosesRequest>(){

            @Override
            public ListFleetDiagnosesRequest apply(RequestBuilderAndToken<ListFleetDiagnosesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFleetDiagnosesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFleetDiagnosesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFleetDiagnosesRequest, ListFleetDiagnosesResponse>(){

            @Override
            public ListFleetDiagnosesResponse apply(ListFleetDiagnosesRequest request) {
                return JavaManagementServicePaginators.this.client.listFleetDiagnoses(request);
            }
        });
    }

    public Iterable<FleetDiagnosisSummary> listFleetDiagnosesRecordIterator(final ListFleetDiagnosesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFleetDiagnosesRequest.Builder>(){

            @Override
            public ListFleetDiagnosesRequest.Builder get() {
                return ListFleetDiagnosesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFleetDiagnosesResponse, String>(){

            @Override
            public String apply(ListFleetDiagnosesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFleetDiagnosesRequest.Builder>, ListFleetDiagnosesRequest>(){

            @Override
            public ListFleetDiagnosesRequest apply(RequestBuilderAndToken<ListFleetDiagnosesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFleetDiagnosesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFleetDiagnosesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFleetDiagnosesRequest, ListFleetDiagnosesResponse>(){

            @Override
            public ListFleetDiagnosesResponse apply(ListFleetDiagnosesRequest request) {
                return JavaManagementServicePaginators.this.client.listFleetDiagnoses(request);
            }
        }, (Function)new Function<ListFleetDiagnosesResponse, List<FleetDiagnosisSummary>>(){

            @Override
            public List<FleetDiagnosisSummary> apply(ListFleetDiagnosesResponse response) {
                return response.getFleetDiagnosisCollection().getItems();
            }
        });
    }

    public Iterable<ListFleetsResponse> listFleetsResponseIterator(final ListFleetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFleetsRequest.Builder>(){

            @Override
            public ListFleetsRequest.Builder get() {
                return ListFleetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFleetsResponse, String>(){

            @Override
            public String apply(ListFleetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFleetsRequest.Builder>, ListFleetsRequest>(){

            @Override
            public ListFleetsRequest apply(RequestBuilderAndToken<ListFleetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFleetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFleetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFleetsRequest, ListFleetsResponse>(){

            @Override
            public ListFleetsResponse apply(ListFleetsRequest request) {
                return JavaManagementServicePaginators.this.client.listFleets(request);
            }
        });
    }

    public Iterable<FleetSummary> listFleetsRecordIterator(final ListFleetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFleetsRequest.Builder>(){

            @Override
            public ListFleetsRequest.Builder get() {
                return ListFleetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFleetsResponse, String>(){

            @Override
            public String apply(ListFleetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFleetsRequest.Builder>, ListFleetsRequest>(){

            @Override
            public ListFleetsRequest apply(RequestBuilderAndToken<ListFleetsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListFleetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFleetsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListFleetsRequest, ListFleetsResponse>(){

            @Override
            public ListFleetsResponse apply(ListFleetsRequest request) {
                return JavaManagementServicePaginators.this.client.listFleets(request);
            }
        }, (Function)new Function<ListFleetsResponse, List<FleetSummary>>(){

            @Override
            public List<FleetSummary> apply(ListFleetsResponse response) {
                return response.getFleetCollection().getItems();
            }
        });
    }

    public Iterable<ListInstallationSitesResponse> listInstallationSitesResponseIterator(final ListInstallationSitesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListInstallationSitesRequest.Builder>(){

            @Override
            public ListInstallationSitesRequest.Builder get() {
                return ListInstallationSitesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstallationSitesResponse, String>(){

            @Override
            public String apply(ListInstallationSitesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstallationSitesRequest.Builder>, ListInstallationSitesRequest>(){

            @Override
            public ListInstallationSitesRequest apply(RequestBuilderAndToken<ListInstallationSitesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInstallationSitesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstallationSitesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInstallationSitesRequest, ListInstallationSitesResponse>(){

            @Override
            public ListInstallationSitesResponse apply(ListInstallationSitesRequest request) {
                return JavaManagementServicePaginators.this.client.listInstallationSites(request);
            }
        });
    }

    public Iterable<InstallationSiteSummary> listInstallationSitesRecordIterator(final ListInstallationSitesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListInstallationSitesRequest.Builder>(){

            @Override
            public ListInstallationSitesRequest.Builder get() {
                return ListInstallationSitesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListInstallationSitesResponse, String>(){

            @Override
            public String apply(ListInstallationSitesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListInstallationSitesRequest.Builder>, ListInstallationSitesRequest>(){

            @Override
            public ListInstallationSitesRequest apply(RequestBuilderAndToken<ListInstallationSitesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListInstallationSitesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListInstallationSitesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListInstallationSitesRequest, ListInstallationSitesResponse>(){

            @Override
            public ListInstallationSitesResponse apply(ListInstallationSitesRequest request) {
                return JavaManagementServicePaginators.this.client.listInstallationSites(request);
            }
        }, (Function)new Function<ListInstallationSitesResponse, List<InstallationSiteSummary>>(){

            @Override
            public List<InstallationSiteSummary> apply(ListInstallationSitesResponse response) {
                return response.getInstallationSiteCollection().getItems();
            }
        });
    }

    public Iterable<ListJavaFamiliesResponse> listJavaFamiliesResponseIterator(final ListJavaFamiliesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJavaFamiliesRequest.Builder>(){

            @Override
            public ListJavaFamiliesRequest.Builder get() {
                return ListJavaFamiliesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaFamiliesResponse, String>(){

            @Override
            public String apply(ListJavaFamiliesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaFamiliesRequest.Builder>, ListJavaFamiliesRequest>(){

            @Override
            public ListJavaFamiliesRequest apply(RequestBuilderAndToken<ListJavaFamiliesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaFamiliesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaFamiliesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaFamiliesRequest, ListJavaFamiliesResponse>(){

            @Override
            public ListJavaFamiliesResponse apply(ListJavaFamiliesRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaFamilies(request);
            }
        });
    }

    public Iterable<JavaFamilySummary> listJavaFamiliesRecordIterator(final ListJavaFamiliesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJavaFamiliesRequest.Builder>(){

            @Override
            public ListJavaFamiliesRequest.Builder get() {
                return ListJavaFamiliesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaFamiliesResponse, String>(){

            @Override
            public String apply(ListJavaFamiliesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaFamiliesRequest.Builder>, ListJavaFamiliesRequest>(){

            @Override
            public ListJavaFamiliesRequest apply(RequestBuilderAndToken<ListJavaFamiliesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaFamiliesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaFamiliesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaFamiliesRequest, ListJavaFamiliesResponse>(){

            @Override
            public ListJavaFamiliesResponse apply(ListJavaFamiliesRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaFamilies(request);
            }
        }, (Function)new Function<ListJavaFamiliesResponse, List<JavaFamilySummary>>(){

            @Override
            public List<JavaFamilySummary> apply(ListJavaFamiliesResponse response) {
                return response.getJavaFamilyCollection().getItems();
            }
        });
    }

    public Iterable<ListJavaMigrationAnalysisResultsResponse> listJavaMigrationAnalysisResultsResponseIterator(final ListJavaMigrationAnalysisResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJavaMigrationAnalysisResultsRequest.Builder>(){

            @Override
            public ListJavaMigrationAnalysisResultsRequest.Builder get() {
                return ListJavaMigrationAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaMigrationAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListJavaMigrationAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaMigrationAnalysisResultsRequest.Builder>, ListJavaMigrationAnalysisResultsRequest>(){

            @Override
            public ListJavaMigrationAnalysisResultsRequest apply(RequestBuilderAndToken<ListJavaMigrationAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaMigrationAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaMigrationAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaMigrationAnalysisResultsRequest, ListJavaMigrationAnalysisResultsResponse>(){

            @Override
            public ListJavaMigrationAnalysisResultsResponse apply(ListJavaMigrationAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaMigrationAnalysisResults(request);
            }
        });
    }

    public Iterable<JavaMigrationAnalysisResultSummary> listJavaMigrationAnalysisResultsRecordIterator(final ListJavaMigrationAnalysisResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJavaMigrationAnalysisResultsRequest.Builder>(){

            @Override
            public ListJavaMigrationAnalysisResultsRequest.Builder get() {
                return ListJavaMigrationAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaMigrationAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListJavaMigrationAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaMigrationAnalysisResultsRequest.Builder>, ListJavaMigrationAnalysisResultsRequest>(){

            @Override
            public ListJavaMigrationAnalysisResultsRequest apply(RequestBuilderAndToken<ListJavaMigrationAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaMigrationAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaMigrationAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaMigrationAnalysisResultsRequest, ListJavaMigrationAnalysisResultsResponse>(){

            @Override
            public ListJavaMigrationAnalysisResultsResponse apply(ListJavaMigrationAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaMigrationAnalysisResults(request);
            }
        }, (Function)new Function<ListJavaMigrationAnalysisResultsResponse, List<JavaMigrationAnalysisResultSummary>>(){

            @Override
            public List<JavaMigrationAnalysisResultSummary> apply(ListJavaMigrationAnalysisResultsResponse response) {
                return response.getJavaMigrationAnalysisResultCollection().getItems();
            }
        });
    }

    public Iterable<ListJavaReleasesResponse> listJavaReleasesResponseIterator(final ListJavaReleasesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJavaReleasesRequest.Builder>(){

            @Override
            public ListJavaReleasesRequest.Builder get() {
                return ListJavaReleasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaReleasesResponse, String>(){

            @Override
            public String apply(ListJavaReleasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaReleasesRequest.Builder>, ListJavaReleasesRequest>(){

            @Override
            public ListJavaReleasesRequest apply(RequestBuilderAndToken<ListJavaReleasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaReleasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaReleasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaReleasesRequest, ListJavaReleasesResponse>(){

            @Override
            public ListJavaReleasesResponse apply(ListJavaReleasesRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaReleases(request);
            }
        });
    }

    public Iterable<JavaReleaseSummary> listJavaReleasesRecordIterator(final ListJavaReleasesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJavaReleasesRequest.Builder>(){

            @Override
            public ListJavaReleasesRequest.Builder get() {
                return ListJavaReleasesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJavaReleasesResponse, String>(){

            @Override
            public String apply(ListJavaReleasesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJavaReleasesRequest.Builder>, ListJavaReleasesRequest>(){

            @Override
            public ListJavaReleasesRequest apply(RequestBuilderAndToken<ListJavaReleasesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJavaReleasesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJavaReleasesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJavaReleasesRequest, ListJavaReleasesResponse>(){

            @Override
            public ListJavaReleasesResponse apply(ListJavaReleasesRequest request) {
                return JavaManagementServicePaginators.this.client.listJavaReleases(request);
            }
        }, (Function)new Function<ListJavaReleasesResponse, List<JavaReleaseSummary>>(){

            @Override
            public List<JavaReleaseSummary> apply(ListJavaReleasesResponse response) {
                return response.getJavaReleaseCollection().getItems();
            }
        });
    }

    public Iterable<ListJmsPluginsResponse> listJmsPluginsResponseIterator(final ListJmsPluginsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJmsPluginsRequest.Builder>(){

            @Override
            public ListJmsPluginsRequest.Builder get() {
                return ListJmsPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJmsPluginsResponse, String>(){

            @Override
            public String apply(ListJmsPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJmsPluginsRequest.Builder>, ListJmsPluginsRequest>(){

            @Override
            public ListJmsPluginsRequest apply(RequestBuilderAndToken<ListJmsPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJmsPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJmsPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJmsPluginsRequest, ListJmsPluginsResponse>(){

            @Override
            public ListJmsPluginsResponse apply(ListJmsPluginsRequest request) {
                return JavaManagementServicePaginators.this.client.listJmsPlugins(request);
            }
        });
    }

    public Iterable<JmsPluginSummary> listJmsPluginsRecordIterator(final ListJmsPluginsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJmsPluginsRequest.Builder>(){

            @Override
            public ListJmsPluginsRequest.Builder get() {
                return ListJmsPluginsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJmsPluginsResponse, String>(){

            @Override
            public String apply(ListJmsPluginsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJmsPluginsRequest.Builder>, ListJmsPluginsRequest>(){

            @Override
            public ListJmsPluginsRequest apply(RequestBuilderAndToken<ListJmsPluginsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJmsPluginsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJmsPluginsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJmsPluginsRequest, ListJmsPluginsResponse>(){

            @Override
            public ListJmsPluginsResponse apply(ListJmsPluginsRequest request) {
                return JavaManagementServicePaginators.this.client.listJmsPlugins(request);
            }
        }, (Function)new Function<ListJmsPluginsResponse, List<JmsPluginSummary>>(){

            @Override
            public List<JmsPluginSummary> apply(ListJmsPluginsResponse response) {
                return response.getJmsPluginCollection().getItems();
            }
        });
    }

    public Iterable<ListJreUsageResponse> listJreUsageResponseIterator(final ListJreUsageRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListJreUsageRequest.Builder>(){

            @Override
            public ListJreUsageRequest.Builder get() {
                return ListJreUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJreUsageResponse, String>(){

            @Override
            public String apply(ListJreUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJreUsageRequest.Builder>, ListJreUsageRequest>(){

            @Override
            public ListJreUsageRequest apply(RequestBuilderAndToken<ListJreUsageRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJreUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJreUsageRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJreUsageRequest, ListJreUsageResponse>(){

            @Override
            public ListJreUsageResponse apply(ListJreUsageRequest request) {
                return JavaManagementServicePaginators.this.client.listJreUsage(request);
            }
        });
    }

    public Iterable<JreUsage> listJreUsageRecordIterator(final ListJreUsageRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListJreUsageRequest.Builder>(){

            @Override
            public ListJreUsageRequest.Builder get() {
                return ListJreUsageRequest.builder().copy(request);
            }
        }, (Function)new Function<ListJreUsageResponse, String>(){

            @Override
            public String apply(ListJreUsageResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListJreUsageRequest.Builder>, ListJreUsageRequest>(){

            @Override
            public ListJreUsageRequest apply(RequestBuilderAndToken<ListJreUsageRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListJreUsageRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListJreUsageRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListJreUsageRequest, ListJreUsageResponse>(){

            @Override
            public ListJreUsageResponse apply(ListJreUsageRequest request) {
                return JavaManagementServicePaginators.this.client.listJreUsage(request);
            }
        }, (Function)new Function<ListJreUsageResponse, List<JreUsage>>(){

            @Override
            public List<JreUsage> apply(ListJreUsageResponse response) {
                return response.getJreUsageCollection().getItems();
            }
        });
    }

    public Iterable<ListPerformanceTuningAnalysisResultsResponse> listPerformanceTuningAnalysisResultsResponseIterator(final ListPerformanceTuningAnalysisResultsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPerformanceTuningAnalysisResultsRequest.Builder>(){

            @Override
            public ListPerformanceTuningAnalysisResultsRequest.Builder get() {
                return ListPerformanceTuningAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPerformanceTuningAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListPerformanceTuningAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPerformanceTuningAnalysisResultsRequest.Builder>, ListPerformanceTuningAnalysisResultsRequest>(){

            @Override
            public ListPerformanceTuningAnalysisResultsRequest apply(RequestBuilderAndToken<ListPerformanceTuningAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPerformanceTuningAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPerformanceTuningAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPerformanceTuningAnalysisResultsRequest, ListPerformanceTuningAnalysisResultsResponse>(){

            @Override
            public ListPerformanceTuningAnalysisResultsResponse apply(ListPerformanceTuningAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listPerformanceTuningAnalysisResults(request);
            }
        });
    }

    public Iterable<PerformanceTuningAnalysisResultSummary> listPerformanceTuningAnalysisResultsRecordIterator(final ListPerformanceTuningAnalysisResultsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPerformanceTuningAnalysisResultsRequest.Builder>(){

            @Override
            public ListPerformanceTuningAnalysisResultsRequest.Builder get() {
                return ListPerformanceTuningAnalysisResultsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPerformanceTuningAnalysisResultsResponse, String>(){

            @Override
            public String apply(ListPerformanceTuningAnalysisResultsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPerformanceTuningAnalysisResultsRequest.Builder>, ListPerformanceTuningAnalysisResultsRequest>(){

            @Override
            public ListPerformanceTuningAnalysisResultsRequest apply(RequestBuilderAndToken<ListPerformanceTuningAnalysisResultsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListPerformanceTuningAnalysisResultsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPerformanceTuningAnalysisResultsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListPerformanceTuningAnalysisResultsRequest, ListPerformanceTuningAnalysisResultsResponse>(){

            @Override
            public ListPerformanceTuningAnalysisResultsResponse apply(ListPerformanceTuningAnalysisResultsRequest request) {
                return JavaManagementServicePaginators.this.client.listPerformanceTuningAnalysisResults(request);
            }
        }, (Function)new Function<ListPerformanceTuningAnalysisResultsResponse, List<PerformanceTuningAnalysisResultSummary>>(){

            @Override
            public List<PerformanceTuningAnalysisResultSummary> apply(ListPerformanceTuningAnalysisResultsResponse response) {
                return response.getPerformanceTuningAnalysisResultCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkItemsResponse> listWorkItemsResponseIterator(final ListWorkItemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkItemsRequest.Builder>(){

            @Override
            public ListWorkItemsRequest.Builder get() {
                return ListWorkItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkItemsResponse, String>(){

            @Override
            public String apply(ListWorkItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkItemsRequest.Builder>, ListWorkItemsRequest>(){

            @Override
            public ListWorkItemsRequest apply(RequestBuilderAndToken<ListWorkItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkItemsRequest, ListWorkItemsResponse>(){

            @Override
            public ListWorkItemsResponse apply(ListWorkItemsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkItems(request);
            }
        });
    }

    public Iterable<WorkItemSummary> listWorkItemsRecordIterator(final ListWorkItemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkItemsRequest.Builder>(){

            @Override
            public ListWorkItemsRequest.Builder get() {
                return ListWorkItemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkItemsResponse, String>(){

            @Override
            public String apply(ListWorkItemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkItemsRequest.Builder>, ListWorkItemsRequest>(){

            @Override
            public ListWorkItemsRequest apply(RequestBuilderAndToken<ListWorkItemsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkItemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkItemsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkItemsRequest, ListWorkItemsResponse>(){

            @Override
            public ListWorkItemsResponse apply(ListWorkItemsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkItems(request);
            }
        }, (Function)new Function<ListWorkItemsResponse, List<WorkItemSummary>>(){

            @Override
            public List<WorkItemSummary> apply(ListWorkItemsResponse response) {
                return response.getWorkItemCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return JavaManagementServicePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            @Override
            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }
}

