/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.OsFamily;
import com.oracle.bmc.jms.model.PackageType;
import com.oracle.bmc.jms.model.PlatformArchitectureType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AgentInstallerSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="agentInstallerId")
    private final Long agentInstallerId;
    @JsonProperty(value="agentInstallerDescription")
    private final String agentInstallerDescription;
    @JsonProperty(value="approximateFileSizeInBytes")
    private final Long approximateFileSizeInBytes;
    @JsonProperty(value="sha256")
    private final String sha256;
    @JsonProperty(value="osFamily")
    private final OsFamily osFamily;
    @JsonProperty(value="platformArchitecture")
    private final PlatformArchitectureType platformArchitecture;
    @JsonProperty(value="packageType")
    private final PackageType packageType;
    @JsonProperty(value="agentVersion")
    private final String agentVersion;
    @JsonProperty(value="javaVersion")
    private final String javaVersion;
    @JsonProperty(value="agentInstallerVersion")
    private final String agentInstallerVersion;

    @Deprecated
    @ConstructorProperties(value={"agentInstallerId", "agentInstallerDescription", "approximateFileSizeInBytes", "sha256", "osFamily", "platformArchitecture", "packageType", "agentVersion", "javaVersion", "agentInstallerVersion"})
    public AgentInstallerSummary(Long agentInstallerId, String agentInstallerDescription, Long approximateFileSizeInBytes, String sha256, OsFamily osFamily, PlatformArchitectureType platformArchitecture, PackageType packageType, String agentVersion, String javaVersion, String agentInstallerVersion) {
        this.agentInstallerId = agentInstallerId;
        this.agentInstallerDescription = agentInstallerDescription;
        this.approximateFileSizeInBytes = approximateFileSizeInBytes;
        this.sha256 = sha256;
        this.osFamily = osFamily;
        this.platformArchitecture = platformArchitecture;
        this.packageType = packageType;
        this.agentVersion = agentVersion;
        this.javaVersion = javaVersion;
        this.agentInstallerVersion = agentInstallerVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getAgentInstallerId() {
        return this.agentInstallerId;
    }

    public String getAgentInstallerDescription() {
        return this.agentInstallerDescription;
    }

    public Long getApproximateFileSizeInBytes() {
        return this.approximateFileSizeInBytes;
    }

    public String getSha256() {
        return this.sha256;
    }

    public OsFamily getOsFamily() {
        return this.osFamily;
    }

    public PlatformArchitectureType getPlatformArchitecture() {
        return this.platformArchitecture;
    }

    public PackageType getPackageType() {
        return this.packageType;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getAgentInstallerVersion() {
        return this.agentInstallerVersion;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AgentInstallerSummary(");
        sb.append("super=").append(super.toString());
        sb.append("agentInstallerId=").append(String.valueOf(this.agentInstallerId));
        sb.append(", agentInstallerDescription=").append(String.valueOf(this.agentInstallerDescription));
        sb.append(", approximateFileSizeInBytes=").append(String.valueOf(this.approximateFileSizeInBytes));
        sb.append(", sha256=").append(String.valueOf(this.sha256));
        sb.append(", osFamily=").append(String.valueOf((Object)this.osFamily));
        sb.append(", platformArchitecture=").append(String.valueOf((Object)this.platformArchitecture));
        sb.append(", packageType=").append(String.valueOf((Object)this.packageType));
        sb.append(", agentVersion=").append(String.valueOf(this.agentVersion));
        sb.append(", javaVersion=").append(String.valueOf(this.javaVersion));
        sb.append(", agentInstallerVersion=").append(String.valueOf(this.agentInstallerVersion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AgentInstallerSummary)) {
            return false;
        }
        AgentInstallerSummary other = (AgentInstallerSummary)((Object)o);
        return Objects.equals(this.agentInstallerId, other.agentInstallerId) && Objects.equals(this.agentInstallerDescription, other.agentInstallerDescription) && Objects.equals(this.approximateFileSizeInBytes, other.approximateFileSizeInBytes) && Objects.equals(this.sha256, other.sha256) && Objects.equals((Object)this.osFamily, (Object)other.osFamily) && Objects.equals((Object)this.platformArchitecture, (Object)other.platformArchitecture) && Objects.equals((Object)this.packageType, (Object)other.packageType) && Objects.equals(this.agentVersion, other.agentVersion) && Objects.equals(this.javaVersion, other.javaVersion) && Objects.equals(this.agentInstallerVersion, other.agentInstallerVersion) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.agentInstallerId == null ? 43 : this.agentInstallerId.hashCode());
        result = result * 59 + (this.agentInstallerDescription == null ? 43 : this.agentInstallerDescription.hashCode());
        result = result * 59 + (this.approximateFileSizeInBytes == null ? 43 : this.approximateFileSizeInBytes.hashCode());
        result = result * 59 + (this.sha256 == null ? 43 : this.sha256.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.platformArchitecture == null ? 43 : this.platformArchitecture.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.agentVersion == null ? 43 : this.agentVersion.hashCode());
        result = result * 59 + (this.javaVersion == null ? 43 : this.javaVersion.hashCode());
        result = result * 59 + (this.agentInstallerVersion == null ? 43 : this.agentInstallerVersion.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="agentInstallerId")
        private Long agentInstallerId;
        @JsonProperty(value="agentInstallerDescription")
        private String agentInstallerDescription;
        @JsonProperty(value="approximateFileSizeInBytes")
        private Long approximateFileSizeInBytes;
        @JsonProperty(value="sha256")
        private String sha256;
        @JsonProperty(value="osFamily")
        private OsFamily osFamily;
        @JsonProperty(value="platformArchitecture")
        private PlatformArchitectureType platformArchitecture;
        @JsonProperty(value="packageType")
        private PackageType packageType;
        @JsonProperty(value="agentVersion")
        private String agentVersion;
        @JsonProperty(value="javaVersion")
        private String javaVersion;
        @JsonProperty(value="agentInstallerVersion")
        private String agentInstallerVersion;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder agentInstallerId(Long agentInstallerId) {
            this.agentInstallerId = agentInstallerId;
            this.__explicitlySet__.add("agentInstallerId");
            return this;
        }

        public Builder agentInstallerDescription(String agentInstallerDescription) {
            this.agentInstallerDescription = agentInstallerDescription;
            this.__explicitlySet__.add("agentInstallerDescription");
            return this;
        }

        public Builder approximateFileSizeInBytes(Long approximateFileSizeInBytes) {
            this.approximateFileSizeInBytes = approximateFileSizeInBytes;
            this.__explicitlySet__.add("approximateFileSizeInBytes");
            return this;
        }

        public Builder sha256(String sha256) {
            this.sha256 = sha256;
            this.__explicitlySet__.add("sha256");
            return this;
        }

        public Builder osFamily(OsFamily osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder platformArchitecture(PlatformArchitectureType platformArchitecture) {
            this.platformArchitecture = platformArchitecture;
            this.__explicitlySet__.add("platformArchitecture");
            return this;
        }

        public Builder packageType(PackageType packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            this.__explicitlySet__.add("agentVersion");
            return this;
        }

        public Builder javaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            this.__explicitlySet__.add("javaVersion");
            return this;
        }

        public Builder agentInstallerVersion(String agentInstallerVersion) {
            this.agentInstallerVersion = agentInstallerVersion;
            this.__explicitlySet__.add("agentInstallerVersion");
            return this;
        }

        public AgentInstallerSummary build() {
            AgentInstallerSummary model = new AgentInstallerSummary(this.agentInstallerId, this.agentInstallerDescription, this.approximateFileSizeInBytes, this.sha256, this.osFamily, this.platformArchitecture, this.packageType, this.agentVersion, this.javaVersion, this.agentInstallerVersion);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AgentInstallerSummary model) {
            if (model.wasPropertyExplicitlySet("agentInstallerId")) {
                this.agentInstallerId(model.getAgentInstallerId());
            }
            if (model.wasPropertyExplicitlySet("agentInstallerDescription")) {
                this.agentInstallerDescription(model.getAgentInstallerDescription());
            }
            if (model.wasPropertyExplicitlySet("approximateFileSizeInBytes")) {
                this.approximateFileSizeInBytes(model.getApproximateFileSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("sha256")) {
                this.sha256(model.getSha256());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("platformArchitecture")) {
                this.platformArchitecture(model.getPlatformArchitecture());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("agentVersion")) {
                this.agentVersion(model.getAgentVersion());
            }
            if (model.wasPropertyExplicitlySet("javaVersion")) {
                this.javaVersion(model.getJavaVersion());
            }
            if (model.wasPropertyExplicitlySet("agentInstallerVersion")) {
                this.agentInstallerVersion(model.getAgentInstallerVersion());
            }
            return this;
        }
    }
}

