/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AnnouncementSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final Integer key;
    @JsonProperty(value="summary")
    private final String summary;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="timeReleased")
    private final Date timeReleased;

    @Deprecated
    @ConstructorProperties(value={"key", "summary", "url", "timeReleased"})
    public AnnouncementSummary(Integer key, String summary, String url, Date timeReleased) {
        this.key = key;
        this.summary = summary;
        this.url = url;
        this.timeReleased = timeReleased;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getKey() {
        return this.key;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getUrl() {
        return this.url;
    }

    public Date getTimeReleased() {
        return this.timeReleased;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AnnouncementSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", summary=").append(String.valueOf(this.summary));
        sb.append(", url=").append(String.valueOf(this.url));
        sb.append(", timeReleased=").append(String.valueOf(this.timeReleased));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnouncementSummary)) {
            return false;
        }
        AnnouncementSummary other = (AnnouncementSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.summary, other.summary) && Objects.equals(this.url, other.url) && Objects.equals(this.timeReleased, other.timeReleased) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.summary == null ? 43 : this.summary.hashCode());
        result = result * 59 + (this.url == null ? 43 : this.url.hashCode());
        result = result * 59 + (this.timeReleased == null ? 43 : this.timeReleased.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private Integer key;
        @JsonProperty(value="summary")
        private String summary;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="timeReleased")
        private Date timeReleased;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(Integer key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder summary(String summary) {
            this.summary = summary;
            this.__explicitlySet__.add("summary");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.__explicitlySet__.add("url");
            return this;
        }

        public Builder timeReleased(Date timeReleased) {
            this.timeReleased = timeReleased;
            this.__explicitlySet__.add("timeReleased");
            return this;
        }

        public AnnouncementSummary build() {
            AnnouncementSummary model = new AnnouncementSummary(this.key, this.summary, this.url, this.timeReleased);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AnnouncementSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("summary")) {
                this.summary(model.getSummary());
            }
            if (model.wasPropertyExplicitlySet("url")) {
                this.url(model.getUrl());
            }
            if (model.wasPropertyExplicitlySet("timeReleased")) {
                this.timeReleased(model.getTimeReleased());
            }
            return this;
        }
    }
}

