/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.jms.model.WorkItemDetails;
import com.oracle.bmc.jms.model.WorkItemType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class ApplicationWorkItemDetails
extends WorkItemDetails {
    @JsonProperty(value="applicationKey")
    private final String applicationKey;
    @JsonProperty(value="applicationInstallationKey")
    private final String applicationInstallationKey;
    @JsonProperty(value="applicationName")
    private final String applicationName;
    @JsonProperty(value="applicationInstallationPath")
    private final String applicationInstallationPath;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ApplicationWorkItemDetails(WorkItemType workItemType, String applicationKey, String applicationInstallationKey, String applicationName, String applicationInstallationPath) {
        super(workItemType);
        this.applicationKey = applicationKey;
        this.applicationInstallationKey = applicationInstallationKey;
        this.applicationName = applicationName;
        this.applicationInstallationPath = applicationInstallationPath;
    }

    public String getApplicationKey() {
        return this.applicationKey;
    }

    public String getApplicationInstallationKey() {
        return this.applicationInstallationKey;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationInstallationPath() {
        return this.applicationInstallationPath;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApplicationWorkItemDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", applicationKey=").append(String.valueOf(this.applicationKey));
        sb.append(", applicationInstallationKey=").append(String.valueOf(this.applicationInstallationKey));
        sb.append(", applicationName=").append(String.valueOf(this.applicationName));
        sb.append(", applicationInstallationPath=").append(String.valueOf(this.applicationInstallationPath));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationWorkItemDetails)) {
            return false;
        }
        ApplicationWorkItemDetails other = (ApplicationWorkItemDetails)((Object)o);
        return Objects.equals(this.applicationKey, other.applicationKey) && Objects.equals(this.applicationInstallationKey, other.applicationInstallationKey) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.applicationInstallationPath, other.applicationInstallationPath) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.applicationKey == null ? 43 : this.applicationKey.hashCode());
        result = result * 59 + (this.applicationInstallationKey == null ? 43 : this.applicationInstallationKey.hashCode());
        result = result * 59 + (this.applicationName == null ? 43 : this.applicationName.hashCode());
        result = result * 59 + (this.applicationInstallationPath == null ? 43 : this.applicationInstallationPath.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workItemType")
        private WorkItemType workItemType;
        @JsonProperty(value="applicationKey")
        private String applicationKey;
        @JsonProperty(value="applicationInstallationKey")
        private String applicationInstallationKey;
        @JsonProperty(value="applicationName")
        private String applicationName;
        @JsonProperty(value="applicationInstallationPath")
        private String applicationInstallationPath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workItemType(WorkItemType workItemType) {
            this.workItemType = workItemType;
            this.__explicitlySet__.add("workItemType");
            return this;
        }

        public Builder applicationKey(String applicationKey) {
            this.applicationKey = applicationKey;
            this.__explicitlySet__.add("applicationKey");
            return this;
        }

        public Builder applicationInstallationKey(String applicationInstallationKey) {
            this.applicationInstallationKey = applicationInstallationKey;
            this.__explicitlySet__.add("applicationInstallationKey");
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            this.__explicitlySet__.add("applicationName");
            return this;
        }

        public Builder applicationInstallationPath(String applicationInstallationPath) {
            this.applicationInstallationPath = applicationInstallationPath;
            this.__explicitlySet__.add("applicationInstallationPath");
            return this;
        }

        public ApplicationWorkItemDetails build() {
            ApplicationWorkItemDetails model = new ApplicationWorkItemDetails(this.workItemType, this.applicationKey, this.applicationInstallationKey, this.applicationName, this.applicationInstallationPath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApplicationWorkItemDetails model) {
            if (model.wasPropertyExplicitlySet("workItemType")) {
                this.workItemType(model.getWorkItemType());
            }
            if (model.wasPropertyExplicitlySet("applicationKey")) {
                this.applicationKey(model.getApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("applicationInstallationKey")) {
                this.applicationInstallationKey(model.getApplicationInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("applicationName")) {
                this.applicationName(model.getApplicationName());
            }
            if (model.wasPropertyExplicitlySet("applicationInstallationPath")) {
                this.applicationInstallationPath(model.getApplicationInstallationPath());
            }
            return this;
        }
    }
}

