/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.jms.model.WorkItemDetails;
import com.oracle.bmc.jms.model.WorkItemType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class DeployedApplicationWorkItemDetails
extends WorkItemDetails {
    @JsonProperty(value="deployedApplicationKey")
    private final String deployedApplicationKey;
    @JsonProperty(value="deployedApplicationInstallationKey")
    private final String deployedApplicationInstallationKey;
    @JsonProperty(value="deployedApplicationName")
    private final String deployedApplicationName;
    @JsonProperty(value="deployedApplicationInstallationPath")
    private final String deployedApplicationInstallationPath;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public DeployedApplicationWorkItemDetails(WorkItemType workItemType, String deployedApplicationKey, String deployedApplicationInstallationKey, String deployedApplicationName, String deployedApplicationInstallationPath) {
        super(workItemType);
        this.deployedApplicationKey = deployedApplicationKey;
        this.deployedApplicationInstallationKey = deployedApplicationInstallationKey;
        this.deployedApplicationName = deployedApplicationName;
        this.deployedApplicationInstallationPath = deployedApplicationInstallationPath;
    }

    public String getDeployedApplicationKey() {
        return this.deployedApplicationKey;
    }

    public String getDeployedApplicationInstallationKey() {
        return this.deployedApplicationInstallationKey;
    }

    public String getDeployedApplicationName() {
        return this.deployedApplicationName;
    }

    public String getDeployedApplicationInstallationPath() {
        return this.deployedApplicationInstallationPath;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployedApplicationWorkItemDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", deployedApplicationKey=").append(String.valueOf(this.deployedApplicationKey));
        sb.append(", deployedApplicationInstallationKey=").append(String.valueOf(this.deployedApplicationInstallationKey));
        sb.append(", deployedApplicationName=").append(String.valueOf(this.deployedApplicationName));
        sb.append(", deployedApplicationInstallationPath=").append(String.valueOf(this.deployedApplicationInstallationPath));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployedApplicationWorkItemDetails)) {
            return false;
        }
        DeployedApplicationWorkItemDetails other = (DeployedApplicationWorkItemDetails)((Object)o);
        return Objects.equals(this.deployedApplicationKey, other.deployedApplicationKey) && Objects.equals(this.deployedApplicationInstallationKey, other.deployedApplicationInstallationKey) && Objects.equals(this.deployedApplicationName, other.deployedApplicationName) && Objects.equals(this.deployedApplicationInstallationPath, other.deployedApplicationInstallationPath) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.deployedApplicationKey == null ? 43 : this.deployedApplicationKey.hashCode());
        result = result * 59 + (this.deployedApplicationInstallationKey == null ? 43 : this.deployedApplicationInstallationKey.hashCode());
        result = result * 59 + (this.deployedApplicationName == null ? 43 : this.deployedApplicationName.hashCode());
        result = result * 59 + (this.deployedApplicationInstallationPath == null ? 43 : this.deployedApplicationInstallationPath.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="workItemType")
        private WorkItemType workItemType;
        @JsonProperty(value="deployedApplicationKey")
        private String deployedApplicationKey;
        @JsonProperty(value="deployedApplicationInstallationKey")
        private String deployedApplicationInstallationKey;
        @JsonProperty(value="deployedApplicationName")
        private String deployedApplicationName;
        @JsonProperty(value="deployedApplicationInstallationPath")
        private String deployedApplicationInstallationPath;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder workItemType(WorkItemType workItemType) {
            this.workItemType = workItemType;
            this.__explicitlySet__.add("workItemType");
            return this;
        }

        public Builder deployedApplicationKey(String deployedApplicationKey) {
            this.deployedApplicationKey = deployedApplicationKey;
            this.__explicitlySet__.add("deployedApplicationKey");
            return this;
        }

        public Builder deployedApplicationInstallationKey(String deployedApplicationInstallationKey) {
            this.deployedApplicationInstallationKey = deployedApplicationInstallationKey;
            this.__explicitlySet__.add("deployedApplicationInstallationKey");
            return this;
        }

        public Builder deployedApplicationName(String deployedApplicationName) {
            this.deployedApplicationName = deployedApplicationName;
            this.__explicitlySet__.add("deployedApplicationName");
            return this;
        }

        public Builder deployedApplicationInstallationPath(String deployedApplicationInstallationPath) {
            this.deployedApplicationInstallationPath = deployedApplicationInstallationPath;
            this.__explicitlySet__.add("deployedApplicationInstallationPath");
            return this;
        }

        public DeployedApplicationWorkItemDetails build() {
            DeployedApplicationWorkItemDetails model = new DeployedApplicationWorkItemDetails(this.workItemType, this.deployedApplicationKey, this.deployedApplicationInstallationKey, this.deployedApplicationName, this.deployedApplicationInstallationPath);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeployedApplicationWorkItemDetails model) {
            if (model.wasPropertyExplicitlySet("workItemType")) {
                this.workItemType(model.getWorkItemType());
            }
            if (model.wasPropertyExplicitlySet("deployedApplicationKey")) {
                this.deployedApplicationKey(model.getDeployedApplicationKey());
            }
            if (model.wasPropertyExplicitlySet("deployedApplicationInstallationKey")) {
                this.deployedApplicationInstallationKey(model.getDeployedApplicationInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("deployedApplicationName")) {
                this.deployedApplicationName(model.getDeployedApplicationName());
            }
            if (model.wasPropertyExplicitlySet("deployedApplicationInstallationPath")) {
                this.deployedApplicationInstallationPath(model.getDeployedApplicationInstallationPath());
            }
            return this;
        }
    }
}

