/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ExportRunStatus;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="timeLastRun")
    private final Date timeLastRun;
    @JsonProperty(value="timeNextRun")
    private final Date timeNextRun;
    @JsonProperty(value="latestRunStatus")
    private final ExportRunStatus latestRunStatus;

    @Deprecated
    @ConstructorProperties(value={"fleetId", "timeLastRun", "timeNextRun", "latestRunStatus"})
    public ExportStatus(String fleetId, Date timeLastRun, Date timeNextRun, ExportRunStatus latestRunStatus) {
        this.fleetId = fleetId;
        this.timeLastRun = timeLastRun;
        this.timeNextRun = timeNextRun;
        this.latestRunStatus = latestRunStatus;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public Date getTimeLastRun() {
        return this.timeLastRun;
    }

    public Date getTimeNextRun() {
        return this.timeNextRun;
    }

    public ExportRunStatus getLatestRunStatus() {
        return this.latestRunStatus;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportStatus(");
        sb.append("super=").append(super.toString());
        sb.append("fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", timeLastRun=").append(String.valueOf(this.timeLastRun));
        sb.append(", timeNextRun=").append(String.valueOf(this.timeNextRun));
        sb.append(", latestRunStatus=").append(String.valueOf((Object)this.latestRunStatus));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportStatus)) {
            return false;
        }
        ExportStatus other = (ExportStatus)((Object)o);
        return Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.timeLastRun, other.timeLastRun) && Objects.equals(this.timeNextRun, other.timeNextRun) && Objects.equals((Object)this.latestRunStatus, (Object)other.latestRunStatus) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.timeLastRun == null ? 43 : this.timeLastRun.hashCode());
        result = result * 59 + (this.timeNextRun == null ? 43 : this.timeNextRun.hashCode());
        result = result * 59 + (this.latestRunStatus == null ? 43 : this.latestRunStatus.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="timeLastRun")
        private Date timeLastRun;
        @JsonProperty(value="timeNextRun")
        private Date timeNextRun;
        @JsonProperty(value="latestRunStatus")
        private ExportRunStatus latestRunStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder timeLastRun(Date timeLastRun) {
            this.timeLastRun = timeLastRun;
            this.__explicitlySet__.add("timeLastRun");
            return this;
        }

        public Builder timeNextRun(Date timeNextRun) {
            this.timeNextRun = timeNextRun;
            this.__explicitlySet__.add("timeNextRun");
            return this;
        }

        public Builder latestRunStatus(ExportRunStatus latestRunStatus) {
            this.latestRunStatus = latestRunStatus;
            this.__explicitlySet__.add("latestRunStatus");
            return this;
        }

        public ExportStatus build() {
            ExportStatus model = new ExportStatus(this.fleetId, this.timeLastRun, this.timeNextRun, this.latestRunStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportStatus model) {
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("timeLastRun")) {
                this.timeLastRun(model.getTimeLastRun());
            }
            if (model.wasPropertyExplicitlySet("timeNextRun")) {
                this.timeNextRun(model.getTimeNextRun());
            }
            if (model.wasPropertyExplicitlySet("latestRunStatus")) {
                this.latestRunStatus(model.getLatestRunStatus());
            }
            return this;
        }
    }
}

