/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class FleetDiagnosisSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceType")
    private final ResourceType resourceType;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="resourceState")
    private final ResourceState resourceState;
    @JsonProperty(value="resourceDiagnosis")
    private final String resourceDiagnosis;

    @Deprecated
    @ConstructorProperties(value={"resourceType", "resourceId", "resourceState", "resourceDiagnosis"})
    public FleetDiagnosisSummary(ResourceType resourceType, String resourceId, ResourceState resourceState, String resourceDiagnosis) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.resourceDiagnosis = resourceDiagnosis;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public ResourceState getResourceState() {
        return this.resourceState;
    }

    public String getResourceDiagnosis() {
        return this.resourceDiagnosis;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FleetDiagnosisSummary(");
        sb.append("super=").append(super.toString());
        sb.append("resourceType=").append(String.valueOf((Object)this.resourceType));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", resourceState=").append(String.valueOf((Object)this.resourceState));
        sb.append(", resourceDiagnosis=").append(String.valueOf(this.resourceDiagnosis));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FleetDiagnosisSummary)) {
            return false;
        }
        FleetDiagnosisSummary other = (FleetDiagnosisSummary)((Object)o);
        return Objects.equals((Object)this.resourceType, (Object)other.resourceType) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals((Object)this.resourceState, (Object)other.resourceState) && Objects.equals(this.resourceDiagnosis, other.resourceDiagnosis) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.resourceState == null ? 43 : this.resourceState.hashCode());
        result = result * 59 + (this.resourceDiagnosis == null ? 43 : this.resourceDiagnosis.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ResourceState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        NotFound("NOT_FOUND"),
        Other("OTHER"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceState> map;

        private ResourceState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceState.class);
            map = new HashMap<String, ResourceState>();
            for (ResourceState v : ResourceState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResourceType implements BmcEnum
    {
        InventoryLog("INVENTORY_LOG"),
        OperationLog("OPERATION_LOG"),
        CryptoSummarizedLog("CRYPTO_SUMMARIZED_LOG"),
        AnalysisOssBucket("ANALYSIS_OSS_BUCKET"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ResourceType> map;

        private ResourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ResourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ResourceType.class);
            map = new HashMap<String, ResourceType>();
            for (ResourceType v : ResourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private ResourceType resourceType;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="resourceState")
        private ResourceState resourceState;
        @JsonProperty(value="resourceDiagnosis")
        private String resourceDiagnosis;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder resourceState(ResourceState resourceState) {
            this.resourceState = resourceState;
            this.__explicitlySet__.add("resourceState");
            return this;
        }

        public Builder resourceDiagnosis(String resourceDiagnosis) {
            this.resourceDiagnosis = resourceDiagnosis;
            this.__explicitlySet__.add("resourceDiagnosis");
            return this;
        }

        public FleetDiagnosisSummary build() {
            FleetDiagnosisSummary model = new FleetDiagnosisSummary(this.resourceType, this.resourceId, this.resourceState, this.resourceDiagnosis);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FleetDiagnosisSummary model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("resourceState")) {
                this.resourceState(model.getResourceState());
            }
            if (model.wasPropertyExplicitlySet("resourceDiagnosis")) {
                this.resourceDiagnosis(model.getResourceDiagnosis());
            }
            return this;
        }
    }
}

