/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ArtifactContentType;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaArtifact
extends ExplicitlySetBmcModel {
    @JsonProperty(value="artifactId")
    private final Long artifactId;
    @JsonProperty(value="artifactDescription")
    private final String artifactDescription;
    @JsonProperty(value="artifactContentType")
    private final ArtifactContentType artifactContentType;
    @JsonProperty(value="approximateFileSizeInBytes")
    private final Long approximateFileSizeInBytes;
    @JsonProperty(value="sha256")
    private final String sha256;
    @JsonProperty(value="artifactFileName")
    private final String artifactFileName;
    @JsonProperty(value="osFamily")
    private final String osFamily;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="packageType")
    private final String packageType;
    @JsonProperty(value="packageTypeDetail")
    private final String packageTypeDetail;
    @JsonProperty(value="downloadUrl")
    private final String downloadUrl;
    @JsonProperty(value="scriptDownloadUrl")
    private final String scriptDownloadUrl;
    @JsonProperty(value="scriptChecksumUrl")
    private final String scriptChecksumUrl;

    @Deprecated
    @ConstructorProperties(value={"artifactId", "artifactDescription", "artifactContentType", "approximateFileSizeInBytes", "sha256", "artifactFileName", "osFamily", "architecture", "packageType", "packageTypeDetail", "downloadUrl", "scriptDownloadUrl", "scriptChecksumUrl"})
    public JavaArtifact(Long artifactId, String artifactDescription, ArtifactContentType artifactContentType, Long approximateFileSizeInBytes, String sha256, String artifactFileName, String osFamily, String architecture, String packageType, String packageTypeDetail, String downloadUrl, String scriptDownloadUrl, String scriptChecksumUrl) {
        this.artifactId = artifactId;
        this.artifactDescription = artifactDescription;
        this.artifactContentType = artifactContentType;
        this.approximateFileSizeInBytes = approximateFileSizeInBytes;
        this.sha256 = sha256;
        this.artifactFileName = artifactFileName;
        this.osFamily = osFamily;
        this.architecture = architecture;
        this.packageType = packageType;
        this.packageTypeDetail = packageTypeDetail;
        this.downloadUrl = downloadUrl;
        this.scriptDownloadUrl = scriptDownloadUrl;
        this.scriptChecksumUrl = scriptChecksumUrl;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactDescription() {
        return this.artifactDescription;
    }

    public ArtifactContentType getArtifactContentType() {
        return this.artifactContentType;
    }

    public Long getApproximateFileSizeInBytes() {
        return this.approximateFileSizeInBytes;
    }

    public String getSha256() {
        return this.sha256;
    }

    public String getArtifactFileName() {
        return this.artifactFileName;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getPackageType() {
        return this.packageType;
    }

    public String getPackageTypeDetail() {
        return this.packageTypeDetail;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public String getScriptDownloadUrl() {
        return this.scriptDownloadUrl;
    }

    public String getScriptChecksumUrl() {
        return this.scriptChecksumUrl;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaArtifact(");
        sb.append("super=").append(super.toString());
        sb.append("artifactId=").append(String.valueOf(this.artifactId));
        sb.append(", artifactDescription=").append(String.valueOf(this.artifactDescription));
        sb.append(", artifactContentType=").append(String.valueOf((Object)this.artifactContentType));
        sb.append(", approximateFileSizeInBytes=").append(String.valueOf(this.approximateFileSizeInBytes));
        sb.append(", sha256=").append(String.valueOf(this.sha256));
        sb.append(", artifactFileName=").append(String.valueOf(this.artifactFileName));
        sb.append(", osFamily=").append(String.valueOf(this.osFamily));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", packageType=").append(String.valueOf(this.packageType));
        sb.append(", packageTypeDetail=").append(String.valueOf(this.packageTypeDetail));
        sb.append(", downloadUrl=").append(String.valueOf(this.downloadUrl));
        sb.append(", scriptDownloadUrl=").append(String.valueOf(this.scriptDownloadUrl));
        sb.append(", scriptChecksumUrl=").append(String.valueOf(this.scriptChecksumUrl));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaArtifact)) {
            return false;
        }
        JavaArtifact other = (JavaArtifact)((Object)o);
        return Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.artifactDescription, other.artifactDescription) && Objects.equals((Object)this.artifactContentType, (Object)other.artifactContentType) && Objects.equals(this.approximateFileSizeInBytes, other.approximateFileSizeInBytes) && Objects.equals(this.sha256, other.sha256) && Objects.equals(this.artifactFileName, other.artifactFileName) && Objects.equals(this.osFamily, other.osFamily) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.packageType, other.packageType) && Objects.equals(this.packageTypeDetail, other.packageTypeDetail) && Objects.equals(this.downloadUrl, other.downloadUrl) && Objects.equals(this.scriptDownloadUrl, other.scriptDownloadUrl) && Objects.equals(this.scriptChecksumUrl, other.scriptChecksumUrl) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.artifactId == null ? 43 : this.artifactId.hashCode());
        result = result * 59 + (this.artifactDescription == null ? 43 : this.artifactDescription.hashCode());
        result = result * 59 + (this.artifactContentType == null ? 43 : this.artifactContentType.hashCode());
        result = result * 59 + (this.approximateFileSizeInBytes == null ? 43 : this.approximateFileSizeInBytes.hashCode());
        result = result * 59 + (this.sha256 == null ? 43 : this.sha256.hashCode());
        result = result * 59 + (this.artifactFileName == null ? 43 : this.artifactFileName.hashCode());
        result = result * 59 + (this.osFamily == null ? 43 : this.osFamily.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.packageType == null ? 43 : this.packageType.hashCode());
        result = result * 59 + (this.packageTypeDetail == null ? 43 : this.packageTypeDetail.hashCode());
        result = result * 59 + (this.downloadUrl == null ? 43 : this.downloadUrl.hashCode());
        result = result * 59 + (this.scriptDownloadUrl == null ? 43 : this.scriptDownloadUrl.hashCode());
        result = result * 59 + (this.scriptChecksumUrl == null ? 43 : this.scriptChecksumUrl.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="artifactId")
        private Long artifactId;
        @JsonProperty(value="artifactDescription")
        private String artifactDescription;
        @JsonProperty(value="artifactContentType")
        private ArtifactContentType artifactContentType;
        @JsonProperty(value="approximateFileSizeInBytes")
        private Long approximateFileSizeInBytes;
        @JsonProperty(value="sha256")
        private String sha256;
        @JsonProperty(value="artifactFileName")
        private String artifactFileName;
        @JsonProperty(value="osFamily")
        private String osFamily;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="packageType")
        private String packageType;
        @JsonProperty(value="packageTypeDetail")
        private String packageTypeDetail;
        @JsonProperty(value="downloadUrl")
        private String downloadUrl;
        @JsonProperty(value="scriptDownloadUrl")
        private String scriptDownloadUrl;
        @JsonProperty(value="scriptChecksumUrl")
        private String scriptChecksumUrl;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder artifactId(Long artifactId) {
            this.artifactId = artifactId;
            this.__explicitlySet__.add("artifactId");
            return this;
        }

        public Builder artifactDescription(String artifactDescription) {
            this.artifactDescription = artifactDescription;
            this.__explicitlySet__.add("artifactDescription");
            return this;
        }

        public Builder artifactContentType(ArtifactContentType artifactContentType) {
            this.artifactContentType = artifactContentType;
            this.__explicitlySet__.add("artifactContentType");
            return this;
        }

        public Builder approximateFileSizeInBytes(Long approximateFileSizeInBytes) {
            this.approximateFileSizeInBytes = approximateFileSizeInBytes;
            this.__explicitlySet__.add("approximateFileSizeInBytes");
            return this;
        }

        public Builder sha256(String sha256) {
            this.sha256 = sha256;
            this.__explicitlySet__.add("sha256");
            return this;
        }

        public Builder artifactFileName(String artifactFileName) {
            this.artifactFileName = artifactFileName;
            this.__explicitlySet__.add("artifactFileName");
            return this;
        }

        public Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            this.__explicitlySet__.add("osFamily");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder packageType(String packageType) {
            this.packageType = packageType;
            this.__explicitlySet__.add("packageType");
            return this;
        }

        public Builder packageTypeDetail(String packageTypeDetail) {
            this.packageTypeDetail = packageTypeDetail;
            this.__explicitlySet__.add("packageTypeDetail");
            return this;
        }

        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            this.__explicitlySet__.add("downloadUrl");
            return this;
        }

        public Builder scriptDownloadUrl(String scriptDownloadUrl) {
            this.scriptDownloadUrl = scriptDownloadUrl;
            this.__explicitlySet__.add("scriptDownloadUrl");
            return this;
        }

        public Builder scriptChecksumUrl(String scriptChecksumUrl) {
            this.scriptChecksumUrl = scriptChecksumUrl;
            this.__explicitlySet__.add("scriptChecksumUrl");
            return this;
        }

        public JavaArtifact build() {
            JavaArtifact model = new JavaArtifact(this.artifactId, this.artifactDescription, this.artifactContentType, this.approximateFileSizeInBytes, this.sha256, this.artifactFileName, this.osFamily, this.architecture, this.packageType, this.packageTypeDetail, this.downloadUrl, this.scriptDownloadUrl, this.scriptChecksumUrl);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaArtifact model) {
            if (model.wasPropertyExplicitlySet("artifactId")) {
                this.artifactId(model.getArtifactId());
            }
            if (model.wasPropertyExplicitlySet("artifactDescription")) {
                this.artifactDescription(model.getArtifactDescription());
            }
            if (model.wasPropertyExplicitlySet("artifactContentType")) {
                this.artifactContentType(model.getArtifactContentType());
            }
            if (model.wasPropertyExplicitlySet("approximateFileSizeInBytes")) {
                this.approximateFileSizeInBytes(model.getApproximateFileSizeInBytes());
            }
            if (model.wasPropertyExplicitlySet("sha256")) {
                this.sha256(model.getSha256());
            }
            if (model.wasPropertyExplicitlySet("artifactFileName")) {
                this.artifactFileName(model.getArtifactFileName());
            }
            if (model.wasPropertyExplicitlySet("osFamily")) {
                this.osFamily(model.getOsFamily());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("packageType")) {
                this.packageType(model.getPackageType());
            }
            if (model.wasPropertyExplicitlySet("packageTypeDetail")) {
                this.packageTypeDetail(model.getPackageTypeDetail());
            }
            if (model.wasPropertyExplicitlySet("downloadUrl")) {
                this.downloadUrl(model.getDownloadUrl());
            }
            if (model.wasPropertyExplicitlySet("scriptDownloadUrl")) {
                this.scriptDownloadUrl(model.getScriptDownloadUrl());
            }
            if (model.wasPropertyExplicitlySet("scriptChecksumUrl")) {
                this.scriptChecksumUrl(model.getScriptChecksumUrl());
            }
            return this;
        }
    }
}

