/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.OsFamily;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OperatingSystem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="family")
    private final OsFamily family;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="architecture")
    private final String architecture;
    @JsonProperty(value="managedInstanceCount")
    private final Integer managedInstanceCount;

    @Deprecated
    @ConstructorProperties(value={"family", "name", "version", "architecture", "managedInstanceCount"})
    public OperatingSystem(OsFamily family, String name, String version, String architecture, Integer managedInstanceCount) {
        this.family = family;
        this.name = name;
        this.version = version;
        this.architecture = architecture;
        this.managedInstanceCount = managedInstanceCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OsFamily getFamily() {
        return this.family;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public Integer getManagedInstanceCount() {
        return this.managedInstanceCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OperatingSystem(");
        sb.append("super=").append(super.toString());
        sb.append("family=").append(String.valueOf((Object)this.family));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", architecture=").append(String.valueOf(this.architecture));
        sb.append(", managedInstanceCount=").append(String.valueOf(this.managedInstanceCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)((Object)o);
        return Objects.equals((Object)this.family, (Object)other.family) && Objects.equals(this.name, other.name) && Objects.equals(this.version, other.version) && Objects.equals(this.architecture, other.architecture) && Objects.equals(this.managedInstanceCount, other.managedInstanceCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.family == null ? 43 : this.family.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.architecture == null ? 43 : this.architecture.hashCode());
        result = result * 59 + (this.managedInstanceCount == null ? 43 : this.managedInstanceCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="family")
        private OsFamily family;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="architecture")
        private String architecture;
        @JsonProperty(value="managedInstanceCount")
        private Integer managedInstanceCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder family(OsFamily family) {
            this.family = family;
            this.__explicitlySet__.add("family");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder architecture(String architecture) {
            this.architecture = architecture;
            this.__explicitlySet__.add("architecture");
            return this;
        }

        public Builder managedInstanceCount(Integer managedInstanceCount) {
            this.managedInstanceCount = managedInstanceCount;
            this.__explicitlySet__.add("managedInstanceCount");
            return this;
        }

        public OperatingSystem build() {
            OperatingSystem model = new OperatingSystem(this.family, this.name, this.version, this.architecture, this.managedInstanceCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OperatingSystem model) {
            if (model.wasPropertyExplicitlySet("family")) {
                this.family(model.getFamily());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("architecture")) {
                this.architecture(model.getArchitecture());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceCount")) {
                this.managedInstanceCount(model.getManagedInstanceCount());
            }
            return this;
        }
    }
}

