/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.CryptoAnalysisResultMode;
import com.oracle.bmc.jms.model.CryptoAnalysisResultSortBy;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListCryptoAnalysisResultsRequest
extends BmcRequest<Void> {
    private String fleetId;
    private CryptoAnalysisResultMode aggregationMode;
    private String managedInstanceId;
    private String hostName;
    private Integer nonCompliantFindingCount;
    private Integer nonCompliantFindingCountGreaterThan;
    private Integer findingCount;
    private Integer findingCountGreaterThan;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private CryptoAnalysisResultSortBy sortBy;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public CryptoAnalysisResultMode getAggregationMode() {
        return this.aggregationMode;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Integer getNonCompliantFindingCount() {
        return this.nonCompliantFindingCount;
    }

    public Integer getNonCompliantFindingCountGreaterThan() {
        return this.nonCompliantFindingCountGreaterThan;
    }

    public Integer getFindingCount() {
        return this.findingCount;
    }

    public Integer getFindingCountGreaterThan() {
        return this.findingCountGreaterThan;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public CryptoAnalysisResultSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).aggregationMode(this.aggregationMode).managedInstanceId(this.managedInstanceId).hostName(this.hostName).nonCompliantFindingCount(this.nonCompliantFindingCount).nonCompliantFindingCountGreaterThan(this.nonCompliantFindingCountGreaterThan).findingCount(this.findingCount).findingCountGreaterThan(this.findingCountGreaterThan).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",aggregationMode=").append(String.valueOf((Object)this.aggregationMode));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",hostName=").append(String.valueOf(this.hostName));
        sb.append(",nonCompliantFindingCount=").append(String.valueOf(this.nonCompliantFindingCount));
        sb.append(",nonCompliantFindingCountGreaterThan=").append(String.valueOf(this.nonCompliantFindingCountGreaterThan));
        sb.append(",findingCount=").append(String.valueOf(this.findingCount));
        sb.append(",findingCountGreaterThan=").append(String.valueOf(this.findingCountGreaterThan));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListCryptoAnalysisResultsRequest)) {
            return false;
        }
        ListCryptoAnalysisResultsRequest other = (ListCryptoAnalysisResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.aggregationMode, (Object)other.aggregationMode) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.nonCompliantFindingCount, other.nonCompliantFindingCount) && Objects.equals(this.nonCompliantFindingCountGreaterThan, other.nonCompliantFindingCountGreaterThan) && Objects.equals(this.findingCount, other.findingCount) && Objects.equals(this.findingCountGreaterThan, other.findingCountGreaterThan) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.aggregationMode == null ? 43 : this.aggregationMode.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.nonCompliantFindingCount == null ? 43 : this.nonCompliantFindingCount.hashCode());
        result = result * 59 + (this.nonCompliantFindingCountGreaterThan == null ? 43 : this.nonCompliantFindingCountGreaterThan.hashCode());
        result = result * 59 + (this.findingCount == null ? 43 : this.findingCount.hashCode());
        result = result * 59 + (this.findingCountGreaterThan == null ? 43 : this.findingCountGreaterThan.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListCryptoAnalysisResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private CryptoAnalysisResultMode aggregationMode = null;
        private String managedInstanceId = null;
        private String hostName = null;
        private Integer nonCompliantFindingCount = null;
        private Integer nonCompliantFindingCountGreaterThan = null;
        private Integer findingCount = null;
        private Integer findingCountGreaterThan = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private CryptoAnalysisResultSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder aggregationMode(CryptoAnalysisResultMode aggregationMode) {
            this.aggregationMode = aggregationMode;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder nonCompliantFindingCount(Integer nonCompliantFindingCount) {
            this.nonCompliantFindingCount = nonCompliantFindingCount;
            return this;
        }

        public Builder nonCompliantFindingCountGreaterThan(Integer nonCompliantFindingCountGreaterThan) {
            this.nonCompliantFindingCountGreaterThan = nonCompliantFindingCountGreaterThan;
            return this;
        }

        public Builder findingCount(Integer findingCount) {
            this.findingCount = findingCount;
            return this;
        }

        public Builder findingCountGreaterThan(Integer findingCountGreaterThan) {
            this.findingCountGreaterThan = findingCountGreaterThan;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(CryptoAnalysisResultSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListCryptoAnalysisResultsRequest o) {
            this.fleetId(o.getFleetId());
            this.aggregationMode(o.getAggregationMode());
            this.managedInstanceId(o.getManagedInstanceId());
            this.hostName(o.getHostName());
            this.nonCompliantFindingCount(o.getNonCompliantFindingCount());
            this.nonCompliantFindingCountGreaterThan(o.getNonCompliantFindingCountGreaterThan());
            this.findingCount(o.getFindingCount());
            this.findingCountGreaterThan(o.getFindingCountGreaterThan());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListCryptoAnalysisResultsRequest build() {
            ListCryptoAnalysisResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListCryptoAnalysisResultsRequest buildWithoutInvocationCallback() {
            ListCryptoAnalysisResultsRequest request = new ListCryptoAnalysisResultsRequest();
            request.fleetId = this.fleetId;
            request.aggregationMode = this.aggregationMode;
            request.managedInstanceId = this.managedInstanceId;
            request.hostName = this.hostName;
            request.nonCompliantFindingCount = this.nonCompliantFindingCount;
            request.nonCompliantFindingCountGreaterThan = this.nonCompliantFindingCountGreaterThan;
            request.findingCount = this.findingCount;
            request.findingCountGreaterThan = this.findingCountGreaterThan;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

