/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.JavaMigrationAnalysisResultSortBy;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListJavaMigrationAnalysisResultsRequest
extends BmcRequest<Void> {
    private String fleetId;
    private String managedInstanceId;
    private String hostName;
    private String applicationName;
    private Date timeStart;
    private Date timeEnd;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private JavaMigrationAnalysisResultSortBy sortBy;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public JavaMigrationAnalysisResultSortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).managedInstanceId(this.managedInstanceId).hostName(this.hostName).applicationName(this.applicationName).timeStart(this.timeStart).timeEnd(this.timeEnd).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(",hostName=").append(String.valueOf(this.hostName));
        sb.append(",applicationName=").append(String.valueOf(this.applicationName));
        sb.append(",timeStart=").append(String.valueOf(this.timeStart));
        sb.append(",timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJavaMigrationAnalysisResultsRequest)) {
            return false;
        }
        ListJavaMigrationAnalysisResultsRequest other = (ListJavaMigrationAnalysisResultsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.hostName, other.hostName) && Objects.equals(this.applicationName, other.applicationName) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.hostName == null ? 43 : this.hostName.hashCode());
        result = result * 59 + (this.applicationName == null ? 43 : this.applicationName.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJavaMigrationAnalysisResultsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private String managedInstanceId = null;
        private String hostName = null;
        private String applicationName = null;
        private Date timeStart = null;
        private Date timeEnd = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private JavaMigrationAnalysisResultSortBy sortBy = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            return this;
        }

        public Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(JavaMigrationAnalysisResultSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJavaMigrationAnalysisResultsRequest o) {
            this.fleetId(o.getFleetId());
            this.managedInstanceId(o.getManagedInstanceId());
            this.hostName(o.getHostName());
            this.applicationName(o.getApplicationName());
            this.timeStart(o.getTimeStart());
            this.timeEnd(o.getTimeEnd());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJavaMigrationAnalysisResultsRequest build() {
            ListJavaMigrationAnalysisResultsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJavaMigrationAnalysisResultsRequest buildWithoutInvocationCallback() {
            ListJavaMigrationAnalysisResultsRequest request = new ListJavaMigrationAnalysisResultsRequest();
            request.fleetId = this.fleetId;
            request.managedInstanceId = this.managedInstanceId;
            request.hostName = this.hostName;
            request.applicationName = this.applicationName;
            request.timeStart = this.timeStart;
            request.timeEnd = this.timeEnd;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

