/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.JmsPluginAvailabilityStatus;
import com.oracle.bmc.jms.model.JmsPluginLifecycleState;
import com.oracle.bmc.jms.model.JmsPluginSortBy;
import com.oracle.bmc.jms.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Date;
import java.util.Objects;

public class ListJmsPluginsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private String id;
    private String fleetId;
    private String agentId;
    private JmsPluginLifecycleState lifecycleState;
    private JmsPluginAvailabilityStatus availabilityStatus;
    private Date timeRegisteredLessThanOrEqualTo;
    private Date timeLastSeenLessThanOrEqualTo;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private JmsPluginSortBy sortBy;
    private String hostnameContains;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public String getId() {
        return this.id;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public JmsPluginLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public JmsPluginAvailabilityStatus getAvailabilityStatus() {
        return this.availabilityStatus;
    }

    public Date getTimeRegisteredLessThanOrEqualTo() {
        return this.timeRegisteredLessThanOrEqualTo;
    }

    public Date getTimeLastSeenLessThanOrEqualTo() {
        return this.timeLastSeenLessThanOrEqualTo;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public JmsPluginSortBy getSortBy() {
        return this.sortBy;
    }

    public String getHostnameContains() {
        return this.hostnameContains;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).id(this.id).fleetId(this.fleetId).agentId(this.agentId).lifecycleState(this.lifecycleState).availabilityStatus(this.availabilityStatus).timeRegisteredLessThanOrEqualTo(this.timeRegisteredLessThanOrEqualTo).timeLastSeenLessThanOrEqualTo(this.timeLastSeenLessThanOrEqualTo).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).hostnameContains(this.hostnameContains).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",id=").append(String.valueOf(this.id));
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",agentId=").append(String.valueOf(this.agentId));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",availabilityStatus=").append(String.valueOf((Object)this.availabilityStatus));
        sb.append(",timeRegisteredLessThanOrEqualTo=").append(String.valueOf(this.timeRegisteredLessThanOrEqualTo));
        sb.append(",timeLastSeenLessThanOrEqualTo=").append(String.valueOf(this.timeLastSeenLessThanOrEqualTo));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",hostnameContains=").append(String.valueOf(this.hostnameContains));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListJmsPluginsRequest)) {
            return false;
        }
        ListJmsPluginsRequest other = (ListJmsPluginsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals(this.id, other.id) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.agentId, other.agentId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.availabilityStatus, (Object)other.availabilityStatus) && Objects.equals(this.timeRegisteredLessThanOrEqualTo, other.timeRegisteredLessThanOrEqualTo) && Objects.equals(this.timeLastSeenLessThanOrEqualTo, other.timeLastSeenLessThanOrEqualTo) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.hostnameContains, other.hostnameContains) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.availabilityStatus == null ? 43 : this.availabilityStatus.hashCode());
        result = result * 59 + (this.timeRegisteredLessThanOrEqualTo == null ? 43 : this.timeRegisteredLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastSeenLessThanOrEqualTo == null ? 43 : this.timeLastSeenLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.hostnameContains == null ? 43 : this.hostnameContains.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJmsPluginsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private String id = null;
        private String fleetId = null;
        private String agentId = null;
        private JmsPluginLifecycleState lifecycleState = null;
        private JmsPluginAvailabilityStatus availabilityStatus = null;
        private Date timeRegisteredLessThanOrEqualTo = null;
        private Date timeLastSeenLessThanOrEqualTo = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private JmsPluginSortBy sortBy = null;
        private String hostnameContains = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public Builder lifecycleState(JmsPluginLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityStatus(JmsPluginAvailabilityStatus availabilityStatus) {
            this.availabilityStatus = availabilityStatus;
            return this;
        }

        public Builder timeRegisteredLessThanOrEqualTo(Date timeRegisteredLessThanOrEqualTo) {
            this.timeRegisteredLessThanOrEqualTo = timeRegisteredLessThanOrEqualTo;
            return this;
        }

        public Builder timeLastSeenLessThanOrEqualTo(Date timeLastSeenLessThanOrEqualTo) {
            this.timeLastSeenLessThanOrEqualTo = timeLastSeenLessThanOrEqualTo;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(JmsPluginSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder hostnameContains(String hostnameContains) {
            this.hostnameContains = hostnameContains;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJmsPluginsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.id(o.getId());
            this.fleetId(o.getFleetId());
            this.agentId(o.getAgentId());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityStatus(o.getAvailabilityStatus());
            this.timeRegisteredLessThanOrEqualTo(o.getTimeRegisteredLessThanOrEqualTo());
            this.timeLastSeenLessThanOrEqualTo(o.getTimeLastSeenLessThanOrEqualTo());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.hostnameContains(o.getHostnameContains());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJmsPluginsRequest build() {
            ListJmsPluginsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListJmsPluginsRequest buildWithoutInvocationCallback() {
            ListJmsPluginsRequest request = new ListJmsPluginsRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.id = this.id;
            request.fleetId = this.fleetId;
            request.agentId = this.agentId;
            request.lifecycleState = this.lifecycleState;
            request.availabilityStatus = this.availabilityStatus;
            request.timeRegisteredLessThanOrEqualTo = this.timeRegisteredLessThanOrEqualTo;
            request.timeLastSeenLessThanOrEqualTo = this.timeLastSeenLessThanOrEqualTo;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.hostnameContains = this.hostnameContains;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

