/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.jms.model.RequestJavaMigrationAnalysesDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class RequestJavaMigrationAnalysesRequest
extends BmcRequest<RequestJavaMigrationAnalysesDetails> {
    private String fleetId;
    private RequestJavaMigrationAnalysesDetails requestJavaMigrationAnalysesDetails;
    private String opcRequestId;

    public String getFleetId() {
        return this.fleetId;
    }

    public RequestJavaMigrationAnalysesDetails getRequestJavaMigrationAnalysesDetails() {
        return this.requestJavaMigrationAnalysesDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public RequestJavaMigrationAnalysesDetails getBody$() {
        return this.requestJavaMigrationAnalysesDetails;
    }

    public Builder toBuilder() {
        return new Builder().fleetId(this.fleetId).requestJavaMigrationAnalysesDetails(this.requestJavaMigrationAnalysesDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",fleetId=").append(String.valueOf(this.fleetId));
        sb.append(",requestJavaMigrationAnalysesDetails=").append(String.valueOf((Object)this.requestJavaMigrationAnalysesDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestJavaMigrationAnalysesRequest)) {
            return false;
        }
        RequestJavaMigrationAnalysesRequest other = (RequestJavaMigrationAnalysesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.requestJavaMigrationAnalysesDetails, (Object)other.requestJavaMigrationAnalysesDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.requestJavaMigrationAnalysesDetails == null ? 43 : this.requestJavaMigrationAnalysesDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<RequestJavaMigrationAnalysesRequest, RequestJavaMigrationAnalysesDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String fleetId = null;
        private RequestJavaMigrationAnalysesDetails requestJavaMigrationAnalysesDetails = null;
        private String opcRequestId = null;

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public Builder requestJavaMigrationAnalysesDetails(RequestJavaMigrationAnalysesDetails requestJavaMigrationAnalysesDetails) {
            this.requestJavaMigrationAnalysesDetails = requestJavaMigrationAnalysesDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RequestJavaMigrationAnalysesRequest o) {
            this.fleetId(o.getFleetId());
            this.requestJavaMigrationAnalysesDetails(o.getRequestJavaMigrationAnalysesDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RequestJavaMigrationAnalysesRequest build() {
            RequestJavaMigrationAnalysesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(RequestJavaMigrationAnalysesDetails body) {
            this.requestJavaMigrationAnalysesDetails(body);
            return this;
        }

        public RequestJavaMigrationAnalysesRequest buildWithoutInvocationCallback() {
            RequestJavaMigrationAnalysesRequest request = new RequestJavaMigrationAnalysesRequest();
            request.fleetId = this.fleetId;
            request.requestJavaMigrationAnalysesDetails = this.requestJavaMigrationAnalysesDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

