/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DeployedApplicationMigrationAnalysesTarget
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="deployedApplicationInstallationKey")
    private final String deployedApplicationInstallationKey;
    @JsonProperty(value="sourceJdkVersion")
    private final String sourceJdkVersion;
    @JsonProperty(value="targetJdkVersion")
    private final String targetJdkVersion;
    @JsonProperty(value="excludePackagePrefixes")
    private final List<String> excludePackagePrefixes;

    @Deprecated
    @ConstructorProperties(value={"managedInstanceId", "deployedApplicationInstallationKey", "sourceJdkVersion", "targetJdkVersion", "excludePackagePrefixes"})
    public DeployedApplicationMigrationAnalysesTarget(String managedInstanceId, String deployedApplicationInstallationKey, String sourceJdkVersion, String targetJdkVersion, List<String> excludePackagePrefixes) {
        this.managedInstanceId = managedInstanceId;
        this.deployedApplicationInstallationKey = deployedApplicationInstallationKey;
        this.sourceJdkVersion = sourceJdkVersion;
        this.targetJdkVersion = targetJdkVersion;
        this.excludePackagePrefixes = excludePackagePrefixes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public String getDeployedApplicationInstallationKey() {
        return this.deployedApplicationInstallationKey;
    }

    public String getSourceJdkVersion() {
        return this.sourceJdkVersion;
    }

    public String getTargetJdkVersion() {
        return this.targetJdkVersion;
    }

    public List<String> getExcludePackagePrefixes() {
        return this.excludePackagePrefixes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DeployedApplicationMigrationAnalysesTarget(");
        sb.append("super=").append(super.toString());
        sb.append("managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", deployedApplicationInstallationKey=").append(String.valueOf(this.deployedApplicationInstallationKey));
        sb.append(", sourceJdkVersion=").append(String.valueOf(this.sourceJdkVersion));
        sb.append(", targetJdkVersion=").append(String.valueOf(this.targetJdkVersion));
        sb.append(", excludePackagePrefixes=").append(String.valueOf(this.excludePackagePrefixes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeployedApplicationMigrationAnalysesTarget)) {
            return false;
        }
        DeployedApplicationMigrationAnalysesTarget other = (DeployedApplicationMigrationAnalysesTarget)((Object)o);
        return Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals(this.deployedApplicationInstallationKey, other.deployedApplicationInstallationKey) && Objects.equals(this.sourceJdkVersion, other.sourceJdkVersion) && Objects.equals(this.targetJdkVersion, other.targetJdkVersion) && Objects.equals(this.excludePackagePrefixes, other.excludePackagePrefixes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.deployedApplicationInstallationKey == null ? 43 : this.deployedApplicationInstallationKey.hashCode());
        result = result * 59 + (this.sourceJdkVersion == null ? 43 : this.sourceJdkVersion.hashCode());
        result = result * 59 + (this.targetJdkVersion == null ? 43 : this.targetJdkVersion.hashCode());
        result = result * 59 + (this.excludePackagePrefixes == null ? 43 : this.excludePackagePrefixes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="deployedApplicationInstallationKey")
        private String deployedApplicationInstallationKey;
        @JsonProperty(value="sourceJdkVersion")
        private String sourceJdkVersion;
        @JsonProperty(value="targetJdkVersion")
        private String targetJdkVersion;
        @JsonProperty(value="excludePackagePrefixes")
        private List<String> excludePackagePrefixes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder deployedApplicationInstallationKey(String deployedApplicationInstallationKey) {
            this.deployedApplicationInstallationKey = deployedApplicationInstallationKey;
            this.__explicitlySet__.add("deployedApplicationInstallationKey");
            return this;
        }

        public Builder sourceJdkVersion(String sourceJdkVersion) {
            this.sourceJdkVersion = sourceJdkVersion;
            this.__explicitlySet__.add("sourceJdkVersion");
            return this;
        }

        public Builder targetJdkVersion(String targetJdkVersion) {
            this.targetJdkVersion = targetJdkVersion;
            this.__explicitlySet__.add("targetJdkVersion");
            return this;
        }

        public Builder excludePackagePrefixes(List<String> excludePackagePrefixes) {
            this.excludePackagePrefixes = excludePackagePrefixes;
            this.__explicitlySet__.add("excludePackagePrefixes");
            return this;
        }

        public DeployedApplicationMigrationAnalysesTarget build() {
            DeployedApplicationMigrationAnalysesTarget model = new DeployedApplicationMigrationAnalysesTarget(this.managedInstanceId, this.deployedApplicationInstallationKey, this.sourceJdkVersion, this.targetJdkVersion, this.excludePackagePrefixes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DeployedApplicationMigrationAnalysesTarget model) {
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("deployedApplicationInstallationKey")) {
                this.deployedApplicationInstallationKey(model.getDeployedApplicationInstallationKey());
            }
            if (model.wasPropertyExplicitlySet("sourceJdkVersion")) {
                this.sourceJdkVersion(model.getSourceJdkVersion());
            }
            if (model.wasPropertyExplicitlySet("targetJdkVersion")) {
                this.targetJdkVersion(model.getTargetJdkVersion());
            }
            if (model.wasPropertyExplicitlySet("excludePackagePrefixes")) {
                this.excludePackagePrefixes(model.getExcludePackagePrefixes());
            }
            return this;
        }
    }
}

