/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DrsFile
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bucketName")
    private final String bucketName;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="drsFileName")
    private final String drsFileName;
    @JsonProperty(value="drsFileKey")
    private final String drsFileKey;
    @JsonProperty(value="checksumType")
    private final ChecksumType checksumType;
    @JsonProperty(value="checksumValue")
    private final String checksumValue;
    @JsonProperty(value="isDefault")
    private final Boolean isDefault;

    @Deprecated
    @ConstructorProperties(value={"bucketName", "namespace", "drsFileName", "drsFileKey", "checksumType", "checksumValue", "isDefault"})
    public DrsFile(String bucketName, String namespace, String drsFileName, String drsFileKey, ChecksumType checksumType, String checksumValue, Boolean isDefault) {
        this.bucketName = bucketName;
        this.namespace = namespace;
        this.drsFileName = drsFileName;
        this.drsFileKey = drsFileKey;
        this.checksumType = checksumType;
        this.checksumValue = checksumValue;
        this.isDefault = isDefault;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getDrsFileName() {
        return this.drsFileName;
    }

    public String getDrsFileKey() {
        return this.drsFileKey;
    }

    public ChecksumType getChecksumType() {
        return this.checksumType;
    }

    public String getChecksumValue() {
        return this.checksumValue;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DrsFile(");
        sb.append("super=").append(super.toString());
        sb.append("bucketName=").append(String.valueOf(this.bucketName));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", drsFileName=").append(String.valueOf(this.drsFileName));
        sb.append(", drsFileKey=").append(String.valueOf(this.drsFileKey));
        sb.append(", checksumType=").append(String.valueOf((Object)this.checksumType));
        sb.append(", checksumValue=").append(String.valueOf(this.checksumValue));
        sb.append(", isDefault=").append(String.valueOf(this.isDefault));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DrsFile)) {
            return false;
        }
        DrsFile other = (DrsFile)((Object)o);
        return Objects.equals(this.bucketName, other.bucketName) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.drsFileName, other.drsFileName) && Objects.equals(this.drsFileKey, other.drsFileKey) && Objects.equals((Object)this.checksumType, (Object)other.checksumType) && Objects.equals(this.checksumValue, other.checksumValue) && Objects.equals(this.isDefault, other.isDefault) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bucketName == null ? 43 : this.bucketName.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.drsFileName == null ? 43 : this.drsFileName.hashCode());
        result = result * 59 + (this.drsFileKey == null ? 43 : this.drsFileKey.hashCode());
        result = result * 59 + (this.checksumType == null ? 43 : this.checksumType.hashCode());
        result = result * 59 + (this.checksumValue == null ? 43 : this.checksumValue.hashCode());
        result = result * 59 + (this.isDefault == null ? 43 : this.isDefault.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ChecksumType implements BmcEnum
    {
        Sha256("SHA256"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ChecksumType> map;

        private ChecksumType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ChecksumType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ChecksumType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ChecksumType.class);
            map = new HashMap<String, ChecksumType>();
            for (ChecksumType v : ChecksumType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bucketName")
        private String bucketName;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="drsFileName")
        private String drsFileName;
        @JsonProperty(value="drsFileKey")
        private String drsFileKey;
        @JsonProperty(value="checksumType")
        private ChecksumType checksumType;
        @JsonProperty(value="checksumValue")
        private String checksumValue;
        @JsonProperty(value="isDefault")
        private Boolean isDefault;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            this.__explicitlySet__.add("bucketName");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder drsFileName(String drsFileName) {
            this.drsFileName = drsFileName;
            this.__explicitlySet__.add("drsFileName");
            return this;
        }

        public Builder drsFileKey(String drsFileKey) {
            this.drsFileKey = drsFileKey;
            this.__explicitlySet__.add("drsFileKey");
            return this;
        }

        public Builder checksumType(ChecksumType checksumType) {
            this.checksumType = checksumType;
            this.__explicitlySet__.add("checksumType");
            return this;
        }

        public Builder checksumValue(String checksumValue) {
            this.checksumValue = checksumValue;
            this.__explicitlySet__.add("checksumValue");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.__explicitlySet__.add("isDefault");
            return this;
        }

        public DrsFile build() {
            DrsFile model = new DrsFile(this.bucketName, this.namespace, this.drsFileName, this.drsFileKey, this.checksumType, this.checksumValue, this.isDefault);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DrsFile model) {
            if (model.wasPropertyExplicitlySet("bucketName")) {
                this.bucketName(model.getBucketName());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("drsFileName")) {
                this.drsFileName(model.getDrsFileName());
            }
            if (model.wasPropertyExplicitlySet("drsFileKey")) {
                this.drsFileKey(model.getDrsFileKey());
            }
            if (model.wasPropertyExplicitlySet("checksumType")) {
                this.checksumType(model.getChecksumType());
            }
            if (model.wasPropertyExplicitlySet("checksumValue")) {
                this.checksumValue(model.getChecksumValue());
            }
            if (model.wasPropertyExplicitlySet("isDefault")) {
                this.isDefault(model.getIsDefault());
            }
            return this;
        }
    }
}

