/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.ExportDuration;
import com.oracle.bmc.jms.model.ExportFrequency;
import com.oracle.bmc.jms.model.ExportResources;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportSetting
extends ExplicitlySetBmcModel {
    @JsonProperty(value="exportSettingKey")
    private final String exportSettingKey;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="exportDuration")
    private final ExportDuration exportDuration;
    @JsonProperty(value="exportResources")
    private final ExportResources exportResources;
    @JsonProperty(value="isCrossRegionAcknowledged")
    private final Boolean isCrossRegionAcknowledged;
    @JsonProperty(value="targetBucketName")
    private final String targetBucketName;
    @JsonProperty(value="targetBucketNamespace")
    private final String targetBucketNamespace;
    @JsonProperty(value="targetBucketRegion")
    private final String targetBucketRegion;
    @JsonProperty(value="exportFrequency")
    private final ExportFrequency exportFrequency;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeLastModified")
    private final Date timeLastModified;

    @Deprecated
    @ConstructorProperties(value={"exportSettingKey", "fleetId", "exportDuration", "exportResources", "isCrossRegionAcknowledged", "targetBucketName", "targetBucketNamespace", "targetBucketRegion", "exportFrequency", "isEnabled", "timeCreated", "timeLastModified"})
    public ExportSetting(String exportSettingKey, String fleetId, ExportDuration exportDuration, ExportResources exportResources, Boolean isCrossRegionAcknowledged, String targetBucketName, String targetBucketNamespace, String targetBucketRegion, ExportFrequency exportFrequency, Boolean isEnabled, Date timeCreated, Date timeLastModified) {
        this.exportSettingKey = exportSettingKey;
        this.fleetId = fleetId;
        this.exportDuration = exportDuration;
        this.exportResources = exportResources;
        this.isCrossRegionAcknowledged = isCrossRegionAcknowledged;
        this.targetBucketName = targetBucketName;
        this.targetBucketNamespace = targetBucketNamespace;
        this.targetBucketRegion = targetBucketRegion;
        this.exportFrequency = exportFrequency;
        this.isEnabled = isEnabled;
        this.timeCreated = timeCreated;
        this.timeLastModified = timeLastModified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getExportSettingKey() {
        return this.exportSettingKey;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public ExportDuration getExportDuration() {
        return this.exportDuration;
    }

    public ExportResources getExportResources() {
        return this.exportResources;
    }

    public Boolean getIsCrossRegionAcknowledged() {
        return this.isCrossRegionAcknowledged;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public String getTargetBucketNamespace() {
        return this.targetBucketNamespace;
    }

    public String getTargetBucketRegion() {
        return this.targetBucketRegion;
    }

    public ExportFrequency getExportFrequency() {
        return this.exportFrequency;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeLastModified() {
        return this.timeLastModified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExportSetting(");
        sb.append("super=").append(super.toString());
        sb.append("exportSettingKey=").append(String.valueOf(this.exportSettingKey));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", exportDuration=").append(String.valueOf((Object)this.exportDuration));
        sb.append(", exportResources=").append(String.valueOf((Object)this.exportResources));
        sb.append(", isCrossRegionAcknowledged=").append(String.valueOf(this.isCrossRegionAcknowledged));
        sb.append(", targetBucketName=").append(String.valueOf(this.targetBucketName));
        sb.append(", targetBucketNamespace=").append(String.valueOf(this.targetBucketNamespace));
        sb.append(", targetBucketRegion=").append(String.valueOf(this.targetBucketRegion));
        sb.append(", exportFrequency=").append(String.valueOf((Object)this.exportFrequency));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeLastModified=").append(String.valueOf(this.timeLastModified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExportSetting)) {
            return false;
        }
        ExportSetting other = (ExportSetting)((Object)o);
        return Objects.equals(this.exportSettingKey, other.exportSettingKey) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals((Object)this.exportDuration, (Object)other.exportDuration) && Objects.equals((Object)this.exportResources, (Object)other.exportResources) && Objects.equals(this.isCrossRegionAcknowledged, other.isCrossRegionAcknowledged) && Objects.equals(this.targetBucketName, other.targetBucketName) && Objects.equals(this.targetBucketNamespace, other.targetBucketNamespace) && Objects.equals(this.targetBucketRegion, other.targetBucketRegion) && Objects.equals((Object)this.exportFrequency, (Object)other.exportFrequency) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeLastModified, other.timeLastModified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.exportSettingKey == null ? 43 : this.exportSettingKey.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.exportDuration == null ? 43 : this.exportDuration.hashCode());
        result = result * 59 + (this.exportResources == null ? 43 : this.exportResources.hashCode());
        result = result * 59 + (this.isCrossRegionAcknowledged == null ? 43 : this.isCrossRegionAcknowledged.hashCode());
        result = result * 59 + (this.targetBucketName == null ? 43 : this.targetBucketName.hashCode());
        result = result * 59 + (this.targetBucketNamespace == null ? 43 : this.targetBucketNamespace.hashCode());
        result = result * 59 + (this.targetBucketRegion == null ? 43 : this.targetBucketRegion.hashCode());
        result = result * 59 + (this.exportFrequency == null ? 43 : this.exportFrequency.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeLastModified == null ? 43 : this.timeLastModified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="exportSettingKey")
        private String exportSettingKey;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="exportDuration")
        private ExportDuration exportDuration;
        @JsonProperty(value="exportResources")
        private ExportResources exportResources;
        @JsonProperty(value="isCrossRegionAcknowledged")
        private Boolean isCrossRegionAcknowledged;
        @JsonProperty(value="targetBucketName")
        private String targetBucketName;
        @JsonProperty(value="targetBucketNamespace")
        private String targetBucketNamespace;
        @JsonProperty(value="targetBucketRegion")
        private String targetBucketRegion;
        @JsonProperty(value="exportFrequency")
        private ExportFrequency exportFrequency;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeLastModified")
        private Date timeLastModified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder exportSettingKey(String exportSettingKey) {
            this.exportSettingKey = exportSettingKey;
            this.__explicitlySet__.add("exportSettingKey");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder exportDuration(ExportDuration exportDuration) {
            this.exportDuration = exportDuration;
            this.__explicitlySet__.add("exportDuration");
            return this;
        }

        public Builder exportResources(ExportResources exportResources) {
            this.exportResources = exportResources;
            this.__explicitlySet__.add("exportResources");
            return this;
        }

        public Builder isCrossRegionAcknowledged(Boolean isCrossRegionAcknowledged) {
            this.isCrossRegionAcknowledged = isCrossRegionAcknowledged;
            this.__explicitlySet__.add("isCrossRegionAcknowledged");
            return this;
        }

        public Builder targetBucketName(String targetBucketName) {
            this.targetBucketName = targetBucketName;
            this.__explicitlySet__.add("targetBucketName");
            return this;
        }

        public Builder targetBucketNamespace(String targetBucketNamespace) {
            this.targetBucketNamespace = targetBucketNamespace;
            this.__explicitlySet__.add("targetBucketNamespace");
            return this;
        }

        public Builder targetBucketRegion(String targetBucketRegion) {
            this.targetBucketRegion = targetBucketRegion;
            this.__explicitlySet__.add("targetBucketRegion");
            return this;
        }

        public Builder exportFrequency(ExportFrequency exportFrequency) {
            this.exportFrequency = exportFrequency;
            this.__explicitlySet__.add("exportFrequency");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeLastModified(Date timeLastModified) {
            this.timeLastModified = timeLastModified;
            this.__explicitlySet__.add("timeLastModified");
            return this;
        }

        public ExportSetting build() {
            ExportSetting model = new ExportSetting(this.exportSettingKey, this.fleetId, this.exportDuration, this.exportResources, this.isCrossRegionAcknowledged, this.targetBucketName, this.targetBucketNamespace, this.targetBucketRegion, this.exportFrequency, this.isEnabled, this.timeCreated, this.timeLastModified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExportSetting model) {
            if (model.wasPropertyExplicitlySet("exportSettingKey")) {
                this.exportSettingKey(model.getExportSettingKey());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("exportDuration")) {
                this.exportDuration(model.getExportDuration());
            }
            if (model.wasPropertyExplicitlySet("exportResources")) {
                this.exportResources(model.getExportResources());
            }
            if (model.wasPropertyExplicitlySet("isCrossRegionAcknowledged")) {
                this.isCrossRegionAcknowledged(model.getIsCrossRegionAcknowledged());
            }
            if (model.wasPropertyExplicitlySet("targetBucketName")) {
                this.targetBucketName(model.getTargetBucketName());
            }
            if (model.wasPropertyExplicitlySet("targetBucketNamespace")) {
                this.targetBucketNamespace(model.getTargetBucketNamespace());
            }
            if (model.wasPropertyExplicitlySet("targetBucketRegion")) {
                this.targetBucketRegion(model.getTargetBucketRegion());
            }
            if (model.wasPropertyExplicitlySet("exportFrequency")) {
                this.exportFrequency(model.getExportFrequency());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeLastModified")) {
                this.timeLastModified(model.getTimeLastModified());
            }
            return this;
        }
    }
}

