/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.SupportType;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JavaFamilySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="familyVersion")
    private final String familyVersion;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="supportType")
    private final SupportType supportType;
    @JsonProperty(value="endOfSupportLifeDate")
    private final Date endOfSupportLifeDate;
    @JsonProperty(value="docUrl")
    private final String docUrl;
    @JsonProperty(value="latestReleaseVersion")
    private final String latestReleaseVersion;
    @JsonProperty(value="isSupportedVersion")
    private final Boolean isSupportedVersion;
    @JsonProperty(value="releaseDate")
    private final Date releaseDate;

    @Deprecated
    @ConstructorProperties(value={"familyVersion", "displayName", "supportType", "endOfSupportLifeDate", "docUrl", "latestReleaseVersion", "isSupportedVersion", "releaseDate"})
    public JavaFamilySummary(String familyVersion, String displayName, SupportType supportType, Date endOfSupportLifeDate, String docUrl, String latestReleaseVersion, Boolean isSupportedVersion, Date releaseDate) {
        this.familyVersion = familyVersion;
        this.displayName = displayName;
        this.supportType = supportType;
        this.endOfSupportLifeDate = endOfSupportLifeDate;
        this.docUrl = docUrl;
        this.latestReleaseVersion = latestReleaseVersion;
        this.isSupportedVersion = isSupportedVersion;
        this.releaseDate = releaseDate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getFamilyVersion() {
        return this.familyVersion;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SupportType getSupportType() {
        return this.supportType;
    }

    public Date getEndOfSupportLifeDate() {
        return this.endOfSupportLifeDate;
    }

    public String getDocUrl() {
        return this.docUrl;
    }

    public String getLatestReleaseVersion() {
        return this.latestReleaseVersion;
    }

    public Boolean getIsSupportedVersion() {
        return this.isSupportedVersion;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JavaFamilySummary(");
        sb.append("super=").append(super.toString());
        sb.append("familyVersion=").append(String.valueOf(this.familyVersion));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", supportType=").append(String.valueOf((Object)this.supportType));
        sb.append(", endOfSupportLifeDate=").append(String.valueOf(this.endOfSupportLifeDate));
        sb.append(", docUrl=").append(String.valueOf(this.docUrl));
        sb.append(", latestReleaseVersion=").append(String.valueOf(this.latestReleaseVersion));
        sb.append(", isSupportedVersion=").append(String.valueOf(this.isSupportedVersion));
        sb.append(", releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaFamilySummary)) {
            return false;
        }
        JavaFamilySummary other = (JavaFamilySummary)((Object)o);
        return Objects.equals(this.familyVersion, other.familyVersion) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.supportType, (Object)other.supportType) && Objects.equals(this.endOfSupportLifeDate, other.endOfSupportLifeDate) && Objects.equals(this.docUrl, other.docUrl) && Objects.equals(this.latestReleaseVersion, other.latestReleaseVersion) && Objects.equals(this.isSupportedVersion, other.isSupportedVersion) && Objects.equals(this.releaseDate, other.releaseDate) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.familyVersion == null ? 43 : this.familyVersion.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.supportType == null ? 43 : this.supportType.hashCode());
        result = result * 59 + (this.endOfSupportLifeDate == null ? 43 : this.endOfSupportLifeDate.hashCode());
        result = result * 59 + (this.docUrl == null ? 43 : this.docUrl.hashCode());
        result = result * 59 + (this.latestReleaseVersion == null ? 43 : this.latestReleaseVersion.hashCode());
        result = result * 59 + (this.isSupportedVersion == null ? 43 : this.isSupportedVersion.hashCode());
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="familyVersion")
        private String familyVersion;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="supportType")
        private SupportType supportType;
        @JsonProperty(value="endOfSupportLifeDate")
        private Date endOfSupportLifeDate;
        @JsonProperty(value="docUrl")
        private String docUrl;
        @JsonProperty(value="latestReleaseVersion")
        private String latestReleaseVersion;
        @JsonProperty(value="isSupportedVersion")
        private Boolean isSupportedVersion;
        @JsonProperty(value="releaseDate")
        private Date releaseDate;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder familyVersion(String familyVersion) {
            this.familyVersion = familyVersion;
            this.__explicitlySet__.add("familyVersion");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder supportType(SupportType supportType) {
            this.supportType = supportType;
            this.__explicitlySet__.add("supportType");
            return this;
        }

        public Builder endOfSupportLifeDate(Date endOfSupportLifeDate) {
            this.endOfSupportLifeDate = endOfSupportLifeDate;
            this.__explicitlySet__.add("endOfSupportLifeDate");
            return this;
        }

        public Builder docUrl(String docUrl) {
            this.docUrl = docUrl;
            this.__explicitlySet__.add("docUrl");
            return this;
        }

        public Builder latestReleaseVersion(String latestReleaseVersion) {
            this.latestReleaseVersion = latestReleaseVersion;
            this.__explicitlySet__.add("latestReleaseVersion");
            return this;
        }

        public Builder isSupportedVersion(Boolean isSupportedVersion) {
            this.isSupportedVersion = isSupportedVersion;
            this.__explicitlySet__.add("isSupportedVersion");
            return this;
        }

        public Builder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public JavaFamilySummary build() {
            JavaFamilySummary model = new JavaFamilySummary(this.familyVersion, this.displayName, this.supportType, this.endOfSupportLifeDate, this.docUrl, this.latestReleaseVersion, this.isSupportedVersion, this.releaseDate);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JavaFamilySummary model) {
            if (model.wasPropertyExplicitlySet("familyVersion")) {
                this.familyVersion(model.getFamilyVersion());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("supportType")) {
                this.supportType(model.getSupportType());
            }
            if (model.wasPropertyExplicitlySet("endOfSupportLifeDate")) {
                this.endOfSupportLifeDate(model.getEndOfSupportLifeDate());
            }
            if (model.wasPropertyExplicitlySet("docUrl")) {
                this.docUrl(model.getDocUrl());
            }
            if (model.wasPropertyExplicitlySet("latestReleaseVersion")) {
                this.latestReleaseVersion(model.getLatestReleaseVersion());
            }
            if (model.wasPropertyExplicitlySet("isSupportedVersion")) {
                this.isSupportedVersion(model.getIsSupportedVersion());
            }
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            return this;
        }
    }
}

