/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.JreSecurityStatus;
import com.oracle.bmc.jms.model.OperatingSystem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class JreUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="fleetId")
    private final String fleetId;
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="securityStatus")
    private final JreSecurityStatus securityStatus;
    @JsonProperty(value="releaseDate")
    private final Date releaseDate;
    @JsonProperty(value="endOfSupportLifeDate")
    private final Date endOfSupportLifeDate;
    @JsonProperty(value="vendor")
    private final String vendor;
    @JsonProperty(value="distribution")
    private final String distribution;
    @JsonProperty(value="version")
    private final String version;
    @JsonProperty(value="daysUnderSecurityBaseline")
    private final Integer daysUnderSecurityBaseline;
    @JsonProperty(value="operatingSystems")
    private final List<OperatingSystem> operatingSystems;
    @JsonProperty(value="approximateInstallationCount")
    private final Integer approximateInstallationCount;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="approximateManagedInstanceCount")
    private final Integer approximateManagedInstanceCount;
    @JsonProperty(value="approximatePendingWorkRequestCount")
    private final Integer approximatePendingWorkRequestCount;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"id", "fleetId", "managedInstanceId", "securityStatus", "releaseDate", "endOfSupportLifeDate", "vendor", "distribution", "version", "daysUnderSecurityBaseline", "operatingSystems", "approximateInstallationCount", "approximateApplicationCount", "approximateManagedInstanceCount", "approximatePendingWorkRequestCount", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public JreUsage(String id, String fleetId, String managedInstanceId, JreSecurityStatus securityStatus, Date releaseDate, Date endOfSupportLifeDate, String vendor, String distribution, String version, Integer daysUnderSecurityBaseline, List<OperatingSystem> operatingSystems, Integer approximateInstallationCount, Integer approximateApplicationCount, Integer approximateManagedInstanceCount, Integer approximatePendingWorkRequestCount, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.id = id;
        this.fleetId = fleetId;
        this.managedInstanceId = managedInstanceId;
        this.securityStatus = securityStatus;
        this.releaseDate = releaseDate;
        this.endOfSupportLifeDate = endOfSupportLifeDate;
        this.vendor = vendor;
        this.distribution = distribution;
        this.version = version;
        this.daysUnderSecurityBaseline = daysUnderSecurityBaseline;
        this.operatingSystems = operatingSystems;
        this.approximateInstallationCount = approximateInstallationCount;
        this.approximateApplicationCount = approximateApplicationCount;
        this.approximateManagedInstanceCount = approximateManagedInstanceCount;
        this.approximatePendingWorkRequestCount = approximatePendingWorkRequestCount;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public JreSecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    public Date getEndOfSupportLifeDate() {
        return this.endOfSupportLifeDate;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getDaysUnderSecurityBaseline() {
        return this.daysUnderSecurityBaseline;
    }

    public List<OperatingSystem> getOperatingSystems() {
        return this.operatingSystems;
    }

    public Integer getApproximateInstallationCount() {
        return this.approximateInstallationCount;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Integer getApproximateManagedInstanceCount() {
        return this.approximateManagedInstanceCount;
    }

    public Integer getApproximatePendingWorkRequestCount() {
        return this.approximatePendingWorkRequestCount;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("JreUsage(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", fleetId=").append(String.valueOf(this.fleetId));
        sb.append(", managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", securityStatus=").append(String.valueOf((Object)this.securityStatus));
        sb.append(", releaseDate=").append(String.valueOf(this.releaseDate));
        sb.append(", endOfSupportLifeDate=").append(String.valueOf(this.endOfSupportLifeDate));
        sb.append(", vendor=").append(String.valueOf(this.vendor));
        sb.append(", distribution=").append(String.valueOf(this.distribution));
        sb.append(", version=").append(String.valueOf(this.version));
        sb.append(", daysUnderSecurityBaseline=").append(String.valueOf(this.daysUnderSecurityBaseline));
        sb.append(", operatingSystems=").append(String.valueOf(this.operatingSystems));
        sb.append(", approximateInstallationCount=").append(String.valueOf(this.approximateInstallationCount));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", approximateManagedInstanceCount=").append(String.valueOf(this.approximateManagedInstanceCount));
        sb.append(", approximatePendingWorkRequestCount=").append(String.valueOf(this.approximatePendingWorkRequestCount));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JreUsage)) {
            return false;
        }
        JreUsage other = (JreUsage)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.fleetId, other.fleetId) && Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals((Object)this.securityStatus, (Object)other.securityStatus) && Objects.equals(this.releaseDate, other.releaseDate) && Objects.equals(this.endOfSupportLifeDate, other.endOfSupportLifeDate) && Objects.equals(this.vendor, other.vendor) && Objects.equals(this.distribution, other.distribution) && Objects.equals(this.version, other.version) && Objects.equals(this.daysUnderSecurityBaseline, other.daysUnderSecurityBaseline) && Objects.equals(this.operatingSystems, other.operatingSystems) && Objects.equals(this.approximateInstallationCount, other.approximateInstallationCount) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.approximateManagedInstanceCount, other.approximateManagedInstanceCount) && Objects.equals(this.approximatePendingWorkRequestCount, other.approximatePendingWorkRequestCount) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.fleetId == null ? 43 : this.fleetId.hashCode());
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.securityStatus == null ? 43 : this.securityStatus.hashCode());
        result = result * 59 + (this.releaseDate == null ? 43 : this.releaseDate.hashCode());
        result = result * 59 + (this.endOfSupportLifeDate == null ? 43 : this.endOfSupportLifeDate.hashCode());
        result = result * 59 + (this.vendor == null ? 43 : this.vendor.hashCode());
        result = result * 59 + (this.distribution == null ? 43 : this.distribution.hashCode());
        result = result * 59 + (this.version == null ? 43 : this.version.hashCode());
        result = result * 59 + (this.daysUnderSecurityBaseline == null ? 43 : this.daysUnderSecurityBaseline.hashCode());
        result = result * 59 + (this.operatingSystems == null ? 43 : this.operatingSystems.hashCode());
        result = result * 59 + (this.approximateInstallationCount == null ? 43 : this.approximateInstallationCount.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.approximateManagedInstanceCount == null ? 43 : this.approximateManagedInstanceCount.hashCode());
        result = result * 59 + (this.approximatePendingWorkRequestCount == null ? 43 : this.approximatePendingWorkRequestCount.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="fleetId")
        private String fleetId;
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="securityStatus")
        private JreSecurityStatus securityStatus;
        @JsonProperty(value="releaseDate")
        private Date releaseDate;
        @JsonProperty(value="endOfSupportLifeDate")
        private Date endOfSupportLifeDate;
        @JsonProperty(value="vendor")
        private String vendor;
        @JsonProperty(value="distribution")
        private String distribution;
        @JsonProperty(value="version")
        private String version;
        @JsonProperty(value="daysUnderSecurityBaseline")
        private Integer daysUnderSecurityBaseline;
        @JsonProperty(value="operatingSystems")
        private List<OperatingSystem> operatingSystems;
        @JsonProperty(value="approximateInstallationCount")
        private Integer approximateInstallationCount;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="approximateManagedInstanceCount")
        private Integer approximateManagedInstanceCount;
        @JsonProperty(value="approximatePendingWorkRequestCount")
        private Integer approximatePendingWorkRequestCount;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            this.__explicitlySet__.add("fleetId");
            return this;
        }

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder securityStatus(JreSecurityStatus securityStatus) {
            this.securityStatus = securityStatus;
            this.__explicitlySet__.add("securityStatus");
            return this;
        }

        public Builder releaseDate(Date releaseDate) {
            this.releaseDate = releaseDate;
            this.__explicitlySet__.add("releaseDate");
            return this;
        }

        public Builder endOfSupportLifeDate(Date endOfSupportLifeDate) {
            this.endOfSupportLifeDate = endOfSupportLifeDate;
            this.__explicitlySet__.add("endOfSupportLifeDate");
            return this;
        }

        public Builder vendor(String vendor) {
            this.vendor = vendor;
            this.__explicitlySet__.add("vendor");
            return this;
        }

        public Builder distribution(String distribution) {
            this.distribution = distribution;
            this.__explicitlySet__.add("distribution");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.__explicitlySet__.add("version");
            return this;
        }

        public Builder daysUnderSecurityBaseline(Integer daysUnderSecurityBaseline) {
            this.daysUnderSecurityBaseline = daysUnderSecurityBaseline;
            this.__explicitlySet__.add("daysUnderSecurityBaseline");
            return this;
        }

        public Builder operatingSystems(List<OperatingSystem> operatingSystems) {
            this.operatingSystems = operatingSystems;
            this.__explicitlySet__.add("operatingSystems");
            return this;
        }

        public Builder approximateInstallationCount(Integer approximateInstallationCount) {
            this.approximateInstallationCount = approximateInstallationCount;
            this.__explicitlySet__.add("approximateInstallationCount");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder approximateManagedInstanceCount(Integer approximateManagedInstanceCount) {
            this.approximateManagedInstanceCount = approximateManagedInstanceCount;
            this.__explicitlySet__.add("approximateManagedInstanceCount");
            return this;
        }

        public Builder approximatePendingWorkRequestCount(Integer approximatePendingWorkRequestCount) {
            this.approximatePendingWorkRequestCount = approximatePendingWorkRequestCount;
            this.__explicitlySet__.add("approximatePendingWorkRequestCount");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public JreUsage build() {
            JreUsage model = new JreUsage(this.id, this.fleetId, this.managedInstanceId, this.securityStatus, this.releaseDate, this.endOfSupportLifeDate, this.vendor, this.distribution, this.version, this.daysUnderSecurityBaseline, this.operatingSystems, this.approximateInstallationCount, this.approximateApplicationCount, this.approximateManagedInstanceCount, this.approximatePendingWorkRequestCount, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(JreUsage model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("fleetId")) {
                this.fleetId(model.getFleetId());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("securityStatus")) {
                this.securityStatus(model.getSecurityStatus());
            }
            if (model.wasPropertyExplicitlySet("releaseDate")) {
                this.releaseDate(model.getReleaseDate());
            }
            if (model.wasPropertyExplicitlySet("endOfSupportLifeDate")) {
                this.endOfSupportLifeDate(model.getEndOfSupportLifeDate());
            }
            if (model.wasPropertyExplicitlySet("vendor")) {
                this.vendor(model.getVendor());
            }
            if (model.wasPropertyExplicitlySet("distribution")) {
                this.distribution(model.getDistribution());
            }
            if (model.wasPropertyExplicitlySet("version")) {
                this.version(model.getVersion());
            }
            if (model.wasPropertyExplicitlySet("daysUnderSecurityBaseline")) {
                this.daysUnderSecurityBaseline(model.getDaysUnderSecurityBaseline());
            }
            if (model.wasPropertyExplicitlySet("operatingSystems")) {
                this.operatingSystems(model.getOperatingSystems());
            }
            if (model.wasPropertyExplicitlySet("approximateInstallationCount")) {
                this.approximateInstallationCount(model.getApproximateInstallationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateManagedInstanceCount")) {
                this.approximateManagedInstanceCount(model.getApproximateManagedInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("approximatePendingWorkRequestCount")) {
                this.approximatePendingWorkRequestCount(model.getApproximatePendingWorkRequestCount());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

