/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.jms.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.jms.model.Agent;
import com.oracle.bmc.jms.model.DrsFileStatus;
import com.oracle.bmc.jms.model.ManagedInstanceType;
import com.oracle.bmc.jms.model.OperatingSystem;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ManagedInstanceUsage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="managedInstanceId")
    private final String managedInstanceId;
    @JsonProperty(value="managedInstanceType")
    private final ManagedInstanceType managedInstanceType;
    @JsonProperty(value="hostname")
    private final String hostname;
    @JsonProperty(value="hostId")
    private final String hostId;
    @JsonProperty(value="operatingSystem")
    private final OperatingSystem operatingSystem;
    @JsonProperty(value="agent")
    private final Agent agent;
    @JsonProperty(value="approximateApplicationCount")
    private final Integer approximateApplicationCount;
    @JsonProperty(value="approximateInstallationCount")
    private final Integer approximateInstallationCount;
    @JsonProperty(value="approximateJreCount")
    private final Integer approximateJreCount;
    @JsonProperty(value="drsFileStatus")
    private final DrsFileStatus drsFileStatus;
    @JsonProperty(value="applicationInvokedBy")
    private final String applicationInvokedBy;
    @JsonProperty(value="timeStart")
    private final Date timeStart;
    @JsonProperty(value="timeEnd")
    private final Date timeEnd;
    @JsonProperty(value="timeFirstSeen")
    private final Date timeFirstSeen;
    @JsonProperty(value="timeLastSeen")
    private final Date timeLastSeen;

    @Deprecated
    @ConstructorProperties(value={"managedInstanceId", "managedInstanceType", "hostname", "hostId", "operatingSystem", "agent", "approximateApplicationCount", "approximateInstallationCount", "approximateJreCount", "drsFileStatus", "applicationInvokedBy", "timeStart", "timeEnd", "timeFirstSeen", "timeLastSeen"})
    public ManagedInstanceUsage(String managedInstanceId, ManagedInstanceType managedInstanceType, String hostname, String hostId, OperatingSystem operatingSystem, Agent agent, Integer approximateApplicationCount, Integer approximateInstallationCount, Integer approximateJreCount, DrsFileStatus drsFileStatus, String applicationInvokedBy, Date timeStart, Date timeEnd, Date timeFirstSeen, Date timeLastSeen) {
        this.managedInstanceId = managedInstanceId;
        this.managedInstanceType = managedInstanceType;
        this.hostname = hostname;
        this.hostId = hostId;
        this.operatingSystem = operatingSystem;
        this.agent = agent;
        this.approximateApplicationCount = approximateApplicationCount;
        this.approximateInstallationCount = approximateInstallationCount;
        this.approximateJreCount = approximateJreCount;
        this.drsFileStatus = drsFileStatus;
        this.applicationInvokedBy = applicationInvokedBy;
        this.timeStart = timeStart;
        this.timeEnd = timeEnd;
        this.timeFirstSeen = timeFirstSeen;
        this.timeLastSeen = timeLastSeen;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getManagedInstanceId() {
        return this.managedInstanceId;
    }

    public ManagedInstanceType getManagedInstanceType() {
        return this.managedInstanceType;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getHostId() {
        return this.hostId;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Agent getAgent() {
        return this.agent;
    }

    public Integer getApproximateApplicationCount() {
        return this.approximateApplicationCount;
    }

    public Integer getApproximateInstallationCount() {
        return this.approximateInstallationCount;
    }

    public Integer getApproximateJreCount() {
        return this.approximateJreCount;
    }

    public DrsFileStatus getDrsFileStatus() {
        return this.drsFileStatus;
    }

    public String getApplicationInvokedBy() {
        return this.applicationInvokedBy;
    }

    public Date getTimeStart() {
        return this.timeStart;
    }

    public Date getTimeEnd() {
        return this.timeEnd;
    }

    public Date getTimeFirstSeen() {
        return this.timeFirstSeen;
    }

    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedInstanceUsage(");
        sb.append("super=").append(super.toString());
        sb.append("managedInstanceId=").append(String.valueOf(this.managedInstanceId));
        sb.append(", managedInstanceType=").append(String.valueOf((Object)this.managedInstanceType));
        sb.append(", hostname=").append(String.valueOf(this.hostname));
        sb.append(", hostId=").append(String.valueOf(this.hostId));
        sb.append(", operatingSystem=").append(String.valueOf((Object)this.operatingSystem));
        sb.append(", agent=").append(String.valueOf((Object)this.agent));
        sb.append(", approximateApplicationCount=").append(String.valueOf(this.approximateApplicationCount));
        sb.append(", approximateInstallationCount=").append(String.valueOf(this.approximateInstallationCount));
        sb.append(", approximateJreCount=").append(String.valueOf(this.approximateJreCount));
        sb.append(", drsFileStatus=").append(String.valueOf((Object)this.drsFileStatus));
        sb.append(", applicationInvokedBy=").append(String.valueOf(this.applicationInvokedBy));
        sb.append(", timeStart=").append(String.valueOf(this.timeStart));
        sb.append(", timeEnd=").append(String.valueOf(this.timeEnd));
        sb.append(", timeFirstSeen=").append(String.valueOf(this.timeFirstSeen));
        sb.append(", timeLastSeen=").append(String.valueOf(this.timeLastSeen));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ManagedInstanceUsage)) {
            return false;
        }
        ManagedInstanceUsage other = (ManagedInstanceUsage)((Object)o);
        return Objects.equals(this.managedInstanceId, other.managedInstanceId) && Objects.equals((Object)this.managedInstanceType, (Object)other.managedInstanceType) && Objects.equals(this.hostname, other.hostname) && Objects.equals(this.hostId, other.hostId) && Objects.equals((Object)this.operatingSystem, (Object)other.operatingSystem) && Objects.equals((Object)this.agent, (Object)other.agent) && Objects.equals(this.approximateApplicationCount, other.approximateApplicationCount) && Objects.equals(this.approximateInstallationCount, other.approximateInstallationCount) && Objects.equals(this.approximateJreCount, other.approximateJreCount) && Objects.equals((Object)this.drsFileStatus, (Object)other.drsFileStatus) && Objects.equals(this.applicationInvokedBy, other.applicationInvokedBy) && Objects.equals(this.timeStart, other.timeStart) && Objects.equals(this.timeEnd, other.timeEnd) && Objects.equals(this.timeFirstSeen, other.timeFirstSeen) && Objects.equals(this.timeLastSeen, other.timeLastSeen) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.managedInstanceId == null ? 43 : this.managedInstanceId.hashCode());
        result = result * 59 + (this.managedInstanceType == null ? 43 : this.managedInstanceType.hashCode());
        result = result * 59 + (this.hostname == null ? 43 : this.hostname.hashCode());
        result = result * 59 + (this.hostId == null ? 43 : this.hostId.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + (this.agent == null ? 43 : this.agent.hashCode());
        result = result * 59 + (this.approximateApplicationCount == null ? 43 : this.approximateApplicationCount.hashCode());
        result = result * 59 + (this.approximateInstallationCount == null ? 43 : this.approximateInstallationCount.hashCode());
        result = result * 59 + (this.approximateJreCount == null ? 43 : this.approximateJreCount.hashCode());
        result = result * 59 + (this.drsFileStatus == null ? 43 : this.drsFileStatus.hashCode());
        result = result * 59 + (this.applicationInvokedBy == null ? 43 : this.applicationInvokedBy.hashCode());
        result = result * 59 + (this.timeStart == null ? 43 : this.timeStart.hashCode());
        result = result * 59 + (this.timeEnd == null ? 43 : this.timeEnd.hashCode());
        result = result * 59 + (this.timeFirstSeen == null ? 43 : this.timeFirstSeen.hashCode());
        result = result * 59 + (this.timeLastSeen == null ? 43 : this.timeLastSeen.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="managedInstanceId")
        private String managedInstanceId;
        @JsonProperty(value="managedInstanceType")
        private ManagedInstanceType managedInstanceType;
        @JsonProperty(value="hostname")
        private String hostname;
        @JsonProperty(value="hostId")
        private String hostId;
        @JsonProperty(value="operatingSystem")
        private OperatingSystem operatingSystem;
        @JsonProperty(value="agent")
        private Agent agent;
        @JsonProperty(value="approximateApplicationCount")
        private Integer approximateApplicationCount;
        @JsonProperty(value="approximateInstallationCount")
        private Integer approximateInstallationCount;
        @JsonProperty(value="approximateJreCount")
        private Integer approximateJreCount;
        @JsonProperty(value="drsFileStatus")
        private DrsFileStatus drsFileStatus;
        @JsonProperty(value="applicationInvokedBy")
        private String applicationInvokedBy;
        @JsonProperty(value="timeStart")
        private Date timeStart;
        @JsonProperty(value="timeEnd")
        private Date timeEnd;
        @JsonProperty(value="timeFirstSeen")
        private Date timeFirstSeen;
        @JsonProperty(value="timeLastSeen")
        private Date timeLastSeen;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder managedInstanceId(String managedInstanceId) {
            this.managedInstanceId = managedInstanceId;
            this.__explicitlySet__.add("managedInstanceId");
            return this;
        }

        public Builder managedInstanceType(ManagedInstanceType managedInstanceType) {
            this.managedInstanceType = managedInstanceType;
            this.__explicitlySet__.add("managedInstanceType");
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            this.__explicitlySet__.add("hostname");
            return this;
        }

        public Builder hostId(String hostId) {
            this.hostId = hostId;
            this.__explicitlySet__.add("hostId");
            return this;
        }

        public Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public Builder agent(Agent agent) {
            this.agent = agent;
            this.__explicitlySet__.add("agent");
            return this;
        }

        public Builder approximateApplicationCount(Integer approximateApplicationCount) {
            this.approximateApplicationCount = approximateApplicationCount;
            this.__explicitlySet__.add("approximateApplicationCount");
            return this;
        }

        public Builder approximateInstallationCount(Integer approximateInstallationCount) {
            this.approximateInstallationCount = approximateInstallationCount;
            this.__explicitlySet__.add("approximateInstallationCount");
            return this;
        }

        public Builder approximateJreCount(Integer approximateJreCount) {
            this.approximateJreCount = approximateJreCount;
            this.__explicitlySet__.add("approximateJreCount");
            return this;
        }

        public Builder drsFileStatus(DrsFileStatus drsFileStatus) {
            this.drsFileStatus = drsFileStatus;
            this.__explicitlySet__.add("drsFileStatus");
            return this;
        }

        public Builder applicationInvokedBy(String applicationInvokedBy) {
            this.applicationInvokedBy = applicationInvokedBy;
            this.__explicitlySet__.add("applicationInvokedBy");
            return this;
        }

        public Builder timeStart(Date timeStart) {
            this.timeStart = timeStart;
            this.__explicitlySet__.add("timeStart");
            return this;
        }

        public Builder timeEnd(Date timeEnd) {
            this.timeEnd = timeEnd;
            this.__explicitlySet__.add("timeEnd");
            return this;
        }

        public Builder timeFirstSeen(Date timeFirstSeen) {
            this.timeFirstSeen = timeFirstSeen;
            this.__explicitlySet__.add("timeFirstSeen");
            return this;
        }

        public Builder timeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = timeLastSeen;
            this.__explicitlySet__.add("timeLastSeen");
            return this;
        }

        public ManagedInstanceUsage build() {
            ManagedInstanceUsage model = new ManagedInstanceUsage(this.managedInstanceId, this.managedInstanceType, this.hostname, this.hostId, this.operatingSystem, this.agent, this.approximateApplicationCount, this.approximateInstallationCount, this.approximateJreCount, this.drsFileStatus, this.applicationInvokedBy, this.timeStart, this.timeEnd, this.timeFirstSeen, this.timeLastSeen);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ManagedInstanceUsage model) {
            if (model.wasPropertyExplicitlySet("managedInstanceId")) {
                this.managedInstanceId(model.getManagedInstanceId());
            }
            if (model.wasPropertyExplicitlySet("managedInstanceType")) {
                this.managedInstanceType(model.getManagedInstanceType());
            }
            if (model.wasPropertyExplicitlySet("hostname")) {
                this.hostname(model.getHostname());
            }
            if (model.wasPropertyExplicitlySet("hostId")) {
                this.hostId(model.getHostId());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            if (model.wasPropertyExplicitlySet("agent")) {
                this.agent(model.getAgent());
            }
            if (model.wasPropertyExplicitlySet("approximateApplicationCount")) {
                this.approximateApplicationCount(model.getApproximateApplicationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateInstallationCount")) {
                this.approximateInstallationCount(model.getApproximateInstallationCount());
            }
            if (model.wasPropertyExplicitlySet("approximateJreCount")) {
                this.approximateJreCount(model.getApproximateJreCount());
            }
            if (model.wasPropertyExplicitlySet("drsFileStatus")) {
                this.drsFileStatus(model.getDrsFileStatus());
            }
            if (model.wasPropertyExplicitlySet("applicationInvokedBy")) {
                this.applicationInvokedBy(model.getApplicationInvokedBy());
            }
            if (model.wasPropertyExplicitlySet("timeStart")) {
                this.timeStart(model.getTimeStart());
            }
            if (model.wasPropertyExplicitlySet("timeEnd")) {
                this.timeEnd(model.getTimeEnd());
            }
            if (model.wasPropertyExplicitlySet("timeFirstSeen")) {
                this.timeFirstSeen(model.getTimeFirstSeen());
            }
            if (model.wasPropertyExplicitlySet("timeLastSeen")) {
                this.timeLastSeen(model.getTimeLastSeen());
            }
            return this;
        }
    }
}

